<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class DShield extends Airmesh_Controller
{
	protected function build_vehicles_filter()
	{
		$fields = array(
			array(
				'field_name'	=>	'ae_id',
				'filter_val'	=>	'( SELECT MAX(ae_id) FROM avl_event WHERE ae_imei = ahw_imei )',
				'field_type'	=>	SQLFieldType::ANY
			),
			array(
				'field_name'	=>	'ae_gpsstatus',
				'filter_val'	=>	'V',
				'filter_type'	=>	SQLFilterType::UNEQUALS
			),
			array(
				'order_by'		=>	'af_name',
				'order_dir'		=>	'ASC',
				'null_order'	=>	'LAST'
			),
			array(
				'order_by'		=>	'state',
				'order_dir'		=>	'ASC'
			)
		);
		
		return SQL::build_query_filter( $fields );
	}
	
	protected function map_get_basic_data( $uid = NULL )
	{
		require_once( LIBSPATH . 'maps/maps.php' );
		
		$this->load->model('AvlHardware_model');
		$this->load->model('AvlFleet_model');
		$this->load->model('Keychain_model');
		$this->load->model('Radar_model');
		$this->load->model('Company_model');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidPhoto_model');
		
		$data	= array();
		
		if ( $this->user->is_logged_as_user() )
		{
			$uid			= $this->user_id();
		}
		
		$filter_company			= $this->user->get_company_ids();
		
		$this->set_map_data( $data );
		
		$data['vehicles']		= $this->AvlHardware_model->get_all_for_map( $filter_company, $this->build_vehicles_filter(), NULL, $uid, 'af_name, ' );
		$data['vehicles_count']	= $this->AvlHardware_model->count( $filter_company );
		$data['dkeep_count']	= $this->Keychain_model->count( $filter_company );
		$data['geotrace_data']	= json_encode( $data['vehicles'] );
		$data['radars']			= $this->Radar_model->get_all( $filter_company );
		$data['radars_count']	= $this->Radar_model->count( $filter_company );
		$data['radars_data']	= json_encode( $data['radars'] );
		$data['urfid_count']	= $this->RfidUser_model->count_inside( $filter_company );
		$data['receivers']		= $this->Company_model->get_receivers( $filter_company );
		$data['insurance_pending']	= $this->RfidUser_model->get_not_validated_insurances_count( $filter_company );
		$data['new_workers']	= $this->RfidUser_model->get_recently_created_workers_count( $filter_company );
		
		HardwareMap::prepare_receivers( $data['receivers'] );
		
		$data['receivers_data']	= json_encode( $data['receivers'] );
		
		$data['update_url']		= base_url('dshield/map_update/'.$uid);
		
		return $data;
	}
	
	protected function build_event_filters( $from_ref = NULL, $to_ref = NULL, $rve_id = NULL, $urfid_id = NULL )
	{
		$filter				= array(
			array(
				'field_name'	=>	'name',
				'filter_val'	=>	get_var( 'name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'rve_id',
				'filter_val'	=>	$rve_id
			),
			array(
				'field_name'	=>	'urfid_name',
				'filter_val'	=>	get_var( 'urfid_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'urfid_dni',
				'filter_val'	=>	get_var( 'urfid_dni' ),
				'field_type'	=> SQLFieldType::INT
			),
			array(
				'field_name'	=>	'parent_urfid_id',
				'filter_val'	=>	$urfid_id != NULL ? $urfid_id : get_var( 'urfid_id' ),
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	'time_end',
				'filter_val'	=>	NULL != $to_ref ? get_timestamp_from_date_time( $to_ref ) : NULL,
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ
			),
			array(
				'field_name'	=>	'time_start',
				'filter_val'	=>	NULL != $from_ref ? get_timestamp_from_date_time( $from_ref ) : time() - 3600,
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			),
			array(
				'order_by'		=>	get_var_def( 'order_by', 'time_start' ),
				'order_fields'	=>	array( 'urfid_id', 'urfid_name', 'name', 'urfid_dni', 'urfid_plate', 'time_start', 'time_end', 'urfid_plot' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		$this->load->model('RfidVisit_model');
		
		if ( -1 == str_starts_with( 'Filtrar', get_var('from') ) )
		{
			$data['from'] = $from_ref	= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : NULL;
		}
		else
		{
			$data['from'] = $from_ref	= NULL;
		}
		
		if ( -1 == str_starts_with( 'Filtrar', get_var('to') ) )
		{
			$data['to']	= $to_ref		= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : NULL;
		}
		else
		{
			$data['to']	= $to_ref		= NULL;
		}
		
		if ( $data['to'] < $data['from'] )
		{
			$new_from		= $data['to'];
			$data['to']		= $data['from'];
			$data['from']	= $new_from;
		}
		
		$data['urfid_name']			= get_var( 'urfid_name' );
		$data['urfid_dni']			= get_var( 'urfid_dni' );
		$data['urfid_plot']			= get_var( 'urfid_plot' );
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		
		$query_filter				= $this->build_event_filters( $from_ref, $to_ref );
		$config['total_rows']		= $data['total_events']	= $this->RfidVisit_model->count( $this->user->get_company_ids(), $query_filter );
		$data['events']				= $events = $this->RfidVisit_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/dshield/all/?' . http_build_query_pagination() );
		$data['main_guard']			= TRUE;
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'dshield/main_guard', $data );
	}
	
	public function timeframe_update_state()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('CompanyTimeFrame_model');
		
		$data['time_frame_in']		= $this->CompanyTimeFrame_model->is_active( $this->user->get_company(), 0 );
		$data['time_frame_out']		= $this->CompanyTimeFrame_model->is_active( $this->user->get_company(), 1 );
		
		if ( $data['time_frame_in'] == TRUE )
		{
			$config = $this->CompanyTimeFrame_model->get( $this->user->get_company(), 0 );
			$time_end		= $config['ctf_time_end'];
			$time_pending	= $time_end - time();
			
			$this->kajax->addClass('.time_btn_0', 'active');
			$this->kajax->timeout_start();
			$this->kajax->removeClass('.time_btn_0', 'active');
			$this->kajax->timeout_stop( $time_pending * 1000 );
		}
		
		if ( $data['time_frame_out'] == TRUE )
		{
			$config = $this->CompanyTimeFrame_model->get( $this->user->get_company(), 1 );
			$time_end		= $config['ctf_time_end'];
			$time_pending	= $time_end - time();
			
			$this->kajax->addClass('.time_btn_1', 'active');
			$this->kajax->timeout_start();
			$this->kajax->removeClass('.time_btn_1', 'active');
			$this->kajax->timeout_stop( $time_pending * 1000 );
		}
		
		$this->kajax->out();
	}
	
	public function map( $uid = NULL )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->add_frame_view( 'dshield/main', $this->map_get_basic_data( $uid ) );
	}
	
	public function map_update( $uid = NULL )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		echo json_encode( $this->map_get_basic_data( $uid ) );
	}
	
	public function index()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->is_guard() || ( $this->user->is_normal_dshield_admin() && is_tablet_browser() ) )
		{
			$this->all();
		}
		else if ( $this->user->is_professional() )
		{
			$this->professional_index();
		}
		else if ( $this->user->is_logged_as_user() )
		{
			$this->user_index();
		}
		else
		{
			$this->map();
		}
	}
	
	public function control()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$this->load->model('GlobalEvent_model');
			$this->load->model('DShieldEventStates_model');
			
			$data							= $this->map_get_basic_data();
			$data['events']					= $this->GlobalEvent_model->get_latests_dshield_events( $this->user->get_company_ids(), $this->user );
			
			$this->events_verify( $data['events'], $this->user->get_company_ids(), $this->user, NULL );
			
			$data['events_count']			= isset( $data['events'] ) ? count($data['events']) : 0;
			$data['last_event_id']			= isset( $data['events'] ) ? $data['events'][0]['id'] : NULL;
			$data['control_jobs_url']		= base_url('/dshield/control_jobs');
			$data['event_get_url']			= base_url('/dshield/event_data');
			$data['chat_send_url']			= base_url('/dshield/event_chat_send');
			$data['event_push_url']			= base_url('/dshield/event_push');
			
			$data['dshield_event_states']	= $this->DShieldEventStates_model->get_all( $this->event_state_build_query_filter( $this->user->get_company() ) ); 
			
			$this->add_frame_view( 'dshield/control', $data );
		}
		else
		{
			$data['msg'] = "<h2>No posees permisos para ingresar a esta sección</h2>";
			$this->add_frame_view( 'msg_screen', $data );
		}
	}
	
	public function events_export()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$this->load->model('GlobalEvent_model');
			
			$from_ref	= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : $hour_ago;
			$to_ref		= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : $now;
			$from		= NULL != $from_ref ? get_timestamp_from_date_time( $from_ref ) : NULL;
			$to			= NULL != $to_ref ? get_timestamp_from_date_time( $to_ref ) : NULL;
			
			$filename	= 'dshield events - ' . $from_ref . ' - ' . $to_ref;
			$sep		= CSV_SEPARATOR;
			csv_create_header( $filename );
			
			$events	= $this->GlobalEvent_model->get_parsed_events( $this->user->get_company_ids(), $this->user, $from, $to );
			
			$data = '"Fecha"' . $sep . '"Abonado"' . $sep . '"Descripción"' . "\r\n";
			
			if ( isset( $events ) )
			{
				csv_array_sanitize( $events );
				
				foreach ( $events as $e )
				{
					if ( GlobalEventType::DKEEP == $e['type'] && $e['reported_by'] )
					{
						$e['desc'] .= '. Reportado por abonado: ' . $e['reported_by'] . '.';
					}
					
					$data.= '"' . $e['time'] . '"' . $sep . 
							'"' . $e['target'] . '"' . $sep . 
							'"' . $e['desc'] . '"' . "\r\n";
				}
			}
			
			echo @iconv( 'utf-8', 'iso-8859-1', $data );
		}
	}
	
	protected function get_event( $hw_id, $event_id )
	{
		$this->load->model('DShieldEvent_model');
		
		$event			= $this->DShieldEvent_model->by_event_id( $event_id );
		
		if ( !isset( $event ) )
		{
			$event		= $this->DShieldEvent_model->by_relation( $event_id );
			
			if ( !isset( $event ) )
			{
				$event	= $this->DShieldEvent_model->by_date( $hw_id, $event_id );
				
				if ( !isset( $event ) )
				{
					$event	= $this->DShieldEvent_model->by_near_date( $hw_id, $event_id );
					
					if ( !isset( $event ) )
					{
						$event				= $this->DShieldEvent_model->get_open( $hw_id );
						
						if ( !isset( $event ) )
						{
							$dse_id	= $this->DShieldEvent_model->add( $event_id, $this->user->get_company(), $hw_id, $this->user->get_user_id() );
							
							$event	= $this->DShieldEvent_model->get( $dse_id );
						}
						else
						{
							$this->DShieldEvent_model->add_relation( $event['dse_id'], $event_id );
						}
					}
					else
					{
						$this->DShieldEvent_model->add_relation( $event['dse_id'], $event_id );
					}
				}
				else if ( $event['dse_event_id'] != $event_id )
				{
					$this->DShieldEvent_model->add_relation( $event['dse_id'], $event_id );
				}
			}
		}
		
		return $event;
	}
	
	public function event_data()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$posts = $this->input->post();
			
			$this->load->model('DShieldEventChat_model');
			$this->load->model('GlobalEvent_model');
			
			$event				= $this->get_event( $posts['event_hw_id'], $posts['event_selected_id'] );
			$last_chat_id		= isset( $posts['event_last_chat_id'] ) ? intval( $posts['event_last_chat_id'] ) : 0;
			$data['event_data']	= $event;
			$data['event_msgs']	= $this->DShieldEventChat_model->get_conversation( $event['dse_id'], $last_chat_id );
			$data['events']		= $this->GlobalEvent_model->get_latests_dshield_events( $this->user->get_company_ids(), $this->user, NULL, $data['event_data']['dse_hw_id'], 3 );
			
			echo json_encode( $data );
		}
	}
	
	protected function events_verify( &$events, $company_ids, $user, $last_event_id )
	{
		if ( isset( $events ) )
		{
			$updated = FALSE;
			
			foreach ( $events as $event )
			{
				if ( $event['emergency'] && !isset( $event['dse_id'] ) )
				{
					$updated = TRUE;
					
					$this->get_event( $event['hw_id'], $event['id'] );
				}
			}
			
			if ( $updated )
			{
				$events = $this->GlobalEvent_model->get_latests_dshield_events( $company_ids, $user, intval( $last_event_id ) );
			}
		}
	}
	
	public function control_jobs()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$this->load->model('GlobalEvent_model');
			$this->load->model('DShieldEvent_model');
			
			$posts = $this->input->post();
			
			$data['events']	= $this->GlobalEvent_model->get_latests_dshield_events( $this->user->get_company_ids(), $this->user, intval( $posts['last_event_id'] ) );
			
			$this->events_verify( $data['events'], $this->user->get_company_ids(), $this->user, intval( $posts['last_event_id'] ) );
			
			$data['events_data'] = $this->DShieldEvent_model->get_events( $this->user->get_company_ids() );
			
			if ( isset( $posts['event_id'] ) && 0 != intval( $posts['event_id'] ) )
			{
				$this->load->model('DShieldEventChat_model');
				
				$last_chat_id		= isset( $posts['event_last_chat_id'] ) ? intval( $posts['event_last_chat_id'] ) : 0;
				$data['event_data']	= $this->DShieldEvent_model->get( $posts['event_id'] );
				$data['event_msgs']	= $this->DShieldEventChat_model->get_conversation( $posts['event_id'], $last_chat_id );
			}
			
			echo json_encode( $data );
		}
	}
	
	public function event_chat_send()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$posts = $this->input->post();
		
		if ( $this->user->can_control_dshield() )
		{
			if ( isset( $posts['event_hw_id'] ) && 0 != intval( $posts['event_hw_id'] ) )
			{
				$this->load->model('DShieldEventChat_model');
				
				$this->DShieldEventChat_model->add( $posts['event_hw_id'], $this->user->get_user_id(), $posts['msg'] );
			}
		}
	}
	
	protected function event_state_build_query_filter( $com_id )
	{
		$filter = array(
			array(
				'field_name'	=> 'des_com_id',
				'filter_val'	=> $com_id
			),
			array(
				'field_name'	=>	'des_name',
				'filter_val'	=>	get_var( 'des_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'des_name' ),
				'order_fields'	=> array( 'des_name' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function event_states()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('DShieldEventStates_model');
		
		$data['states'] = $this->DShieldEventStates_model->get_all( $this->event_state_build_query_filter( $this->user->get_company() ) );
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		
		$this->add_frame_view( 'dshield/states', $data );
	}
	
	public function event_state_row()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$data = array();
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		
		$this->kajax->prepend( '#event_states_list_table', $this->load->view( 'dshield/new_row_event_state', $data, TRUE ) );
		$this->kajax->out();
	}
	
	public function event_state_update()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[40]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$id = isset( $post['id'] ) ? intval( $post['id'] ) : 0;
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->load->model('DShieldEventStates_model');
			
			if ( $id == 0 )
			{
				$post['company'] = User()->is_logged_as_god() ? $post['com_id'] : User()->get_company();
				
				$id = $this->DShieldEventStates_model->add( $post['company'], $post['name'] );
				
				$this->id_replace( $id );
				
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "id", "' . base_url('/dshield/event_state_delete/'.$id) . '", "Seguro que desea eliminar el tipo de cedulación?" )' );
				
				$this->kajax->fancy_log_success( "Cedulación: " . $post['name'] . " añadida con éxito." );
			}
			else
			{
				if ( $this->DShieldEventStates_model->exists( $id )  )
				{
					$this->DShieldEventStates_model->update( $id, $post['name'] );
					
					$this->kajax->fancy_log_success( "Cedulación: " . $post['name'] . " guardada con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error(  "Cedulación: " . $post['name'] . " no existe." );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $id );
		
		$this->kajax->out();
	}
	
	public function event_state_delete( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('DShieldEventStates_model');
		
		$this->DShieldEventStates_model->delete( $id );
		
		$this->kajax->remove('#row_'.$id);
		$this->kajax->remove('#row_hidden_'.$id);
		
		$this->kajax->fancy_log_success( 'Estado de evento eliminado' );
		
		$this->kajax->out();
	}
	
	protected function id_replace( $id )
	{
		$this->kajax_replace_new_ids( $id, array( 'row_', 'row_hidden_' ) );
	}
	
	public function event_push()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$this->load->model('DShieldEvent_model');
			$this->load->model('DShieldEventHistory_model');
			
			$post = $this->input->post();
			
			if ( isset( $post['state'] ) && 0 != strlen( $post['state'] ) )
			{
				$this->DShieldEvent_model->update( $post['id'], $post['state'], $post['observations'], $this->user->get_user_id(), pp_date_now() );
				
				$this->DShieldEventHistory_model->add( $post['id'], $post['state'], $post['observations'], $this->user->get_user_id() );
				
				$event = $this->DShieldEvent_model->get( $post['id'] );
				$event_json = json_encode( $event );
				
				$this->kajax->call('var event_obj = ' . $event_json . '; dshield_event_update_status( event_obj )');
				
				$this->kajax->fancy_log_success( 'Evento cedulado exitosamente.' );
			}
			else
			{
				$this->kajax->fancy_log_error( 'Debes asignar un estado a la cedulación.' );
			}
			
			$this->kajax->out();
		}
	}
	
	public function event_history( $dse_id )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->can_control_dshield() )
		{
			$this->load->model('DShieldEventHistory_model');
			
			$data['events'] = $this->DShieldEventHistory_model->get_all( $dse_id );
			
			$this->load->view( 'dshield/event_history', $data );
		}
	}
	
	protected function professional_index()
	{
		$this->redirect( base_url('/dshield/person/all' ) );
	}
	
	public function time_frame_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('CompanyTimeFrameConfig_model');
		
		$data['config'] = $this->CompanyTimeFrameConfig_model->get( $this->user->get_company() );
		
		$this->load->view('dshield/time_frame_config', $data);
	}
	
	public function time_frame_insert()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('CompanyTimeFrameConfig_model');
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'time_in', 
				'label'   => 'Ingreso', 
				'rules'   => 'trim|required|integer|max_length[40]'
			),
			array(
				'field'   => 'time_out', 
				'label'   => 'Egreso', 
				'rules'   => 'trim|required|integer|max_length[40]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->CompanyTimeFrameConfig_model->update( $post['id'], $post['time_in'], $post['time_out'] );
			
			$this->kajax->fancy_log_success( "Configuración de Ventana de tiempo guardada" );
			
			$this->kajax->call('modal_dialog_close()');
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules );
		
		$this->kajax->out();
	}
	
	public function time_frame_init( $type )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidCityMesh_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('RfidUser_model');
		$this->load->model('CompanyTimeFrame_model');
		$this->load->model('CompanyTimeFrameConfig_model');
		
		$com_id = $this->user->get_company();
		$config = $this->CompanyTimeFrameConfig_model->get( $com_id );
		
		if ( !$this->CompanyTimeFrame_model->is_active( $com_id, $type ) )
		{
			$type_str 	= $type == RfidCitymeshType::ENTRY ? 'Ingreso' : 'Egreso';
			$field_name	= $type == RfidCitymeshType::ENTRY ? 'ctfc_time_in' : 'ctfc_time_out';
			
			$time_start	= time();
			$time_period	= $config[$field_name] * 60;
			$time_end	= $time_start + $time_period;
			
			$id = $this->CompanyTimeFrame_model->add( $com_id, $type, $time_start, $time_end );
			
			$urfid = $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
			
			$this->RfidEvent_model->add( $id, $this->user->get_user_id(), RfidType::TIME_FRAME, $type, time(), $com_id, 'ACCEPTED', isset( $urfid ) ? $urfid['urfid_id'] : 0 );
			
			$this->kajax->fancy_log_success( 'Ventana de tiempo para ' . $type_str . ' activada por ' . $config[$field_name] . ' minutos.'  );
			
			$this->kajax->addClass('.time_btn_'.$type, 'active');
			
			$this->kajax->timeout_start();
			$this->kajax->removeClass('.time_btn_'.$type, 'active');
			$this->kajax->timeout_stop( $time_period * 1000 );
		}
		else
		{
			$this->kajax->fancy_log_error( 'La funcionalida de ventana de tiempo ya se encuentra activa' );
		}
		
		$this->kajax->out();
	}
	
	public function access_restriction()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RfidCitymeshRestriction_model');
		
		$data['restrictions'] = $r = $this->RfidCitymeshRestriction_model->get_all( $this->user->get_company() );
		
		$user_type_r = array();
		
		if ( null != $r )
		{
			foreach ( $r as $res )
			{
				$user_type_r[ $res['rc_id'] ][] = $res;
			}
		}
		
		$data['user_type_r'] = $user_type_r;
		
		$this->load->helper('hours');
		$this->load->model('RfidUserTypeHours_model');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidCitymesh_model');
		$this->load->model('RfidCitymeshRestriction_model');
		
		for ( $user_type = RfIdUserType::FIRST; $user_type <= RfIdUserType::WORKER; $user_type++ )
		{
			for ( $rc_type = 0; $rc_type <= 1; $rc_type++ )
			{
				$data['user_type_hours'][$user_type][$rc_type] = $this->RfidUserTypeHours_model->build_hour_table( $user_type, $rc_type );
			}
		}
		
		$this->add_frame_view( 'dshield/citymesh_access_restrictions', $data );
	}
	
	public function access_restriction_save()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		
		if ( $this->user->is_guard() || $this->user->is_professional() )
		{
			return;
		}
		
		$this->load->model('RfidCitymeshRestriction_model');
		
		$post = $this->input->post();
		
		$this->RfidCitymeshRestriction_model->save_form( $this->user->get_company(), $post );
		
		$this->kajax->fancy_log_success('Restricciones de Accesos guardadas.');
		
		$this->kajax->out();
	}
	
	public function user_type_hours_save()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$user_type = get_post('user_type');
		$rc_type = get_post('rc_type');
		
		if ( isset( $user_type ) && isset( $rc_type ) )
		{
			$this->load->model( 'RfidUserTypeHours_model' );
			
			$this->RfidUserTypeHours_model->save( $user_type, $rc_type, $this->input->post() );
			
			$this->kajax->fancy_log_success( 'Franja Horaria Guardada Exitosamente' );
		}
		else
		{
			$this->kajax->fancy_log_error( "No puedes modificar la franja horaria." );
		}
		
		$this->kajax->out();
	}
}
