<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cron extends BASE_Controller
{
	public function backup_db()
	{
		set_time_limit(0);
		
		$sec_code	= get_var( 'code' );

		if ( $sec_code == 'RDI8SKLwcuFhv988p55qcJc0rB5azcuzKYJgFyiJCiaFQM8nzRYZpsOqFsPqjgmW' )
		{
			$d      = date('d-m-Y');
			$OF     = ROOTPATH. "backups/domo.$d.sql.gz";

			echo "Creating file $OF<br/>";
			
			$ret = pipe_exec( "PGPASSWORD=" . $this->db->password .  " pg_dump -Z 9 -U " . $this->db->username . " -h " . $this->db->hostname . " -f $OF -c domo" );
			
			$ret['result']	= $ret[0];
			$ret['file']	= $OF;
			$ret['error']	= '';
			
			$err = $ret[0];
			
			if ( 0 == $err )
			{
				echo "<br/>Backup created successfully<br/>";
				
				$OF     = ROOTPATH. "backups/domo.hardware.$d.sql.gz";
				
				$ret = pipe_exec( "PGPASSWORD=" . $this->db->password .  " pg_dump -Z 9 -U " . $this->db->username . " -h " . $this->db->hostname . " -t hardware -f $OF -c domo" );
				
				$ret['result']	= $ret[0];
				$ret['file']	= $OF;
				$ret['error']	= '';
				
				$err = $ret[0];
				
				if ( 0 == $err )
				{
					echo "<br/>Hardware table backup created successfully<br/>";
				}
				else
				{
					echo "<br/>Hardware table failed to create<br/>";
					
					echo $ret[2];
				
					$ret['error']	= $ret[2];
				}
			}
			else
			{
				echo "<br/>Backup failed to create:<br/>";
				
				echo $ret[2];
				
				$ret['error']	= $ret[2];
			}
			
			return $ret;
		}
		
		return NULL;
	}
	
	public function upload_backup()
	{
		set_time_limit(0);
		
		$sec_code	= get_var( 'code' );
		
		if ( $sec_code == 'RDI8SKLwcuFhv988p55qcJc0rB5azcuzKYJgFyiJCiaFQM8nzRYZpsOqFsPqjgmW' )
		{
			$d			= date('d-m-Y');
			$filename	= "domo.$d.sql.gz";
			$OF			= ROOTPATH. "backups/$filename";
			$uploaded	= ROOTPATH. "backups/$filename.uploaded";
			
			if ( file_exists( $OF ) && !file_exists( $uploaded ) )
			{
				$upload_as = '';
				
				if ( SERVER_NAME == 'arenasdelsur' || SERVER_NAME == 'bsvr' || SERVER_NAME == 'spartan' )
				{
					$upload_as = SERVER_NAME;
				}
				
				$running = pipe_exec( "pidof rsync" );
				
				if ( $running[0] == 0 )
				{
					echo "rsync already running.";
					return;
				}
				
				if ( !empty( $upload_as ) )
				{
					$rsa = ROOTPATH . 'id_rsa';
					#$cmd = "scp -v -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o GlobalKnownHostsFile=/dev/null -i $rsa $OF " . SERVER_NAME . "@reddomo.com.ar:/home/" . SERVER_NAME . "/domo/backups/" . $filename;
					$cmd = "rsync -v -e 'ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o GlobalKnownHostsFile=/dev/null -i $rsa' --partial --append-verify -avz $OF " . SERVER_NAME . "@reddomo.com.ar:/home/" . SERVER_NAME . "/domo/backups/";
					
					$ret = pipe_exec( $cmd );
					
					if ( $ret[0] == 0 )
					{
						//file_put_contents( $uploaded, "1" );
						
						echo "<br/>Backup uploaded to domo.";
					}
					else
					{
						echo "<br/>Backup failed to create:<br/>";
						
						echo nl2br( $ret[2] ) . '<br/>';
						
						echo $cmd;
					}
				}
				else
				{
					echo "Server not supported";
				}
			}
			else if ( file_exists( $uploaded ) )
			{
				echo "Todays file already uploaded to server.";
			}
		}
	}
	
	public function sync_resources()
	{
		set_time_limit(0);
		
		$sec_code	= get_var( 'code' );
		
		if ( $sec_code == 'RDI8SKLwcuFhv988p55qcJc0rB5azcuzKYJgFyiJCiaFQM8nzRYZpsOqFsPqjgmW' )
		{
			$folders = array( 'photos', 'radars_logos', 'tickets' );
			$upload_as = '';
			
			if ( SERVER_NAME == 'arenasdelsur' || SERVER_NAME == 'bsvr' || SERVER_NAME == 'spartan' )
			{
				$upload_as = SERVER_NAME;
			}
			
			$running = pipe_exec( "pidof rsync" );
			
			if ( $running[0] == 0 )
			{
				echo "rsync already running.";
				return;
			}
			
			if ( !empty( $upload_as ) )
			{
				foreach ( $folders as $folder )
				{
					$rsa = ROOTPATH . 'id_rsa';
					$cmd = "rsync -v -e 'ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o GlobalKnownHostsFile=/dev/null -i $rsa' -avzr /home/domo/assets/$folder/ " . SERVER_NAME . "@reddomo.com.ar:/home/" . SERVER_NAME . "/domo/assets/$folder/";
					$ret = pipe_exec( $cmd );
					
					if ( $ret[0] == 0 )
					{
						echo "<br/>Synced $folder " . SERVER_NAME . "-domo.";
					}
					else
					{
						echo "<br/>Sync failed for " . SERVER_NAME . ":<br/>";
						
						echo nl2br( $ret[2] );
						
						echo $cmd;
						
						break;
					}
				}
			}
			else
			{
				echo "Server not supported";
			}
		}
	}
	
	public function load_backup()
	{
		set_time_limit(0);
		
		$sec_code	= get_var( 'code' );
		
		if ( $sec_code == 'RDI8SKLwcuFhv988p55qcJc0rB5azcuzKYJgFyiJCiaFQM8nzRYZpsOqFsPqjgmW' )
		{
			$d				= date('d-m-Y');
			$sqlfilename	= "domo.$d.sql";
			$sqlpath		= ROOTPATH. "backups/$sqlfilename";
			$filename		= $sqlfilename . ".gz";
			$OF				= ROOTPATH. "backups/$filename";
			
			if ( file_exists( $OF ) || file_exists( $sqlpath ) )
			{
				if ( file_exists( $OF ) )
				{
					$ret = pipe_exec( "gunzip " . $OF );
					
					if ( $ret[0] != 0 )
					{
						echo "Extract failed!.<br/>";
						return;
					}
				}
				
				if ( 'domo' == $this->db->database )
				{
					echo "Something is wrong, you're trying to load a backup for the main database.";
					return;
				}
				
				if ( 0 == $ret[0] && file_exists( $sqlpath ) )
				{
					$this->db->query( "DROP SCHEMA public CASCADE;" );
					$this->db->query( "CREATE SCHEMA public;" );
					
					$ret = pipe_exec( "psql -h localhost -d " . $this->db->database . " -U postgres < " . $sqlpath );
					
					if ( 0 == $ret[0] )
					{
						@unlink( $sqlpath );
						
					
						echo "Updated database: " . $this->db->database;
					}
					else
					{
						echo "Failed updating database: " . $this->db->database . "<br/>";
						
						echo $ret[2];
					}
				}
				else
				{
					echo "Something went wrong.";
				}
			}
		}
	}
	
	public function active_hw_count()
	{
		$sec_code	= get_var( 'code' );

		if ( $sec_code == 'oBxvnmgpPlt1UcqbK2TLpu8oUe75HOUwwj3Dqr8XP34eMxWx1yx7YxeyufrGnX72' )
		{
			$this->load->model('Company_model');
			
			$db		= db_get();
			$day	= date('d-m-Y');
			$res	= $this->Company_model->get_all_basic_data();
			$str	= '';

			foreach ( $res as $com )
			{
				$id		= $com->com_id;
				$name	= $com->com_name;
				$total	= $db->get_var( 'SELECT COUNT(*) AS total_hw_active FROM ( SELECT * FROM ( SELECT SUM(tl_tests_count) as tl_test_sum FROM tests_log INNER JOIN hardware ON hw_id = tl_hw_id WHERE hw_company = '.$id.' AND tl_from_time >= ' . SQL::unix_timestamp(SQL::get_days_back(1)) . ' AND tl_from_time < ' . SQL::unix_timestamp() . ' GROUP BY tl_hw_id ) hw_sums WHERE tl_test_sum > 60 ) serials_alive' );
				
				if ( !isset($total) )
				{
					$total = 0;
				}
				
				$str .= '"'.$day.'";"'.$name.'";"'.$total.'";'."\n";
				
				$db->query( 'UPDATE  company SET  com_hw_count = '.$total.' WHERE com_id = '.$id );
			}

			$fp = fopen( ROOTPATH . 'exports/total_equipos.csv', 'a+' );
			fwrite( $fp, $str );
			fclose( $fp );
		}
	}
	
	public function actions_timeout()
	{
		require_once( FRAMES_PATH . 'actions.php' );
		
		Actions::handle_timeouts();
	}
	
	public function check_new_hardware()
	{
		$db = db_get();
		$this->load->model( 'MacsIcons_model' );
		$this->load->model( 'Hardware_model' );
		
		define('HARDWARE_TMP_TEST_TOADD',2); //moves hardware from hardware_tmp to hardware after X tests 0x66
		define('HARDWARE_TMP_EXPIRES',60*80); //in sceconds, delete row if no test frame received after... (currently 30 mins)

		$db->set_qd(array(HARDWARE_TMP_EXPIRES));
		$db->query('DELETE FROM hardware_tmp WHERE ' . SQL::secs_from_ts( 'hwt_time_lasttest' ) . ' > ?');

		$db->set_qd(array(HARDWARE_TMP_TEST_TOADD));
		$res = $db->get_results('SELECT * FROM hardware_tmp WHERE hwt_testcount >= ?', ARRAY_A);

		if($res)
		{
			$db->trans_start();
			
			foreach($res as $hwd)
			{
				$hw_id = null;
				$hw_user = null;
				$hw_lat = 0;
				$hw_long = 0;
				$hw_address = "";
				$hw_seems_moved = false;

				if( $hwd['hwt_code'] != 0x8888 &&  $hwd['hwt_code'] != 0x1234 )
				{
					$db->set_qd( array(	$hwd['hwt_df_company'], $hwd['hwt_df_receiver'], $hwd['hwt_code'] ) );

					/*si hay varios toma el mas viejo*/
					echo "Searching for " . $hwd['hwt_df_company'] . ' ' . $hwd['hwt_df_receiver'] . ' ' . dechex( $hwd['hwt_code'] ) . "<br/>\n";
					
					$row = $db->get_row("SELECT * FROM hardware WHERE hw_df_company = ? AND hw_df_receiver = ? AND hw_code = ? ORDER BY hw_id ASC LIMIT 1");
					
					if ( null == $row )
					{
						$city = $db->get_var( 'SELECT com_city FROM company WHERE com_df_id = ? AND com_rec_id = ? LIMIT 1', array( $hwd['hwt_df_company'], $hwd['hwt_df_receiver'] ) );
						
						$db->set_qd( array( $hwd['hwt_df_company'],	$hwd['hwt_code'] ) );
						
						$row = $db->get_row("SELECT * FROM hardware WHERE hw_df_company = ? AND hw_code = ? ORDER BY hw_id ASC LIMIT 1");
						
						if (	NULL != $city && 
								NULL != $row && 
								$hwd['hwt_df_company'] == $row->hw_df_company && 
								$city == $row->hw_city && 
								$hwd['hwt_df_receiver'] != $row->hw_df_receiver
						)
						{
							echo 'Hardware seems moved: code ' . dechex( $hwd['hwt_code'] ) . ' company ' . $hwd['hwt_df_company'] . ' receiver ' . $hwd['hwt_df_receiver'] . ' serial ' . $hwd['hwt_serial'] . ' city ' . $city . "<br/>\n";
							echo 'Hardawre id moved: ' . $row->hw_id . "<br/>\n";
							echo json_enc( $row, TRUE );
							
							$hw_seems_moved = true;
						}
						else
						{
							$row = NULL;
						}
					}

					if(null != $row)
					{
						echo "Hardware found!<br/>\n";
						
						$hw_user = $row->hw_user;
						$hw_lat = $row->hw_lat;
						$hw_long = $row->hw_long;
						$hw_address = $row->hw_address;
						$hw_id = $row->hw_id;
					}
				}

				if($hw_user == null)
				{
					$hw_user = 0;
				}
				
				$signal_count		= 0;
				$signal_filtered	= 0;
				
				//*select max timestamp*//
				$sub_query = "(SELECT MAX(sf_hw_timestamp) FROM signal_frames WHERE sf_hw_serial = ? AND sf_frame_data LIKE '______191_')";
				$sql = "SELECT 
							sf_company_code, 
							sf_receiver_code, 
							sf_hw_code, 
							sf_hw_serial, 
							COUNT(sf_id) AS signal,
							COUNT(sf_hw_timestamp) AS signal_filtered
						FROM signal_frames
						WHERE 
							sf_company_code = ? AND sf_receiver_code = ? AND sf_hw_code = ? AND sf_hw_serial = ? AND
							sf_frame_data LIKE '______191_' AND " . 
							SQL::secs_from('sf_hw_timestamp', SQL::from_unix_time($sub_query))." <=	?
						GROUP BY sf_company_code, sf_receiver_code, sf_hw_code, sf_hw_serial
						LIMIT 1";
				
				$signal_res = $db->get_row( $sql, ARRAY_A, array( $hwd['hwt_df_company'], $hwd['hwt_df_receiver'], $hwd['hwt_code'], $hwd['hwt_serial'], $hwd['hwt_serial'], 390 ) );
				
				if ( isset( $signal_res ) )
				{
					$signal_count		= $signal_res['signal'];
					$signal_filtered	= $signal_filtered['signal_filtered'];
				}

				if ( null == $hw_id )
				{
					echo "New hardware found.<br/>\n";
					
					// Search for a fake hardware with the same code+cpny+rec, if it's present it will use the address of the fake hw to create the new hw, and then it will erase the fake hw.
					$db->set_qd( array( $hwd['hwt_code'], $hwd['hwt_df_company'], $hwd['hwt_df_receiver'] ) );
					$row = $db->get_row( 'SELECT * FROM hardware_fake INNER JOIN company ON hwf_company = com_id WHERE hwf_code = ? AND com_df_id = ? AND com_rec_id = ?' );

					$hw_icon = $this->MacsIcons_model->get_icon( $hwd['hwt_serial'] );
					$hw_name = (string)dechex($hwd['hwt_code']);
					
					if ( isset( $row ) )
					{
						$hw_address		= $row->hwf_address;
						$hw_lat			= $row->hwf_lat;
						$hw_long		= $row->hwf_long;
						$hw_icon		= $row->hwf_icon;
						
						if ( '' != $row->hwf_name )
						{
							$hw_name	= $row->hwf_name;
						}
						
						$db->set_qd( array( $row->hwf_id ) );
						$db->query( 'DELETE FROM hardware_fake WHERE hwf_id = ?' );
					}
					
					$hw_id_for_mac = $db->get_var('SELECT hw_id FROM hardware WHERE hw_serial = ?', array( $hwd['hwt_serial'] ) );
					
					$this->db->trans_start();
					
					if ( isset( $hw_id_for_mac ) )
					{
						$this->Hardware_model->delete( $hw_id_for_mac );
					}
					
					$db->set_qd(array(
								$hw_user,
								$hw_lat,
								$hw_long,
								$hw_address,
								$hw_icon,
								$hwd['hwt_df_company'],
								$hwd['hwt_df_receiver'], //hw_df_company, hw_df_receiver
								$hwd['hwt_code'],
								$hw_name, //hw_code ... hw_name = hw_code
								$hwd['hwt_serial'],
								$hwd['hwt_df_company'], $hwd['hwt_df_receiver'],
								$hwd['hwt_df_company'], $hwd['hwt_df_receiver'],
								$signal_count,
								$signal_filtered
							));

					$db->query('INSERT INTO hardware
								(hw_user, hw_lat, hw_long, hw_address, hw_icon, hw_df_company,hw_df_receiver,hw_code,hw_name, hw_serial, hw_city, hw_company, hw_setup_signal, hw_setup_signal_filtered, hw_inst_time, hw_create_time)
								VALUES (?,?,?,?,?,?,?,?,?,?,
									( SELECT com_city FROM company WHERE com_df_id = ? AND com_rec_id = ?),
									( SELECT com_id FROM company WHERE com_df_id = ? AND com_rec_id = ?),
									?,
									?,
									now(),
									now()
							)');
					
					$hw_id	= $db->last_insert_id();
					
					$this->db->trans_complete();
					
					$com_id = $db->get_var( 'SELECT com_id FROM company WHERE com_df_id = ? AND com_rec_id = ?', array( $hwd['hwt_df_company'], $hwd['hwt_df_receiver'] ) );
					$hwgmod = load_model('HardwareGroup_model');
					
					if ( $group = $hwgmod->exists_group_with_icon( $com_id, $hw_icon ) )
					{
						$hwgmod->link( $group, $hw_id );
					}
					
					$this->load->model('HardwarePreLink_model');
					
					$prelinks = $this->HardwarePreLink_model->get_from_mac( $hwd['hwt_serial'] );
					
					if ( isset( $prelinks ) && !empty( $prelinks ) )
					{
						foreach ( $prelinks as $pl )
						{
							$this->Hardware_model->link( $hw_id, $pl['hwpl_user'] );
						}
						
						$this->HardwarePreLink_model->clear_mac( $hwd['hwt_serial'] );
					}
				}
				else
				{
					echo "Updated hardware.<br/>\n";
					
					if ( !$hw_seems_moved )
					{
						$db->set_qd( array( $hwd['hwt_serial'], $hw_id ) );
						
						$db->query( 'UPDATE hardware SET hw_serial = ? WHERE hw_id = ?' );
					}
					else
					{
						echo "Moving hardware to new receiver. company " . $hwd['hwt_df_company'] . " receiver " . $hwd['hwt_df_receiver'] . "<br/>\n";
						
						$com_id = $db->get_var( 'SELECT com_id FROM company WHERE com_df_id = ? AND com_rec_id = ?', array( $hwd['hwt_df_company'], $hwd['hwt_df_receiver'] ) );
						
						$db->set_qd( array( $hwd['hwt_df_receiver'], $com_id, $hwd['hwt_serial'], $hw_id ) );
						
						$db->query( 'UPDATE hardware SET hw_df_receiver = ?, hw_company = ?, hw_serial = ? WHERE hw_id = ?' );
						
						$db->query( 'DELETE FROM hardware_group_link WHERE hwgl_hw_id = ?', array( $hw_id ) );
					}
					
					$this->load->model('HardwareSetupSignalHistory_model');
					
					$first = true;
					
					// Get all the hardware setup signal history from that serial
					$hwsshs = $this->HardwareSetupSignalHistory_model->get_from_serial( $hwd['hwt_serial'] );
					
					if ( NULL != $hwsshs )
					{
						foreach ( $hwsshs as &$hwssh )
						{
							// Check if the hw code is different from the history
							if ( $hwssh['hwsh_hw_code'] != $hwd['hwt_code'] )
							{
								// if the hw code is different and the setup signal register is not already added
								if ( !$this->HardwareSetupSignalHistory_model->exists(	$hwd['hwt_df_company'], $hwd['hwt_df_receiver'], $hwd['hwt_code'], 
																						$hwd['hwt_serial'], $hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'] ) )
								{
									// We add the setup signal history with the new code
									$id = $this->HardwareSetupSignalHistory_model->add(
										$hwd['hwt_df_company'], $hwd['hwt_df_receiver'], $hwd['hwt_code'], $hwd['hwt_serial'], $hwssh['hwsh_inst_time'],
										$hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'], $hwssh['hwsh_signal'], $hwssh['hwsh_signal_filtered'] 
									);
									
									// Since the query is from newest to oldest, i add the first result
									if ( $first )
									{
										$db->set_qd( array( $hwssh['hwsh_signal'], $hwssh['hwsh_signal_filtered'], $hwssh['hwsh_inst_time'], $hw_id ) );
										
										$db->query( 'UPDATE hardware SET hw_setup_signal = ?, hw_setup_signal_filtered = ?, hw_inst_time = ? WHERE hw_id = ?' );
										
										$first = false;
									}
								}
							}
						}
					}
				}
				
				$db->set_qd(array($hwd['hwt_id']));
				$db->query('DELETE FROM hardware_tmp WHERE hwt_id = ?');
			}
			
			$db->trans_complete();
		}
		else
		{
			echo "No results";
		}
	}
	
	public function clean_global_events()
	{
		$sec_code	= get_var( 'code' );
		
		if ( $sec_code == 'RDI8SKLwcuFhv988p55qcJc0rB5azcazKYJgFyiJCiaFQM8nzRYZpsOqFsPqjgmW' )
		{
				$TIMEOUT_SECONDS = 3600*24*60;
		
				$this->db->query( 'DELETE FROM global_event WHERE ' . SQL::secs_from( 'ge_time' ) . ' > ?', array($TIMEOUT_SECONDS) );
		}
	}
	
	public function clean_console_log()
	{
		$db = db_get();
		
		define('TIMEOUT_SECONDS',3600*24*5); //3600 seconds = 1 hour - 24 hours - 5 days

		$db->set_qd(array(TIMEOUT_SECONDS));
		$db->query('DELETE FROM receiver_console_log WHERE ' . SQL::secs_from_ts( 'rcl_time' ) . ' > ?');
		
		$month = (3600*24*30);
		$db->set_qd(array( $month ));
		$db->query('DELETE FROM receiver_geotrace_log WHERE ' . SQL::secs_from_ts( 'rgl_time' ) . ' > ?');
	}
	
	protected function build_delete_list($hw_list)
	{
		$delete_list = '';
		$one_active = false;

		foreach($hw_list as $hw)
		{
			$t2 = time();
			$t1 = $t2-HARDWARE_INACTIVE_TIME;
			$tests = FrameUtils::get_tests_received_time_range($hw['hw_id'], $t1, $t2);
			if($tests > 0)
			{
				$one_active = true;
			}
			else
			{
				$delete_list .= "'".$hw['hw_id']."',";
			}
		}

		if(!$one_active)
		{
			$delete_list = '';
		}

		return $delete_list;
	}
	
	public function clean_hardware()
	{
		require_once( FRAMES_PATH . 'frame_utils.php' );

		define('HARDWARE_INACTIVE_TIME',3600); //3600 seconds = 1 hour
		
		$db = db_get();
		
		$delete_list_global = '';

		/*DELETES by duplicate serial, if one active*/
		$res = $db->get_results("SELECT hw_serial FROM hardware GROUP BY hw_serial HAVING count(hw_serial) > 1", ARRAY_A);
		if(null != $res)
		{
			foreach($res as $r)
			{
				$db->set_qd( array($r['hw_serial']) );
				$hw_list = $db->get_results("SELECT hw_id FROM hardware WHERE hw_serial = ?", ARRAY_A);
				$delete_list_global .= $this->build_delete_list($hw_list);
			}
		}

		/*DELETES by duplicate (company,receiver,code), if one active*/
		$res = $db->get_results("SELECT hw_df_company, hw_df_receiver, hw_code FROM hardware GROUP BY hw_df_company, hw_df_receiver, hw_code  HAVING COUNT(hw_df_company)>1 AND COUNT(hw_df_receiver)>1 AND COUNT(hw_code)>1", ARRAY_A);
		if(null != $res)
		{
				foreach($res as $r)
				{
					$db->set_qd( array($r['hw_df_company'],$r['hw_df_receiver'],$r['hw_code']));
					$hw_list = $db->get_results("SELECT hw_id FROM hardware WHERE  hw_df_company = ? AND hw_df_receiver = ? AND hw_code  = ?", ARRAY_A);
					$delete_list_global .= $this->build_delete_list($hw_list);
				}
		}

		//deletion query
		$len = strlen($delete_list_global);
		if($len>0)
		{
			$del = substr( $delete_list_global, 0, $len-1 );
			$db->query("DELETE FROM hardware WHERE hw_id IN (".$del.")");
		}

		print "DELETED: ".$delete_list_global;
	}
	
	public function clean_old_history_log()
	{
		$sec_code	= get_var( 'code' );

		if ( $sec_code == '5994471abb01112afcc18159f6cc74b4f511b99806da59b3caf5a9c173cacfc5' )
		{
			$db			= db_get();
			define('TESTS_LOG_OLD_HISTORY_SECONDS',3600*24*64); //3600 seconds = 1 hour * 24 = 1 day * X num days

			$db->trans_start();

			$tstamp = 'to_timestamp('.time().')::TIMESTAMP';

			$db->set_qd(array(TESTS_LOG_OLD_HISTORY_SECONDS));
			$db->query('DELETE FROM tests_log_history WHERE ' . SQL::secs_from('tl_from_time', $tstamp) . ' > ?');

			$db->trans_complete();
		}
	}
	
	public function clean_test_frames()
	{
		define('TESTS_FRAMES_TIMEOUT_SECONDS',3600*48); //3600 seconds = 1 hour

		$db = db_get();
		$db->trans_start();
		
		$db->set_qd(array(TESTS_FRAMES_TIMEOUT_SECONDS));
		$db->query('DELETE FROM test_frames WHERE ' . SQL::secs_from( 'tf_hw_timestamp' ) . ' > ?');

		$db->set_qd(array(TESTS_FRAMES_TIMEOUT_SECONDS));
		$db->query('DELETE FROM signal_frames WHERE ' . SQL::secs_from( 'sf_hw_timestamp' ) . ' > ?');
		
		$db->trans_complete();
	}
	
	public function clean_tests_log_hw_tmp()
	{
		$older_than = 3600*72; //3600 seconds = 1 hour * 72 = 3 days

		$this->db->query( 'DELETE FROM tests_log_hw_tmp WHERE ' . SQL::secs_from( 'tlht_timestamp' ) . ' > ?', array( $older_than ) );
	}
	
	public function clean_package()
	{
		define('PACKAGE_CONTROL_TIMEOUT_SECONDS',3600); //3600 seconds = 1 hour
		define('RECEIVER_TICKS_TIMEOUT_SECONDS',600); //10 mins

		$db = db_get();
		$db->trans_start();
		
		$db->set_qd(array(PACKAGE_CONTROL_TIMEOUT_SECONDS));
		$db->query('DELETE FROM package_control WHERE ' . SQL::secs_from_ts( 'timestamp' ) . ' > ?');


		$db->set_qd(array(RECEIVER_TICKS_TIMEOUT_SECONDS));
		$db->query('DELETE FROM receiver_ticks WHERE ' . SQL::secs_from_ts( 'rt_time' ) . ' > ?');
		
		$db->trans_complete();
	}

	public function clean_data_frames()
	{
		$db = db_get();
		$db->trans_start();

		$tstamp = 'to_timestamp('.time().')::TIMESTAMP';
		
		$secs = 3600*24*30*2; // 2 months 
		
		//$db->set_qd(array($secs));
		//$db->query('INSERT INTO data_frames_history (df_id, df_packet_type , df_company_code , df_receiver_code , df_hw_code , df_msg_type , df_frame_data , df_hw_serial , df_hw_timestamp , df_msg_id , df_reserved , df_checksum_total ) ( SELECT df_id, df_packet_type , df_company_code , df_receiver_code , df_hw_code , df_msg_type , df_frame_data , df_hw_serial , df_hw_timestamp , df_msg_id , df_reserved , df_checksum_total FROM data_frames WHERE ' . SQL::secs_from('df_hw_timestamp', $tstamp) . ' > ? )');

		$db->set_qd(array($secs));
		
		$db->query('DELETE FROM data_frames WHERE ' . SQL::secs_from('df_hw_timestamp', $tstamp) . ' > ?');

		$db->trans_complete();

		//$secs = 3600*24*30*8; // 8 months 
		
		//$db->set_qd(array($secs));
		
		//$db->query('DELETE FROM data_frames_history WHERE ' . SQL::secs_from('df_hw_timestamp', $tstamp) . ' > ?');
	}
	
	public function clean_tests_log()
	{
		$db = db_get();
		$db->trans_start();

		$tstamp = 'to_timestamp('.time().')::TIMESTAMP';

		$db->set_qd(array(TESTS_LOG_TIMEOUT_SECONDS));
		$db->query('INSERT INTO tests_log_history (tl_hw_id,tl_tests_count,tl_from_time) ( SELECT tl_hw_id,tl_tests_count,tl_from_time FROM tests_log WHERE ' . SQL::secs_from('tl_from_time', $tstamp) . ' > ? )');

		$db->set_qd(array(TESTS_LOG_TIMEOUT_SECONDS));
		$db->query('DELETE FROM tests_log WHERE ' . SQL::secs_from('tl_from_time', $tstamp) . ' > ?');
		
		$db->trans_complete();
		
		$tests_timeout_secs = 3600 * 24 * 30;
		
		$db->query('DELETE FROM test WHERE ' . SQL::secs_from('test_timestamp', $tstamp) . ' > ?', array( $tests_timeout_secs ) );
		
		$db->query('DELETE FROM tests_log_company_group WHERE ' . SQL::secs_from('tlcg_from_time', $tstamp) . ' > ?', array($tests_timeout_secs));

		$db->query('DELETE FROM tests_log_company WHERE ' . SQL::secs_from('tlc_from_time', $tstamp) . ' > ?', array($tests_timeout_secs));
		
		echo "OK";
	}
	
	public function clean_receiver_ticks_period()
	{
		$this->db->query('DELETE FROM receiver_ticks_period WHERE ' . SQL::secs_from('rtp_from_time') . ' > ?', array(RECEIVER_TICKS_PERIOD_TIMEOUT_SECONDS) );
	}
	
	public function delete_old_backups()
	{
		define( 'TOTAL_DAYS', 3 );

		$DIR = ROOTPATH . "backups/";

		if ( $handle = opendir( $DIR ) )
		{
			while ( false !== ( $file = readdir( $handle ) ) )
			{
				if ( $file != '.' && $file != '..' && filemtime( $DIR . $file ) <= time() - ( ( 60 * 60 * 24 ) * TOTAL_DAYS ) )
				{
				   unlink( $DIR . $file );
				}
			}

			closedir( $handle );
		}
	}
	
	public function files_ver_update()
	{
		$db			= db_get();
		$file_ver	= $db->get_results( 'SELECT * FROM file_version', ARRAY_A );

		if ( isset( $file_ver ) )
		{
			foreach( $file_ver as $row )
			{
				$script_name	= $row['fv_name'];
				$script_fpath	= ROOTPATH.$script_name;
				$script_date	= @filectime( $script_fpath );
				
				if ( $script_date != $row['fv_date'] )
				{
					$script_hash	= hash( 'md5', $script_date );
					
					$db->set_qd( array( $script_date, $script_hash, $row['fv_id'] ) );
					$db->query( 'UPDATE file_version SET fv_date = ?, fv_hash = ? WHERE fv_id = ?' );
				}
			}
		}
	}
	
	public function create_receipts()
	{
		$this->load->model( 'User_model' );
		$this->load->model( 'Receipt_model' );
		
		echo '<html><head><style type="text/css">body {font-family: "Lucida Console", Monaco, monospace;}</style></head><body>';
		
		$db		= db_get();
		$res	= $this->User_model->get_users_with_payments_service();

		if ( isset( $res ) )
		{
			foreach ( $res as $user )
			{
				if ( 0 >= $user->ui_payfreq )
				{
					continue;
				}

				$today_t		= strtotime( date('Y-m-d' ) );
				$ser_start_t	= strtotime( $user->ui_paystart );

				echo 'Today: ' . pp_date( $today_t ) 		. ' ' . $today_t		. '<br/>';
				echo 'Start: ' . pp_date( $ser_start_t )	. ' ' . $ser_start_t	. '<br/>';

				$tdate 		= $user->ui_paystart;
				$tdate_t	= strtotime( $tdate );

				// Creates the receipts if doesn't exists
				while( $tdate_t <= $today_t )
				{
					$tdate 		= add_date( $tdate, 0, $user->ui_payfreq );
					$tdate_t	= strtotime( $tdate );

					if ( $tdate_t <= $today_t )
					{
						echo 'Nextd: ' . $tdate . ' ' . $tdate_t . '<br/>';

						if ( !$this->Receipt_model->exists( $tdate ) )
						{
							$this->Receipt_model->add( $user->ui_uid, $tdate, $user->ui_price );

							echo 'Created receipt for ' . $tdate . '<br/>';
						}
					}
				}

				echo '<br/>';
			}
		}
		
		echo '</body></html>';
	}
	
	protected function generate_debt_mail( $user, $receipt, $company )
	{
		$startdate	= unformat_date( $receipt->re_date );
		$enddate	= unformat_date( add_date( $receipt->re_date, 30 ) );
		$freq		= $user->ui_payfreq == 1 ? 'un mes' : $user->ui_payfreq . ' meses';
		$debt		= abs( $user->ui_balance );
		$msg		= "Estimado " . $user->ui_lastname . " " . $user->ui_name . ",

		Este es un recordatorio de que su comprobante de servicio fue generado el $startdate se vencerá el $enddate

		Método de pago: Cuota cada $freq por un importe total de $" . $user->ui_price . "


		Monto adeudado: $" . $debt . "
		Fecha de vencimiento: $enddate

		Lo saluda cordialmente,

		" . $company->com_name;

		return $msg;
	}

	protected function check_balance( $user )
	{
		// If the account doesn't have any debt, we don't send anything...
		if (  $user->ui_balance >= 0 )
		{
			return;
		}

		$receipt	= $this->Receipt_model->get_last( $user->ui_uid );

		if ( isset( $receipt ) )
		{
			$today_t		= strtotime( date('Y-m-d' ) );
			$payday_t		= strtotime( $receipt->re_date );
			$diff_days		= days_diff( $payday_t, $today_t );
			$company		= $diff_days <= 30 ? $this->Company_model->get( $user->ui_company ) : null;

			echo 'Debt: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$'	. abs( $user->ui_balance )	. '<br/>';
			echo 'Today: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'		. pp_date( $today_t ) 		. ' ' . $today_t		. '<br/>';
			echo 'Payday: &nbsp;&nbsp;&nbsp;&nbsp;'				. pp_date( $payday_t ) 		. ' ' . $payday_t		. '<br/>';
			echo 'Difference: ' 								. $diff_days . ' days'		. '<br/>';

			if ( $diff_days == 15 )
			{
				// Debt alert
				$subject 	= 'Asunto: Recordatorio de pago';

				simple_mail( 'mailer@reddomo.com.ar', $user->umail, $subject, generate_debt_mail( $user, $receipt, $company ), $company->com_support );

				echo "Aviso de Deuda Para: " . $user->ui_lastname . ' ' . $user->ui_name . '.<br/>';
			}
			else if ( $diff_days >= 25 && $diff_days < 30 )
			{
				// Debt alert + Countdown service suspend
				$days_left	= 30 - $diff_days;
				$days		= $days_left == 1 ? 'un día.' : $days_left . ' días.';
				$subject 	= 'Asunto: Recordatorio de pago. Vencimiento en ' . $days;

				simple_mail( 'mailer@reddomo.com.ar', $user->umail, $subject, generate_debt_mail( $user, $receipt, $company ), $this->User_model->get_mail( $company->com_uid ) );

				echo "Aviso de Deuda Para (cuenta regresiva de corte de servicio $days_left d&iacute;as): " . $user->ui_lastname . ' ' . $user->ui_name . '.<br/>';
			}
			else if ( $diff_days > 30 )
			{
				// Suspend user
				$this->User_model->suspend( $user->ui_uid, true );

				echo 'Usuario: ' . $user->ui_lastname . ' ' . $user->ui_name . ' suspendido.<br/>';
			}

			echo '<br/>';
		}
	}
	
	public function pending_payments()
	{
		$this->load->model( 'User_model' );
		$this->load->model( 'Receipt_model' );
		$this->load->model( 'Company_model' );
		
		echo '<html><head><style type="text/css">body {font-family: "Lucida Console", Monaco, monospace;}</style></head><body>';

		$res	= $this->User_model->get_users_with_payments_service();

		if ( isset( $res ) )
		{
			foreach ( $res as $row )
			{
				$this->check_balance( $row );
			}
		}
		
		echo '</body></html>';
	}
	
	public function create_groups()
	{
		$this->load->model('Company_model');
		$this->load->model('Hardware_model');
		$this->load->model('HardwareGroup_model');
		
		$companies = $this->Company_model->get_all_basic_data();
		
		foreach ( $companies as $com )
		{
			$icons			= $this->Company_model->get_icons( $com->com_id );
			$com_groups		= $this->HardwareGroup_model->get_all( $com->com_id );
			$groups			= array();
			
			if ( NULL != $com_groups && !empty( $com_groups ) )
			{
				foreach ( $com_groups as $cg )
				{
					$groups[]	= $cg['hwg_name'];
				}
			}
			
			if ( NULL != $icons && !empty( $icons ) )
			{
				foreach ( $icons as $icon )
				{
					$name	= get_icon_name( $icon['hw_icon'] );
					
					if ( !in_array( $name, $groups ) )
					{
						$group = $this->HardwareGroup_model->add( $name, $com->com_id );
						
						$hws	= $this->Hardware_model->get_with_icon( $com->com_id, $icon['hw_icon'] );
						
						foreach ( $hws as $hw )
						{
							$this->HardwareGroup_model->link( $group, $hw['hw_id'] );
						}
					}
				}
			}
		}
	}
	
	public function check_new_signal_tests()
	{
		// SELECT THE lastests 191 messages FROM every hardware that not received any more 191 since the last 60 seconds in the last 380 seconds
		$sql = "SELECT 
					sf_company_code, 
					sf_receiver_code, 
					sf_hw_code, 
					sf_hw_serial, 
					MAX(sf_hw_timestamp) AS last_received, " .
					SQL::secs_from( 'MAX(sf_hw_timestamp)' ) . " AS last_time
				FROM signal_frames 
				WHERE sf_frame_data LIKE '______191_' AND " .
					SQL::secs_from( 'sf_hw_timestamp' ) . " <= " . ( 320 + 60 ) . " 
				GROUP BY sf_company_code, sf_receiver_code, sf_hw_code, sf_hw_serial
				HAVING " . SQL::secs_from( 'MAX(sf_hw_timestamp)' ) . " >= 60";
		
		$res = $this->db->get_results( $sql, ARRAY_A );
		
		if ( isset( $res ) )
		{
			echo "NEW HARDWARE INSTALL\n<br/>";
			
			echo json_enc( $res, TRUE );
			
			echo "<br/><br/>";
			
			foreach( $res as $row )
			{
				// From the "finished" signal tests, get the signal count, first message time, last message time, etc
				// To do that, we count all the messages received since the last message minus 340 seconds 
				// ( 320 secs is the max time for a signal test plus some seconds to avoid losing any packet )
				$sql = "SELECT 
							sf_company_code, 
							sf_receiver_code, 
							sf_hw_code, 
							sf_hw_serial, 
							MIN(sf_hw_timestamp) AS first_received, 
							MAX(sf_hw_timestamp) AS last_received, 
							( MAX(sf_hw_timestamp) - MIN(sf_hw_timestamp) ) AS diff_received, " .
							SQL::secs_from( 'MAX(sf_hw_timestamp)' ) . " AS last_time,
							COUNT(sf_id) AS signal,
							COUNT(sf_hw_timestamp) AS signal_filtered
						FROM signal_frames 
						WHERE sf_frame_data LIKE '______191_' AND " .
							SQL::secs_from( 'sf_hw_timestamp', SQL::from_unix_time( $row['last_received'] ) ) . " <= 390 AND
							sf_company_code = ? AND sf_receiver_code = ? AND sf_hw_code = ? AND sf_hw_serial = ?
						GROUP BY sf_company_code, sf_receiver_code, sf_hw_code, sf_hw_serial
						LIMIT 1";
				
				$ri = $this->db->get_row( $sql, ARRAY_A, array( $row['sf_company_code'], $row['sf_receiver_code'], $row['sf_hw_code'], $row['sf_hw_serial'] ) );
				
				echo "HARDWARE INSTALLATION STATS\n<br/>";
				
				echo json_enc( $ri, TRUE );
				
				echo "<br/><br/>";
				
				if ( isset( $ri ) )
				{
					$this->load->model('HardwareSetupSignalHistory_model');
					
					// From the new installations we should check if this instalation it's not already in the db, so first we check that
					if ( !$this->HardwareSetupSignalHistory_model->exists(	$ri['sf_company_code'], $ri['sf_receiver_code'], $ri['sf_hw_code'], 
																			$ri['sf_hw_serial'], $ri['first_received'], $ri['last_received'] ) )
					{
						$now = pp_date_now();
						
						// It doesn't exists? So we insert it to the db!
						$id = $this->HardwareSetupSignalHistory_model->add(
							$ri['sf_company_code'], $ri['sf_receiver_code'], $ri['sf_hw_code'], $ri['sf_hw_serial'], $now,
							$ri['first_received'], $ri['last_received'], $ri['signal'], $ri['signal_filtered'] 
						);
						
						echo "INSERTED $id<br/>";
						echo json_enc( $ri, TRUE );
						echo "<br/><br/>";
						
						// Search if the hw exists and update the old signal data
						$hw_id = $this->db->get_var(	'SELECT hw_id FROM hardware WHERE hw_df_company = ? AND hw_df_receiver = ? AND hw_code = ?', 
														array( $ri['sf_company_code'], $ri['sf_receiver_code'], $ri['sf_hw_code'] ) );
						
						if ( isset( $hw_id ) )
						{
							$this->db->query( 'UPDATE hardware SET hw_inst_time = ?, hw_setup_signal = ?, hw_setup_signal_filtered = ? WHERE hw_id = ?', 
												array( $now, $ri['signal'], $ri['signal_filtered'], $hw_id ) );
						}
					}
				}
			}
		}
	}
	
	protected function hardware_update_last_setup_signal( $com_df_id, $com_rec_id, $hw )
	{
		$this->load->model('HardwareSetupSignalHistory_model');
		
		$hwssh		= $this->HardwareSetupSignalHistory_model->get_last( $com_df_id, $com_rec_id, $hw['hw_code'] );
		
		if ( NULL != $hwssh )
		{
			$hw_time	= strtotime( $hw['hw_inst_time'] );
			$hwssh_time	= strtotime( $hwssh['hwsh_inst_time'] );
			
			if ( ( NULL == $hw['hw_inst_time'] || 0 == intval( $hw['hw_setup_signal'] ) || 0 == intval( $hw['hw_setup_signal_filtered'] ) || $hwssh_time > $hw_time ) && 
					isset( $hwssh['hwsh_inst_time'] ) 
			)
			{
				echo "UPDATING OLD SIGNAL TEST IN HARDWARE ROW.<br/>\n";
				echo json_enc( $hw, TRUE );
				echo "<br/><br/>\n";
				echo json_enc( $hwssh, TRUE );
				echo "<br/><br/>\n";
				
				$this->db->query( 'UPDATE hardware SET hw_inst_time = ?, hw_setup_signal = ?, hw_setup_signal_filtered = ? WHERE hw_id = ?', 
									array( $hwssh['hwsh_inst_time'], $hwssh['hwsh_signal'], $hwssh['hwsh_signal_filtered'], $hw['hw_id'] ) );
			}
		}
	}
	
	public function check_old_signal_tests()
	{
		$this->load->model('HardwareSetupSignalHistory_model');
		
		$res = $this->db->get_results( 'SELECT hardware.* FROM hardware 
										INNER JOIN hardware_setup_signal_history ON 
											hw_code = hwsh_hw_code AND hw_df_company = hwsh_company_code AND hw_df_receiver = hwsh_receiver_code
										GROUP BY hardware.hw_id',
										ARRAY_A
		);
		
		if ( isset( $res ) )
		{
			foreach ( $res as &$hw )
			{
				$this->hardware_update_last_setup_signal( $hw['hw_df_company'], $hw['hw_df_receiver'], $hw );
			}
		}
	}
	
	public function recover_signal_test_lost()
	{
		$this->load->model('Company_model');
		$this->load->model('Hardware_model');
		$this->load->model('HardwareSetupSignalHistory_model');
		
		$codes = array( 0x8888, 0x1234 );
		$companies = $this->Company_model->get_all_basic_data();
		
		foreach ( $companies as $com )
		{
			foreach ( $codes as $code )
			{
				$hwsshs = $this->HardwareSetupSignalHistory_model->get_from_code( $com->com_df_id, $com->com_rec_id, $code );
				
				$first = true;
				
				if ( NULL != $hwsshs )
				{
					foreacH ( $hwsshs as $hwssh )
					{
						$hw = $this->Hardware_model->get_from_serial( $hwssh['hwsh_hw_serial'], ARRAY_A );
						
						if ( isset( $hw ) && isset( $hwssh['hwsh_inst_time'] ) && $hw['hw_code'] != 0x8888 && $hw['hw_code'] != 0x1234 && $hwssh['hwsh_hw_code'] != $hw['hw_code'] )
						{
							// if the hw code is different and the setup signal register is not already added
							if ( !$this->HardwareSetupSignalHistory_model->exists(	$com->com_df_id, $com->com_rec_id, $hw['hw_code'], 
																					$hw['hw_serial'], $hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'] ) )
							{
								echo "ADDING SETUP SIGNAL HISTORY TO<br/>\n";
								echo json_enc( $hw, TRUE );
								echo "<br/><br/>\n";
								echo json_enc( $hwssh, TRUE );
								echo "<br/><br/>\n";
								
								// We add the setup signal history with the new code
								$id = $this->HardwareSetupSignalHistory_model->add(
									$com->com_df_id, $com->com_rec_id, $hw['hw_code'], $hw['hw_serial'], $hwssh['hwsh_inst_time'],
									$hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'], $hwssh['hwsh_signal'], $hwssh['hwsh_signal_filtered'] 
								);
								
								// Since the query is from newest to oldest, i add the first result
								if ( $first )
								{
									$this->hardware_update_last_setup_signal( $com->com_df_id, $com->com_rec_id, $hw );
									
									$first = false;
								}
							}
							else
							{
								// I probably frakked up this with before
								// Since the query is from newest to oldest, i add the first result
								if ( $first )
								{
									$this->hardware_update_last_setup_signal( $com->com_df_id, $com->com_rec_id, $hw );
									
									$first = false;
								}
							}
						}
					}
				}
			}
		}
		
		$first = true;
		
		$hwinst = $this->Hardware_model->get_lost_instalations();
		
		if ( isset( $hwinst ) )
		{
			foreach( $hwinst as $hw )
			{
				$hwsshs = $this->HardwareSetupSignalHistory_model->get_from_serial( $hw['hw_serial'] );
				
				if ( NULL != $hwsshs )
				{
					foreach ( $hwsshs as &$hwssh )
					{
						// Check if the hw code is different from the history
						if ( $hwssh['hwsh_hw_code'] != $hw['hw_code'] )
						{
							// if the hw code is different and the setup signal register is not already added
							if ( !$this->HardwareSetupSignalHistory_model->exists(	$hw['hw_df_company'], $hw['hw_df_receiver'], $hw['hw_code'], 
																					$hw['hw_serial'], $hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'] ) )
							{
								// We add the setup signal history with the new code
								$id = $this->HardwareSetupSignalHistory_model->add(
									$hw['hw_df_company'], $hw['hw_df_receiver'], $hw['hw_code'], $hw['hw_serial'], $hwssh['hwsh_inst_time'],
									$hwssh['hwsh_first_timestamp'], $hwssh['hwsh_last_timestamp'], $hwssh['hwsh_signal'], $hwssh['hwsh_signal_filtered'] 
								);
								
								// Since the query is from newest to oldest, i add the first result
								if ( $first )
								{
									$this->hardware_update_last_setup_signal( $hw['hw_df_company'], $hw['hw_df_receiver'], $hw );
									
									$first = false;
								}
							}
						}
					}
				}
			}
		}
	}
	
	public function blank_filler()
	{
		$this->load->model('Company_model');
		
		$companies = $this->Company_model->get_all_basic_data();
		
		foreach ( $companies as $com )
		{
			$cur_time = floor( time() / RECEIVER_TICKS_PERIOD_TIME ) * RECEIVER_TICKS_PERIOD_TIME;
			
			$rtp_id = $this->db->get_var( 'SELECT rtp_id FROM receiver_ticks_period WHERE rtp_com_id = ? AND rtp_from_time = ? LIMIT 1', array( $com->com_id, $cur_time ) );
			
			if ( !isset( $rtp_id ) )
			{
				$this->db->query( 'INSERT INTO receiver_ticks_period ( rtp_com_id, rtp_from_time, rtp_ticks_count ) VALUES ( ?, ?, 0 )', array( $com->com_id, $cur_time ) );
			}
		}
	}
	
	public function delete_old_guests()
	{
	}
	
	public function update_inside_status()
	{
		$this->load->model('RfidUser_model');
		
		$this->RfidUser_model->update_inside_status();
	}
	
	public function clean_request_tracker()
	{
		echo "Cleaned request tracker.";
		load_model('RequestTracker_model')->clean();
	}
	
	public function upload_radar_events()
	{
		$this->load->model('RadarEvent_model');
		$this->load->library('openkey');
		
		$filter = array(
			array(
				'field_name'	=>	're_upload_state',
				'filter_val'	=>	RadarEventUploadStatus::NOT_UPLOADED,
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	're_valid',
				'filter_val'	=>	RadarEventStatus::VALID,
				'field_type'	=>	SQLFieldType::INT
			)
		);
		
		$res = $this->RadarEvent_model->get_all( NULL, SQL::build_query_filter( $filter ) );
		
		if ( isset( $res ) )
		{
			foreach ( $res as $re )
			{
				echo "Trying to upload {$re['re_image']}<br/>";
				
				if ( $this->openkey->send_openkey_image( $re['re_id'] ) )
					echo "Uploaded {$re['re_image']}<br/>";
				else
					echo "Failed to upload {$re['re_image']}<br/>";
			}
		}
		else
		{
			echo "Nothing to send.";
		}
	}
	
	public function clean_old_tickets()
	{
		$this->load->model('RadarEvent_model');
		
		$filter = array(
			array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	SERVER_NAME != 'arenasdelsur' ? time() - 24*3600*60 : time() - 24*3600*90,
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ
			),
			array(
				'field_name'	=>	're_image',
				'filter_val'	=>	'',
				'filter_type'	=>	SQLFilterType::UNEQUALS,
				'compare_string'=>	TRUE,
				'accept_null'	=>	TRUE
			)
		);
		
		$res = $this->RadarEvent_model->get_all( NULL, SQL::build_query_filter( $filter ) );
		
		if ( isset( $res ) )
		{
			foreach ( $res as $re )
			{
				echo "Deleted image for radar_event " . $re['re_id'] . "<br/>";
				
				@unlink( FINESPATH . $re['re_image'] );
				
				$this->RadarEvent_model->update_image( $re['re_id'], '' );
			}
		}
	}
	
	public function free_space()
	{
		$fs = disk_free_space( '.' );
		$fsgb = $fs / 1024 / 1024 / 1024;
		
		if ( $fsgb <= 10 )
		{
			echo "Poco espacio detectado, enviada alerta";
			simple_mail( 'no-responder@reddomo.com.ar', 'emanzini@deitres.com.ar,mgolini@deitres.com,smarinella@deitres.com.ar', 'ALERTA: Poco espacio en disco', "Hacer espacio en disco lo antes posible, quedan: {$fsgb} GB libres" );
		}
		else
		{
			echo "Espacio suficiente libre: {$fsgb} GB";
		}
	}
	
	public function clean_radar_log()
	{
		$this->db->query('DELETE FROM radar_log WHERE ' . SQL::secs_from_ts( 'rl_timestamp' ) . ' > ?', array( 3600*24*10 ) );
	}
}
