<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Company extends PAGE_Controller
{
	public function techsupport()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$subject = $this->user->get_fullname() . ': Solicitud de soporte técnico.';
		
		$this->load->view( 'mail_popup', array( 'callback_url' => base_url( '/company/mailtechsupport' ), 'default_subject' => $subject, 'default_reply_to' => $this->user->get_mail() ) );
	}
	
	public function hwbuy()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$subject = $this->user->get_fullname() . ': Solicitud de compra.';
		
		$this->load->view( 'mail_popup', array( 'callback_url' => base_url( '/company/mailhwbuy' ), 'default_subject' => $subject, 'default_reply_to' => $this->user->get_mail() ) );
	}
	
	public function mailtechsupport()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->send_mail( $this->input->post(), 'tecnica@deitres.com.ar' );
	}
	
	public function mailhwbuy()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->send_mail( $this->input->post(), 'oroselli@deitres.com.ar' );
	}
	
	protected function send_mail( $data, $to )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'subject', 
				'label'   => 'Asunto', 
				'rules'   => 'required|trim|max_length[200]'
			),
			array(
				'field'   => 'from', 
				'label'   => 'Responde a', 
				'rules'   => 'required|trim|max_length[128]|valid_email'
			),
			array(
				'field'   => 'message', 
				'label'   => 'Mensaje', 
				'rules'   => 'required|trim|min_length[10]',
				'type'    => 'textarea'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			simple_mail( 'mailer@reddomo.com.ar', $to, $data['subject'], $data['message'], $data['from'] );
			
			$this->kajax->html('.mail_response_div', '<p>Gracias por contactarse con Deitres.</p><p>Nos pondremos en contacto con usted a la brevedad.</p>');
			$this->kajax->hide('.mail_popup_div');
			$this->kajax->show('.mail_response_div');
			$this->kajax->call('modal_dialog_close_timeout(5000)');
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules, '.mail_popup_div' );
		
		$this->kajax->out();
	}
}
