<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once( LIBSPATH . 'maps/geocode.php' );

class Companies extends PAGE_Controller
{
	protected function build_user_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'uname',
				'filter_val'	=>	get_var( 'uname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'umail',
				'filter_val'	=>	get_var( 'umail' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'uname' ),
				'order_fields'	=> array( 'uname', 'umail' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $this->user->is_logged_as_user() )
		{
			$filter[] = array(
				'field_name'	=>	'uid',
				'filter_val'	=>	$this->user_id()
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function users()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Company_model');
		$this->load->model('CompanyUser_model');
		$this->load->model('Location_model');
		
		$this->load->library('pagination');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 100000; // don't paginate
		$query_filter			= $this->build_user_filters();
		$data['uname']			= get_var( 'uname' );
		$data['umail']			= get_var( 'umail' );
		
		if ( $this->user->is_guard() )
		{
			$config['total_rows']	= $data['total_users']	= 1;
			
			$data['users']			= array( $this->CompanyUser_model->get( $this->user->get_user_id(), ARRAY_A ) );
		}
		else
		{
			$config['total_rows']	= $data['total_users']	= $this->CompanyUser_model->count( $this->user->get_company_ids_with_meta(), $query_filter );
			$data['users']			= $this->CompanyUser_model->get_all( $this->user->get_company_ids_with_meta(), $query_filter, $config['per_page'], $page );
		}
		
		$config['base_url']		= base_url( '/companies/users/?' . http_build_query_pagination() );
		$config['anchor_class']	= 'class="ajax-link" ';
		$data['base_url']		= $config['base_url'];
		$data['cities']			= $this->Location_model->get_cities_array();
		
		if ( NULL == $data['users'] )
		{
			$data['users'] = array();
		}
		
		if ( $this->user->is_logged_as_god() || $this->user->is_logged_as_company_meta() )
		{
			if ( $this->user->is_logged_as_company_meta() )
			{
				$data['all_com']	= $this->Company_model->get_all_with_user( $this->user->get_company_ids_with_meta() );
			}
			else
			{
				$data['all_com']	= $this->Company_model->get_all_names();
			}
			
			$companies = $this->Company_model->get_all_with_user( $this->user->get_company_ids_with_meta(), ARRAY_A, 'DESC' );
			
			if ( isset( $companies ) && !empty( $companies ) )
			{
				foreach ( $companies as $com )
				{
					array_unshift( $data['users'], $com );
				}
			}
		}
		
		if ( !$this->user->is_logged_as_god() && !$this->user->is_guard() )
		{
			$me = $this->Company_model->get_with_user( $this->user->get_company(), ARRAY_A );
			
			if ( isset( $me ) )
			{
				array_unshift( $data['users'], $me );
			}
		}
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'company_users_list', $data );
	}
	
	public function get_new_user_row()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Company_model');
		
		$data = array();
		
		if ( $this->user->is_guard() )
		{
			$this->kajax->fancy_log_error( "Permisos insuficientes" );
			$this->kajax->out();
			return;
		}
		
		if ( $this->user->is_logged_as_god() )
		{
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		else if ( $this->user->is_logged_as_company_meta() )
		{
			$data['all_com']	= $this->Company_model->get_all_with_user( $this->user->get_company_ids_with_meta() );
		}
		
		$this->kajax->prepend( '#company_users_list_table', $this->load->view( 'new_row_company_user', $data, TRUE ) );
		$this->kajax->out();
	}
	
	public function get_new_company_row()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Location_model');
		
		$data['cities'] = $this->Location_model->get_cities_array();
		
		$this->kajax->prepend( '#company_users_list_table', $this->load->view( 'new_row_company', $data, TRUE ) );
		$this->kajax->out();
	}
	
	protected function user_id_replace( $id )
	{
		$this->kajax_replace_new_ids( 
			$id,
			array(	'row_', 
					'row_hidden_',
					'row_extra_',
					'row_extra_2',
					'row_extra_3',
					'row_extra_4',
					'row_extra_5',
					'row_extra_6'
			)
		);
	}	
	
	public function user_update()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$edit = intval( $post['uid'] ) != 0;
		
		if ( $edit && ( $this->user->is_guard() || $this->user->is_professional() ) && $post['uid'] != $this->user->get_user_id() )
		{
			$this->kajax->fancy_log_error( "Permisos insuficientes" );
			$this->kajax->out();
			return;
		}
		
		$this->load->model('Company_model');
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'uname', 
				'label'   => 'Usuario', 
				'rules'   => 'required|trim|max_length[40]'
			),
			array(
				'field'   => 'umail', 
				'label'   => 'EMail', 
				'rules'   => 'required|trim|max_length[128]|valid_email'
			),
			array(
				'field'   => 'upass', 
				'label'   => 'Contraseña', 
				'rules'   => ( $edit ? '' : 'required|' ) . 'matches[upass_rep]'
			),
			array(
				'field'   => 'upass_rep', 
				'label'   => 'Repetir Contraseña', 
				'rules'   => ''
			)
		);
		
		if ( isset( $post['real_com_user'] ) )
		{
			$com_rules = array(
				array(
					'field'   => 'df_id', 
					'label'   => 'ID de Empresa', 
					'rules'   => 'required|trim|integer'
				),
				array(
					'field'   => 'rec_id', 
					'label'   => 'ID de Receptora', 
					'rules'   => 'required|trim|integer'
				),
				array(
					'field'   => 'name', 
					'label'   => 'Nombre de Empresa', 
					'rules'   => 'required|trim|max_length[32]'
				),
				array(
					'field'   => 'desc', 
					'label'   => 'Descripción', 
					'rules'   => 'required|trim|max_length[64]'
				),
				array(
					'field'   => 'phone', 
					'label'   => 'Celular', 
					'rules'   => 'required|trim|max_length[32]'
				),
				array(
					'field'   => 'city', 
					'label'   => 'Ciudad', 
					'rules'   => 'required|trim|integer'
				),
				array(
					'field'   => 'hw_report_freq', 
					'label'   => 'Reportes de abonados cada', 
					'rules'   => 'required|trim|integer'
				),
				array(
					'field'   => 'hw_state_low', 
					'label'   => 'Cant. rep. señal baja', 
					'rules'   => 'required|trim|integer'
				),
				array(
					'field'   => 'hw_state_good', 
					'label'   => 'Cant. rep. señal buena', 
					'rules'   => 'required|trim|integer'
				)
			);
			
			$rules = array_merge( $rules, $com_rules );
		}
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->load->model('CompanyUser_model');

			$post['config_hw'] = isset( $post['config_hw'] ) ? 1 : 0;
			
			$post['dshield_guard'] = isset( $post['dshield_guard'] ) ? 1 : 0;
			
			$post['access_control'] = isset( $post['access_control'] ) ? 1 : 0;
			
			$post['sms_user'] = isset( $post['sms_user'] ) ? $post['sms_user'] : '';
			$post['sms_password'] = isset( $post['sms_password'] ) ? $post['sms_password'] : '';
			
			if ( !isset( $post['real_com_user'] ) )
			{
				if ( isset( $post['write_on_domo'] ) )
				{
					$post['utype'] = UserDbType::DB_USER_TYPE_CPNY_RW;
				}
				else
				{
					$post['utype'] = UserDbType::DB_USER_TYPE_CPNY_RO;
				}
				
				if ( $edit )
				{
					if ( $this->user->owns_company_user( $post['uid'] ) )
					{
						if ( isset( $post['uname'] ) && $this->User_model->user_name_exists_off_uid( $post['uid'], $post['uname'] ) > 0 )
						{
							$this->kajax->fancy_log_error( 'El nombre de usuario ' . $post['uname'] . ' ya está registrado' );
						}
						else
						{
							if ( !$this->user->is_normal_dshield_admin() )
							{
								$post['type'] = $this->user->get_company_user_type();
							}
							
							if ( $this->user->is_logged_as_god() || $this->user->is_logged_as_company_meta() )
							{
								$sel_com = $this->Company_model->get( $post['com_id'] );
								
								if ( $sel_com->com_rec_id == 0 )
								{
									$post['utype'] = UserDbType::DB_USER_TYPE_CPNY_META;
								}
								
								$this->CompanyUser_model->update( $post, $post['com_id'] );
							}
							else
							{
								$this->CompanyUser_model->update( $post );
							}
							
							$this->kajax->fancy_log_success( 'Usuario: ' . $post['uname'] . ' editado con éxito.' );
						}
					}
					else
					{
						$this->kajax->fancy_log_error('No puedes modificar este usuario, no tienes suficientes permisos.');
					}
				}
				else
				{
					if ( !isset( $post['real_com_user'] ) )
					{
						if ( $this->user->is_logged_as_god() || $this->user->is_logged_as_company_meta() )
						{
							if ( $this->Company_model->is_meta( $post['com_id'] ) )
							{
								$post['utype'] = UserDbType::DB_USER_TYPE_CPNY_META;
							}
							
							$id = $this->CompanyUser_model->create( $post, $post['com_id']  );
						}
						else
						{
							$id = $this->CompanyUser_model->create( $post, $this->user->get_company() );
						}
						
						$this->kajax->fancy_log_success( 'Usuario: ' . $post['uname'] . ' añadido con éxito.' );
						$this->user_id_replace( $id );
						$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "uid", "' . base_url('/companies/user_delete/'.$id) . '", "¿Seguro que quiere eliminar el usuario ' . $post['uname'] . '?" )' );
					}
					
					$post['uid'] = $id;
				}
			}
			else
			{
				$this->load->model('Location_model');
				
				$loc = $this->Location_model->get( $post['city'] );
				$post['lat'] = 0;
				$post['long'] = 0;
				
				if ( isset( $loc ) )
				{
					$gdc_status = '';
					
					$coords = Geocode::GetLatLong($post['address'], $loc['loc_name'] . ', ' . $loc['loc_desc'], $gdc_status);
					
					if ( $coords )
					{
						$post['lat'] = $coords->lat;
						$post['long'] = $coords->lng;
					}
				}
				
				if ( $edit )
				{
					if ( isset( $post['uname'] ) && $this->User_model->user_name_exists_off_uid( $post['uid'], $post['uname'] ) > 0 )
					{
						$this->kajax->fancy_log_error( 'El nombre de usuario ' . $post['uname'] . ' ya está registrado' );
					}
					else
					{
						$this->CompanyUser_model->update( $post );
						
						$this->kajax->fancy_log_success( 'Empresa: ' . $post['uname'] . ' editada con éxito.' );
					}
				}
				else
				{
					$this->load->model('Company_model');
					
					if ( $this->Company_model->company_exists( $post['df_id'], $post['rec_id'] ) )
					{
						$this->kajax->fancy_log_error( 'El número de empresa y receptora ya existe en el sistema.' );
					}
					else
					{ 
						$id = $this->Company_model->create( $post );
					
						$this->kajax->fancy_log_success( 'Empresa: ' . $post['name'] . ' añadida con éxito.' );
						$this->user_id_replace( $id );
						$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "uid" )' );
					}
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$rows = array( '#row_extra_', '#row_extra_2_' );
		
		if ( isset( $post['real_com_user'] ) )
		{
			$rows = array( '#row_extra_', '#row_extra_2_', '#row_extra_3_', '#row_extra_4_', '#row_extra_5_', '#row_extra_6_' );
		}
		
		$this->kajax_validation_set_input_states( $rules, $post['uid'], $rows );
		
		$this->kajax->out();
	}
	
	public function user_delete( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$user = $this->User_model->get( $id );
		
		if ( NULL != $user )
		{
			$this->load->model('CompanyUser_model');
			$this->load->model('RfidUser_model');
			
			$this->CompanyUser_model->delete( intval($id) );
			
			$this->RfidUser_model->update_uid_from_uid( intval($id), null );
			
			$this->kajax->fancy_log_success( "Usuario " . $user->uname . " eliminado con éxito." );
			
			$this->kajax->remove( '#row_hidden_' . $id );
			$this->kajax->remove( '#row_extra_' . $id );
			$this->kajax->remove( '#row_extra_2_' . $id );
			$this->kajax->remove( '#row_' . $id );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No se encontró el usuario a eliminar' );
		}
		
		$this->kajax->out();
	}
	
	public function table()
	{
		$this->session_restrict( USER_TYPE_CPNY_META );
		
		$this->load->model('Company_model');
		
		$data['companies'] = $this->Company_model->get_table_info( $this->user->is_company_meta() ? $this->user->get_child_companies() : NULL );
		
		require_once( LIBSPATH . 'maps/maps.php' );
		
		$this->add_frame_view( 'companies_table', $data );
	}
	
	protected function build_companies_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'uname',
				'filter_val'	=>	get_var( 'uname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'umail',
				'filter_val'	=>	get_var( 'umail' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'cu_type',
				'filter_val'	=>	get_var( 'type' )
			),
			array(
				'field_name'	=>	'cu_com_id',
				'filter_val'	=>	$this->user->get_company_ids()
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'uname' ),
				'order_fields'	=> array( 'uname', 'umail' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function search()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('Company_model');
		
		$this->load->library('pagination');
		
		$data['js_cb']			= get_var( 'cb' );
		$data['row_id']			= get_var_def( 'row_id', 0 );
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 12;
		$query_filter			= $this->build_companies_filters();
		$data['uname']			= get_var('uname');
		$data['umail']			= get_var('umail');
		
		$config['total_rows']	= $data['total_users']	= $this->Company_model->count( $query_filter );
		$data['users']			= $this->Company_model->search( $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/companies/search/?' . http_build_query_pagination() );
		$config['anchor_class']	= 'class="ajax-paging-link ajax-clean" ';
		$data['base_url']		= $config['base_url'];
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->load->view( 'companies_search_list', $data );
	}
	
	public function delete( $com_id, $uid = NULL )
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			
			$this->Company_model->delete( $com_id );
			
			if ( NULL != $uid )
			{
				$this->kajax->remove( "#row_$uid, #row_hidden_$uid, #row_extra_$uid, #row_extra_2_$uid, #row_extra_3_$uid, #row_extra_4_$uid, #row_extra_5_$uid, #row_extra_6_$uid" );
			}
			
			$this->kajax->fancy_log_success( 'Empresa eliminada' );
			
			$this->kajax->out();
		}
	}
}
