<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Citymesh extends BASE_Controller
{	
	public function push()
	{
		http_header_json_no_cache();
		
		$this->load->library('citymeshgsm');
		$this->load->model('Hardware_model');		

		$data	= get_post( 'data' );
		$ip		= get_post('ip');
		$port	= intval( get_post('port') );
		
		$json = json_decode($data, TRUE);
			
		if ( $json && isset( $json["cmd"] ) )
		{
			switch ( $json['cmd'] )
			{
				case 'config':
				case 'config_set':
				{
					$this->Hardware_model->update_gsm_config( $json['imei'], json_encode( $json['config'] ) );
					
					break;
				}
				case 'config_response':
				{
					if ( isset( $json['result'] ) )
					{
						$result = strtoupper( $json['result'] );
						
						if ( $result == 'OK' )
						{
							$result = 'COMPLETED';
						}
						
						if ( $result != 'COMPLETED' && $result != 'ERROR' && $result != 'TIMEOUT' )
						{
							$result = 'ERROR';
						}
						
						$this->Hardware_model->update_cmd_state( $json['imei'], $result );
					}
					
					break;
				}
				case 'config_get':
				{
					$this->citymeshgsm->send_msg( $json['imei'], $this->citymeshgsm->gen_config( $json['imei'], $this->Hardware_model->get_gsm_config( $json['imei'], TRUE ) ) );
					
					break;
				}
			}
			
			if ( isset( $ip ) && is_string( $ip ) && filter_var( $ip, FILTER_VALIDATE_IP ) )
			{
				$this->Hardware_model->update_ip( $json['imei'], $ip );
			}
			
			if ( isset( $port ) && is_int( $port ) && $port )
			{
				$this->Hardware_model->update_port( $json['imei'], $port );
			}
			
			$data = $json;
		}
		
		$res = NULL != $data ? $data : 'NO DATA';
		
		echo json_encode( array( 'result' => $res ) );
	}
}
