<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cities extends PAGE_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('Location_model');
	}
	
	public function index()
	{
		$this->all();
	}
	
	protected function build_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'loc_name',
				'filter_val'	=>	get_var( 'loc_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'loc_desc',
				'filter_val'	=>	get_var( 'loc_desc' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'loc_name' ),
				'order_fields'	=> array( 'loc_name', 'loc_desc' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library('pagination');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_filters();
		$data['loc_name']		= get_var( 'loc_name' );
		$data['loc_desc']		= get_var( 'loc_desc' );
		$config['total_rows']	= $data['total_cities']	= $this->Location_model->count( $query_filter );
		$data['cities']			= $this->Location_model->get_all( $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/cities/all/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'cities_list', $data );
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'desc', 
				'label'   => 'Descripción', 
				'rules'   => 'trim|required|max_length[128]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$id = isset( $post['id'] ) ? intval( $post['id'] ) : 0;
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( $id == 0 )
			{
				$id = $this->Location_model->add( $post['name'], $post['desc'] );
				
				$this->id_replace( $id );
				
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "id" )' );
				
				$this->kajax->fancy_log_success( "Ciudad: " . $post['name'] . " añadida con éxito." );
			}
			else
			{
				if ( $this->Location_model->exists( $id )  )
				{
					$this->Location_model->edit( $id, $post['name'], $post['desc'] );
					
					$this->kajax->fancy_log_success( "Ciudad: " . $post['name'] . " guardada con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error(  "Ciudad: " . $post['name'] . " no existe." );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $id );
		
		$this->kajax->out();
	}
	
	protected function id_replace( $id )
	{
		$this->kajax_replace_new_ids( $id, array( 'row_', 'row_hidden_' ) );
	}
	
	public function get_new_row()
	{
		$this->session_restrict( USER_TYPE_GOD );
		$this->kajax->prepend( '#cities_list_table', $this->load->view( 'new_row_city', NULL, TRUE ) );
		$this->kajax->out();
	}
}
