<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Avl extends BASE_Controller
{
	const AVL_CODE_LOW_BATTERY = 17;
	const AVL_CODE_MAX_SPEED = 19;
	const AVL_CODE_CRASH = 30;
	const AVL_CODE_ALARM = 58;
	
	public static function parse_date( $mtk_date )
	{
		$year 	= substr( $mtk_date, 0, 2 );
		$month	= substr( $mtk_date, 2, 2 );
		$day	= substr( $mtk_date, 4, 2 );
		$hour	= substr( $mtk_date, 6, 2 );
		$minute	= substr( $mtk_date, 8, 2 );
		$second	= substr( $mtk_date, 10, 2 );
		date_default_timezone_set('UTC');
		return mktime( intval( $hour ), intval( $minute ), intval( $second ), intval( $month ), intval( $day ), 2000 + intval( $year ) );
	}
	
	protected function get_global_event_desc( $evcode, $imei, $speed, $lat, $long )
	{
		switch ( $evcode )
		{
			case self::AVL_CODE_ALARM:
			{
				return "Alarma en: $lat $long";;
			}
			case self::AVL_CODE_MAX_SPEED:
			{
				return 'Exceso de velocidad: ' . $speed . ' km/h';
			}
			case self::AVL_CODE_CRASH:
			{
				return "Choque en: $lat $long";
			}
			case self::AVL_CODE_LOW_BATTERY:
			{
				return "Batería Baja";
			}
		}
		
		return "";
	}
	
	protected function get_global_event_emergency( $evcode )
	{
		switch ( $evcode )
		{
			case self::AVL_CODE_MAX_SPEED:
			case self::AVL_CODE_CRASH:
			case self::AVL_CODE_ALARM:
			{
				return 1;
			}
		}
		
		return 0;
	}
	
	protected function add_global_event( $imei, $evcode, $event_id, $speed, $lat, $long )
	{
		switch ( $evcode )
		{
			case self::AVL_CODE_LOW_BATTERY:
			case self::AVL_CODE_MAX_SPEED:
			case self::AVL_CODE_CRASH:
			case self::AVL_CODE_ALARM:
			{
				$this->load->model('GlobalEvent_model');
				$this->load->model('AvlHardware_model');
				
				$hw = $this->AvlHardware_model->get( $imei );
				
				if ( isset( $hw ) )
				{
					$this->GlobalEvent_model->add(	GlobalEventType::GEOTRACE, 
													$event_id, 
													isset( $hw['avl_uid'] ) ? $hw['avl_uid'] : 0, 
													$imei, 
													$imei, 
													$imei, 
													$hw['ahw_company'], 
													time(),
													$this->get_global_event_desc( $evcode, $imei, $speed, $lat, $long ),
													$this->get_global_event_emergency( $evcode )
					);
				}
				
				break;
			}
		}
	}
	
	protected function process_aaa( &$e, $esize )
	{
		if ( $esize < 14 ) return false;
		
		/** reference
			$$<packageflag><L>,<IMEI>,<command>,<eventcode>,<(-)yy.dddddd>,<(-)xxx.dddddd>
			,<yymmddHHMMSS>,<Z>,<N>,<G>,<Speed>,<Heading>,<HDOP>,<Altitude>,<Journey>,<Runtime>,
			<BaseID>,<State>,<AD>,<RFID>/<Picture>/<Fence>,<CustomizeData>,<ProtocolVersion>,<RPM>,
			<Engine Load Calculation>,<Engine Coolant Temperature>,<Fuel Consumption of 100KM>, <Intake Air
			Temperature>,<Oil Pressure>,<Atmospheric Pressure>,<Intake-tubeabsolute Pressure> ,<Air
			Flow>,<Throttle Position>,<Mileage>,<Percentage of Remain Fuel>,<Fault Codes and Freeze
			Frame/Ready Status>,<*checksum>\r\n */
		
		$imei		= $e[1];
		$evcode		= intval( $e[3] );
		$lat		= ( $e[4] );
		$long		= ( $e[5] );
		$date		= AVL::parse_date( $e[6] );
		$gpsstatus	= substr( $e[7], 0, 1 );
		$gpssatnum	= intval( $e[8] );
		$gsmsignal	= intval( $e[9] );
		$speed		= intval( $e[10] );
		$heading	= intval( $e[11] );
		$hdop		= ( $e[12] );
		$altitude	= intval( $e[13] );
		
		$this->load->model( 'AvlHardware_model' );
		$this->load->model('AvlEvent_model');
		
		if ( isset( $imei ) )
		{
			$this->AvlHardware_model->add_cond( $imei, "Vehículo sin asignar $imei" );
			
			if ( 'V' == $gpsstatus )
			{
				$date = time();
				
				$last_event = $this->AvlEvent_model->get_last_valid_position( $imei );
				
				if ( isset( $last_event ) )
				{
					$lat	= $last_event['ae_lat'];
					$long	= $last_event['ae_long'];
				}
			}
			
			$id = $this->AvlEvent_model->add( $imei, $evcode, $lat, $long, $date, $gpsstatus, $gpssatnum, $gsmsignal, $speed, $heading, $hdop, $altitude );
			
			$this->add_global_event( $imei, $evcode, $id, $speed, $lat, $long );
		}
		
		return true;
	}
	
	protected function process_cmd( $cmd, &$e, $esize )
	{
		switch ( $cmd )
		{
			case 'AAA':	return $this->process_aaa( $e, $esize );
		}
	}
	
	public function push()
	{
		http_header_json_no_cache();
		
		$this->load->library('meitrack');
		$this->load->model('AvlHardware_model');		

		$data	= get_post( 'data' );
		$ip		= get_post('ip');
		$port	= intval( get_post('port') );
		
		if ( NULL != $data && -1 != str_starts_with( '$$', $data ) )
		{
			$checksum	= $this->meitrack->get_checksum( $data );
			$rdata		= explode( '*', $data );
			
			if ( isset( $rdata ) && count( $rdata ) >= 2 && $checksum == trim( $rdata[1], "\r\n " ) )
			{
				$e		= explode( ',', $rdata[0] );
				$s		= count( $e );
				
				if ( $s >= 3 )
				{
					$this->process_cmd( $e[2], $e, $s );
				}
			}
			
			if ( $ip && isset( $e[1] ) && !empty( $e[1] ) && is_string( $ip ) && filter_var( $ip, FILTER_VALIDATE_IP ) )
			{
				$this->AvlHardware_model->update_ip( $e[1], $ip );
			}
			
			if ( $port && isset( $e[1] ) && !empty( $e[1] ) && 0 != $port )
			{
				$this->AvlHardware_model->update_port( $e[1], $port );
			}
		}
		else
		{
			$json = json_decode($data, TRUE);
			
			if ( $json && isset( $json['cmd'] ) )
			{
				switch ( $json['cmd'] )
				{
					case 'config':
					case 'config_set':
					{
						$this->AvlHardware_model->update_config( $json['imei'], json_encode( $json['config'] ) );
						
						break;
					}
					case 'config_response':
					{
						if ( isset( $json['result'] ) )
						{
							$result = strtoupper( $json['result'] );
							
							if ( $result == 'OK' )
							{
								$result = 'COMPLETED';
							}
							
							if ( $result != 'COMPLETED' && $result != 'ERROR' && $result != 'TIMEOUT' )
							{
								$result = 'ERROR';
							}
							
							$this->AvlHardware_model->update_cmd_state( $json['imei'], $result );
						}
						
						break;
					}
					case 'config_get':
					{
						$this->meitrack->send_msg( $json['imei'], $this->meitrack->gen_config( $json['imei'], $this->AvlHardware_model->get_config( $json['imei'], TRUE ) ) );
						
						break;
					}
				}
				
				if ( isset( $ip ) && is_string( $ip ) && filter_var( $ip, FILTER_VALIDATE_IP ) )
				{
					$this->AvlHardware_model->update_ip( $json['imei'], $ip );
				}
				
				if ( isset( $port ) && is_int( $port ) && $port )
				{
					$this->AvlHardware_model->update_port( $json['imei'], $port );
				}
				
				$data = $json;
			}
		}
		
		$res = NULL != $data ? $data : 'NO DATA';
		
		echo json_encode( array( 'result' => $res ) );
	}
	
	public function location()
	{
		$json = get_json_body();
		
		http_header_json_no_cache();
		
		if ( isset( $json ) )
		{
			if ( is_post() )
			{
				if ( isset( $json['imei'] ) && isset( $json['locations'] ) )
				{
					$this->load->model('AvlHardware_model');
					$this->load->model('AvlEvent_model');
					
					foreach( $json['locations'] as $loc )
					{
						$imei = $json['imei'];
						$this->AvlHardware_model->add_cond( $imei, "Vehículo sin asignar $imei" );
						
						$evcode = 35;
						
						$id = $this->AvlEvent_model->add( $imei, $evcode, $loc['latitude'], $loc['longitude'], $loc['timestamp'], 'A', 8, 21, $loc['speed'], $loc['bearing'], 0, intval( $loc['altitude'] ) );
						
						// @TODO: implement evcode in Android client for the panic event and stuff?
						$this->add_global_event( $imei, $evcode, $id, $loc['speed'], $loc['latitude'], $loc['longitude'] );
					}
					
					echo json_encode( $json['locations'] );
				}
				else
				{
					echo '[]';
				}
			}
			else
			{
				http_response_code(404);
			}
		}
		else
		{
			http_response_code(400);
		}
		
	}
	
	public function push_test()
	{
		http_header_json_no_cache();
		
		$host	= DEBUG_SERVER ? 'domo-dev' : 'localhost';
		$prot	= NULL != get_var('udp') ? 'udp' : 'tcp';
		$port	= intval( get_var_def( 'port', 4550 ) );
		$str	= "\$\$G127,353358017784062,AAA,1,-38.017921,-57.561,100313095653,A,3,21,4,46,5,581,0,148,0|0|10133|4172,0000,166|204|205|2709|878,*FC\r\n";
		$res	= '';
		
		while ( $str != "" )
		{
			$fp = fsockopen( $prot . "://$host", $port, $errno, $errstr);
			
			if ( $fp )
			{
				$msgs	= strpos( $str, "\r\n" );
				$push	= substr( $str, 0, $msgs );
				fwrite($fp, $push);
				$str	= substr( $str, $msgs + 2 );
				
				if ( 'tcp' == $prot )
				{
					$res = fread($fp, 8192);
				}
				else
				{
					$res = "OK";
				}
				
				fclose($fp);
			}
			else
			{
				$res	= "CONNECTION FAILED";
				$str	= "";
			}
		}
		
		echo json_encode( array( 'result' => $res, 'port' => $port, 'host' => $host ) );
	}
	
	public function response_test()
	{
		http_header_json_no_cache();
		
		$this->load->library('meitrack');
		$this->load->model('AvlHardware_model');
		
		$imei = get_var_def( 'imei', '353358017784062' );
		
		$cfg = $this->AvlHardware_model->get_config( $imei, TRUE );
		
		$cmd['cmd']		= 'config_set';
		$cmd['imei']	= $imei;
		$cmd['config']	= $cfg;
		
		echo json_enc( $cmd );
		
		$this->meitrack->send_msg( $imei, $cmd );
	}
}
