<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once( FRAMES_PATH . 'transcoder.php' );
require_once( FRAMES_PATH . 'frame.php' );
require_once( FRAMES_PATH . 'framecfg.php' );
require_once( FRAMES_PATH . 'framecitymeshcfg.php' );
require_once( FRAMES_PATH . 'framenoisecfg.php' );
require_once( FRAMES_PATH . 'framekpanel.php' );
require_once( FRAMES_PATH . 'actions.php' );

class Api extends BASE_Controller
{
	public function send()
	{
		http_header_json_no_cache();
		
		ini_set('memory_limit', '512M');

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq, com_city FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SEND, $res['com_id'] );
			
			$this->load->model('Test_model');
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);

				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];

				if($calc_sign === $data['signature'])
				{
					/* checks the table "package_control" first */
					$r = $this->db->get_row( 'SELECT timestamp FROM package_control WHERE signature = ?', OBJECT, array( $calc_sign ) );

					if(NULL != $r) //it exists
					{
						die( json_encode($response) ); //response ok, and die, don't add again
					}
					else
					{
						//add and continue
						$this->db->query('INSERT INTO package_control (signature) VALUES (?)', array( $calc_sign ) );
					}
					/*------------------------------*/

					$frames = Transcoder::zdecode($data['frames']);

					$this->db->trans_start();

					$frames_data = array();
					foreach( $frames as $frame )
					{
						$f = new Frame();
						$f->decode($frame);

						if($res["com_df_id"] == $f->getData('company_code') && $res["com_rec_id"] == $f->getData('receiver_code'))
						{
							$f->add_todb();
							
							$frames_data[] = array(
								'company_code' => $f->getData('company_code'),
								'receiver_code' => $f->getData('receiver_code'),
								'hw_code' => $f->getData('hw_code'),
								'hw_timestamp' => $f->getData('hw_timestamp'),
								'hw_serial' => $f->getData('hw_serial'),
								'type' => $f->get_type()
							);
						}
						else
						{
							if(!isset($response["ERROR_invalid_frames_received"]))
							{
								$response["ERROR_invalid_frames_received"] = 0;
							}
							
							$response["ERROR_invalid_frames_received"] ++;
						}

					}
					
					$this->db->trans_complete();

					unset($frames); //WARNING: AHORRAR MEM

					$insert_hwd = array();
					$already_hw_ids = array(); //holds alreay saved hw_id's in loop
					$update_logs = array();

					//auto adds hardware

					foreach($frames_data as $fd)
					{
						if ( !isset( $fd['hw_serial'] ) || $fd['hw_serial'] == 0 )
						{
							continue;
						}
						
						$hw_id = $this->db->get_var('SELECT hw_id FROM hardware WHERE hw_df_company = ? AND hw_df_receiver = ? AND hw_code = ? AND hw_serial = ? LIMIT 1', 
													array($fd['company_code'],$fd['receiver_code'],$fd['hw_code'],$fd['hw_serial']) );

						$is_tmp = false;

						if(!$hw_id) //if hardware doesn't exists, checks hardware_tmp also if exists in other company
						{
							$hw = $this->db->get_row('SELECT hw_id, hw_company, hw_df_company, hw_df_receiver, hw_code FROM hardware WHERE hw_serial = ? LIMIT 1', ARRAY_A, array( $fd['hw_serial'] ) );
							
							if ( isset( $hw ) )
							{
								// The hardware already existed in other company, so we need to migrate the hardware to the current reported company
								// To do that we first delete the hardware that seems to be migrated, then it'll be added by the create_new_hw cron job
								if ( $res['com_id'] != $hw['hw_company'] )
								{
									// If the hardware only changed the receiver, we update the receiver ( and the com_id ), and keep the hw data
									if ( $fd['company_code'] == $hw['hw_df_company'] && $fd['hw_code'] == $hw['hw_code'] && $fd['receiver_code'] != $hw['hw_df_receiver'] )
									{
										// But this will be updated in the create_new_hardware cron job, so we do nothing here.
									}
									else
									{
										$this->db->query('DELETE FROM hardware WHERE hw_id = ?', array( $hw['hw_id'] ) );
									}
								}
							}
							
							$hw_id = $this->db->get_var('SELECT hwt_id FROM hardware_tmp WHERE hwt_df_company = ? AND hwt_df_receiver = ? AND hwt_code = ? AND hwt_serial = ? LIMIT 1',
													array($fd['company_code'],$fd['receiver_code'],$fd['hw_code'],$fd['hw_serial']) );
							$is_tmp = true;
						}

						if(!$hw_id)
						{
							if( ($fd['type'] == FrameType::TEST || $fd['type'] == FrameType::CORE_TEST) && !in_array($fd['hw_serial'],$already_hw_ids) )
							{
								$insert_hwd[] = $fd; //para agregar hardware no registrado
								$already_hw_ids[] = $fd['hw_serial'];
							}
						}
						else
						{
							if($fd['type'] == FrameType::TEST || $fd['type'] == FrameType::CORE_TEST)
							{
								if(!$is_tmp)
								{
									$update_logs[] = array( 'hw_id'=>$hw_id,
														'hw_timestamp' =>	$fd['hw_timestamp']
														); //para incrementar test_logs
									
									$this->Test_model->add( $res['com_id'], $hw_id, $fd['hw_timestamp'] );
								}
								else
								{
									$this->db->query('UPDATE hardware_tmp SET hwt_testcount = hwt_testcount+1 WHERE hwt_id = ?', array($hw_id));
								}
							}
						}
					}

					unset($frames_data); //WARNING: AHORRAR MEM

					$this->db->trans_start();

					/*---------------insert new hardware ---------------*/

					foreach($insert_hwd as $hwd)
					{
						$this->db->query('INSERT INTO hardware_tmp (hwt_df_company,hwt_df_receiver,hwt_code, hwt_serial) VALUES (?,?,?,?)',
							array(
								$hwd['company_code'],
								$hwd['receiver_code'], //hw_df_company, hw_df_receiver
								$hwd['hw_code'],
								$hwd['hw_serial']
							)
						);
					}
					
					/*---------------tests_log table update---------------*/
					$this->db->trans_complete();

					$last_logs = array();
					foreach($update_logs as $uplog)
					{
						$timestamp =$uplog['hw_timestamp'];
						$hw_id = $uplog['hw_id'];
						$last_logs[] = array( 	'hw_id' => $hw_id,
												'timestamp' => $timestamp,
												'tl_id' => $this->db->get_var('SELECT tl_id FROM tests_log
																	WHERE tl_hw_id = ' . $hw_id . '
																	AND tl_from_time + '. FrameUtils::$TESTS_LOG_TIMESPAN_SEC ." > $timestamp AND tl_from_time <= $timestamp" )
											);
					}
					
					$already_tl_ids = array();
					$this->db->trans_start();
					
					foreach($last_logs as $log)
					{
						$hw_id = $log['hw_id'];

						if(NULL != $log['tl_id']) //tlid for this hour range found, useit
						{
							$this->db->query('UPDATE tests_log SET tl_tests_count=tl_tests_count+1 WHERE tl_id = ?', array($log['tl_id']));
						}
						else /*tlid not found, create one*/
						{
							$time_base = floor( $log['timestamp'] / FrameUtils::$TESTS_LOG_TIMESPAN_SEC ) * FrameUtils::$TESTS_LOG_TIMESPAN_SEC;
							
							if( !isset( $already_tl_ids[ $time_base ][ $hw_id ] ))
							{
								$this->db->query('INSERT INTO tests_log (tl_from_time, tl_tests_count, tl_hw_id) VALUES (?,?,?)', array($time_base,1, $log['hw_id']) );
								
								$already_tl_ids[$time_base][$hw_id] = $this->db->insert_id();
							}
							else
							{
								$this->db->query('UPDATE tests_log SET tl_tests_count=tl_tests_count+1 WHERE tl_id = ?', array($already_tl_ids[ $time_base ][ $hw_id ]));
							}
						}
					}
					
					$this->db->trans_complete();
					
					/* --------------- tests_log_company table update --------------- */
					
					// Sum the test to the company total test every 5 minutes
					$already_com_times = array();
					
					foreach($last_logs as &$log)
					{
						// First we search if the timestamp is already on the table
						$rep_freq	= $res['com_hw_report_freq'] * 60;
						$timec_base = floor( $log['timestamp'] / $rep_freq ) * $rep_freq;
						
						$log['timewrite'] = $timec_base;
						
						if ( !isset( $already_com_times[ $timec_base ] ) )
						{
							// Wasn't searched yet
							
							// register the select
							$already_com_times[ $timec_base ] = $this->db->get_var( 'SELECT tlc_id FROM tests_log_company WHERE tlc_com_id = ? AND tlc_from_time = ?', 
																				array( $res['com_id'], $timec_base ) );
						}
						
						// if the time is on the table
						if ( NULL != $already_com_times[ $timec_base ] )
						{
							// we need to update
							$log['update'] = $already_com_times[ $timec_base ];
						}
						
						$hw_data			= array( $log['hw_id'], $timec_base, $res['com_id'] );
						$hw_already_counted	= $this->db->get_var( 'SELECT COUNT(tlht_hw_id) FROM tests_log_hw_tmp WHERE tlht_hw_id = ? AND tlht_timestamp = ? AND tlht_com_id = ?', $hw_data );
						
						// We only add the test log count if that hardware wansn't already counted, since we need to know the
						// total hw that reported in that timelapse
						if ( 0 == $hw_already_counted )
						{
							if ( isset( $log['update'] ) )
							{
								$this->db->query( 'UPDATE tests_log_company SET tlc_tests_count=tlc_tests_count+1 WHERE tlc_id = ?', array( $log['update'] ) );
							}
							else
							{
								$this->db->query( 'INSERT INTO tests_log_company ( tlc_com_id, tlc_from_time, tlc_tests_count ) VALUES ( ?, ?, 1 )',
													array( $res['com_id'], $log['timewrite'] ) );
								
								$already_com_times[ $timec_base ] = $this->db->insert_id();
							}
							
							$this->db->query( 'INSERT INTO tests_log_hw_tmp ( tlht_hw_id, tlht_timestamp, tlht_com_id ) VALUES ( ?, ?, ? )', $hw_data );
							
							// Write in the log history by group
							$groups = $this->db->get_results( 'SELECT hwgl_group FROM hardware_group_link INNER JOIN hardware_group ON hwg_id = hwgl_group WHERE hwg_company = ? AND hwgl_hw_id = ?', ARRAY_A, array( $res['com_id'], $log['hw_id'] ) );
							
							if ( NULL != $groups && !empty( $groups ) )
							{
								foreach( $groups as $group )
								{
									$hwg_data = array( $res['com_id'], $timec_base, $group['hwgl_group'] );
									
									$group_reg = $this->db->get_var( 'SELECT tlcg_id FROM tests_log_company_group WHERE tlcg_com_id = ? AND tlcg_from_time = ? AND tlcg_group = ? LIMIT 1', $hwg_data );
									
									if ( NULL == $group_reg )
									{
										$this->db->query( 'INSERT INTO tests_log_company_group ( tlcg_com_id, tlcg_from_time, tlcg_group, tlcg_tests_count ) VALUES ( ?, ?, ?, 1 )', $hwg_data );
									}
									else
									{
										$this->db->query( 'UPDATE tests_log_company_group SET tlcg_tests_count=tlcg_tests_count+1 WHERE tlcg_id = ?', array( $group_reg ) );
									}
								}
							}
						}
					}
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendcfg()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDCFG, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);

				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if( $calc_sign === $data['signature'] )
				{
					$this->load->model('HardwareConfigCommand_model');
					$this->load->model('CompanyAirmeshConfig_model');
					$this->load->model('AirmeshConfigLog_model');
					
					$frames = Transcoder::zdecode($data['frames']);
					
					$this->db->trans_start();
					
					$batch_id = $this->HardwareConfigCommand_model->get_last_company_batch_id( $res['com_id'] );
					
					$was_done = $this->HardwareConfigCommand_model->batch_is_done( $batch_id );
					
					$resp['config'] = $config = $this->CompanyAirmeshConfig_model->get( $res['com_id'] );
					
					if ( isset( $resp['config'] ) && isset( $resp['config']['cac_cancel_batch'] ) && 1 == $resp['config']['cac_cancel_batch'] )
					{
						$this->CompanyAirmeshConfig_model->reset_batch_cancellation( $res['com_id'] );
					}
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						$this->load->model('Hardware_model');
						$this->load->model('HardwareGroup_model');
						
						foreach( $frames as $frame )
						{
							$f = new FrameCfg();
							
							$f->decode( $frame );
							
							$hw_serial = $f->get_hw_serial();
							
							if ( !isset( $hw_serial ) || $hw_serial == 0 )
							{
								continue;
							}
							
							$this->Hardware_model->update_last_message( $hw_serial );
							
							$was_done_serial = $this->HardwareConfigCommand_model->batch_is_done_for_serial( $batch_id, $hw_serial );
							
							$f->process( $batch_id );
							
							$cmd =	$f->get_frame_data_str();
							
							$msg = 'Received Command: ' . $cmd . ' for MAC: ' . dechex( $hw_serial );
							
							$this->AirmeshConfigLog_model->add( $res['com_id'], $f->getData('hw_timestamp'), $msg );
							
							$is_done_serial = $this->HardwareConfigCommand_model->batch_is_done_for_serial( $batch_id, $hw_serial );
							
							// if the last batch ended, add to the selected group
							if ( FALSE == $was_done_serial && TRUE == $is_done_serial )
							{
								$success = $this->HardwareConfigCommand_model->batch_is_done_successfully_for_serial( $batch_id, $hw_serial );
								
								if ( $success && isset( $config['cac_add_to_group'] ) && intval( $config['cac_add_to_group'] ) != 0 )
								{
									$group = intval( $config['cac_add_to_group'] );
									$gname = $this->HardwareGroup_model->get_name( $group );
									
									$hwcc = $this->Hardware_model->get_from_serial( $hw_serial, ARRAY_A );
									
									if ( isset( $hwcc ) )
									{
										if ( $this->HardwareGroup_model->link( $group, $hwcc['hw_id'] ) )
										{
											$msg = 'Added MAC: ' . dechex( $hw_serial ) . ' to group: ' . $gname;
										
											$this->AirmeshConfigLog_model->add( $res['com_id'], time(), $msg );
										}
										else
										{
											$msg = 'Tried to add MAC: ' . dechex( $hw_serial ) . ' to group: ' . $gname . ', but was already there.';
											
											$this->AirmeshConfigLog_model->add( $res['com_id'], time(), $msg );
										}
									}
									
									$this->CompanyAirmeshConfig_model->add_to_group_reset( $res['com_id'] );
								}
							}
						}
						
						$is_done = $this->HardwareConfigCommand_model->batch_is_done( $batch_id );
						
						if ( FALSE == $was_done && TRUE == $is_done )
						{
							$this->AirmeshConfigLog_model->add( $res['com_id'], time(), "Completed Commands Batch: $batch_id ( " . ( $success ? 'successfully' : 'with errors' ) . " )" );
						}
					}
					
					$this->db->trans_complete();
					
					$resp['frames'] = $this->HardwareConfigCommand_model->get_pending_commands( $res['com_id'] );
					
					if ( isset( $resp['frames'] ) )
					{
						foreach ( $resp['frames'] as $frame_log )
						{
							$msg = airmesh_command_msg( 'Sending Command',	$frame_log['hwcc_serial'], $frame_log['hwcc_timestamp'], $frame_log['hwcc_state_type'], 
																			$frame_log['hwcc_mode'], short_to_string( $frame_log['hwcc_cmd'] ), 
																			$frame_log['hwcc_data_count'], $frame_log['hwcc_frame_data'] );
							
							$this->AirmeshConfigLog_model->add( $res['com_id'], $frame_log['hwcc_timestamp'], $msg );
						}
					}
					
					$ndata = Transcoder::zencode($resp);
					$signature = FrameUtils::calculate_signature($ndata);
					
					$response['signature_data'] = $signature;
					$response['data'] = $ndata;
					
					$this->HardwareConfigCommand_model->set_waiting_response( $res['com_id'] );
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendcitymeshcfg()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDCITYMESHCFG, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);

				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if( $calc_sign === $data['signature'] )
				{
					$this->load->model('HardwareCityMeshCommand_model');
					$this->load->model('CompanyCityMeshConfig_model');
					$this->load->model('CityMeshConfigLog_model');
					
					$frames = Transcoder::zdecode($data['frames']);
					
					$this->db->trans_start();
					
					$batch_id = $this->HardwareCityMeshCommand_model->get_last_company_batch_id( $res['com_id'] );
					
					$was_done = $this->HardwareCityMeshCommand_model->batch_is_done( $batch_id );
					
					$resp['config'] = $config = $this->CompanyCityMeshConfig_model->get( $res['com_id'] );
					
					if ( isset( $resp['config'] ) && isset( $resp['config']['ccc_cancel_batch'] ) && 1 == $resp['config']['ccc_cancel_batch'] )
					{
						$this->CompanyCityMeshConfig_model->reset_batch_cancellation( $res['com_id'] );
					}
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						$this->load->model('Hardware_model');
						$this->load->model('HardwareGroup_model');
						
						foreach( $frames as $frame )
						{
							$f = new FrameCityMeshCfg();
							
							$f->decode( $frame );
							
							$hw_serial = $f->get_hw_serial();
							
							if ( !isset( $hw_serial ) || $hw_serial == 0 )
							{
								continue;
							}
							
							$this->Hardware_model->update_last_message( $hw_serial );
							
							$was_done_serial = $this->HardwareCityMeshCommand_model->batch_is_done_for_serial( $batch_id, $hw_serial );
							
							$f->process( $batch_id );
							
							$cmd =	$f->get_frame_data_str();
							
							$msg = 'Received Command: ' . $cmd . ' for MAC: ' . dechex( $hw_serial );
							
							$this->CityMeshConfigLog_model->add( $res['com_id'], $f->getData('hw_timestamp'), $msg );
							
							$is_done_serial = $this->HardwareCityMeshCommand_model->batch_is_done_for_serial( $batch_id, $hw_serial );
							
							// if the last batch ended, add to the selected group
							if ( FALSE == $was_done_serial && TRUE == $is_done_serial )
							{
								$success = $this->HardwareCityMeshCommand_model->batch_is_done_successfully_for_serial( $batch_id, $hw_serial );
								
								if ( $success && isset( $config['ccc_add_to_group'] ) && intval( $config['ccc_add_to_group'] ) != 0 )
								{
									$group = intval( $config['ccc_add_to_group'] );
									$gname = $this->HardwareGroup_model->get_name( $group );
									
									$hwcc = $this->Hardware_model->get_from_serial( $hw_serial, ARRAY_A );
									
									if ( isset( $hwcc ) )
									{
										if ( $this->HardwareGroup_model->link( $group, $hwcc['hw_id'] ) )
										{
											$msg = 'Added MAC: ' . dechex( $hw_serial ) . ' to group: ' . $gname;
										
											$this->CityMeshConfigLog_model->add( $res['com_id'], time(), $msg );
										}
										else
										{
											$msg = 'Tried to add MAC: ' . dechex( $hw_serial ) . ' to group: ' . $gname . ', but was already there.';
											
											$this->CityMeshConfigLog_model->add( $res['com_id'], time(), $msg );
										}
									}
									
									$this->CompanyCityMeshConfig_model->add_to_group_reset( $res['com_id'] );
								}
							}
						}
						
						$is_done = $this->HardwareCityMeshCommand_model->batch_is_done( $batch_id );
						
						if ( FALSE == $was_done && TRUE == $is_done )
						{
							$this->CityMeshConfigLog_model->add( $res['com_id'], time(), "Completed Commands Batch: $batch_id ( " . ( $success ? 'successfully' : 'with errors' ) . " )" );	
						}
					}
					
					$this->db->trans_complete();
					
					$resp['frames'] = $this->HardwareCityMeshCommand_model->get_pending_commands( $res['com_id'] );
					
					if ( isset( $resp['frames'] ) )
					{
						foreach ( $resp['frames'] as $frame_log )
						{
							$msg = citymesh_command_msg( 'Sending Command',	$frame_log['hwcc_serial'], 
																			$frame_log['hwcc_timestamp'], 
																			$frame_log['hwcc_code'], 
																			$frame_log['hwcc_msg_type'], 
																			$frame_log['hwcc_mode'], 
																			$frame_log['hwcc_cmd'], 
																			$frame_log['hwcc_val'], 
																			$frame_log['hwcc_msg_type_val'], 
																			$frame_log['hwcc_force'], 
																			$frame_log['hwcc_checksum']
							);
							
							$this->CityMeshConfigLog_model->add( $res['com_id'], $frame_log['hwcc_timestamp'], $msg );
						}
					}
					
					$ndata = Transcoder::zencode($resp);
					$signature = FrameUtils::calculate_signature($ndata);
					
					$response['signature_data'] = $signature;
					$response['data'] = $ndata;
					
					$this->HardwareCityMeshCommand_model->set_waiting_response( $res['com_id'] );
					
					Actions::set_config_waiting_response( $res['com_id'] );
					
					Actions::set_waiting_response( $res['com_id'] );
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendnoisecfg()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');
		$first = get_var('first_request');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			$this->load->model('HardwareNoiseConfig_model');
			$this->load->model('CompanyNoiseConfig_model');
			
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDNOISECFG, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if ( NULL == $data )
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);
				
				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if ( $calc_sign === $data['signature'] )
				{
					$com_id = $res['com_id'];
					$frames = Transcoder::zdecode($data['frames']);
					
					$this->db->trans_start();
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						foreach( $frames as $frame )
						{
							$f = new FrameNoiseCfg();
							
							$f->decode( $frame );
							
							$f->process( $com_id );
						}
					}
					
					$this->db->trans_complete();
					
					$pending = null;
					
					if ( isset( $first ) )
					{
						$pending				= $this->HardwareNoiseConfig_model->get_all( $com_id );
					}
					else
					{
						$pending				= $this->HardwareNoiseConfig_model->get_pending_send( $com_id );
					}
					
					$config						= $this->CompanyNoiseConfig_model->get( $com_id );
					
					$resp['config']				= $config;
					$resp['frames']				= $pending;
					
					$data_resp					= Transcoder::zencode( $resp );
					$signature					= FrameUtils::calculate_signature( $data_resp );
					
					$response['signature_data']	= $signature;
					$response['data']			= $data_resp;
					
					$this->HardwareNoiseConfig_model->set_all_sent( $com_id );
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendrfid()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDRFID, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);
				
				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if( $calc_sign === $data['signature'] )
				{
					$this->load->model('Rfid_model');
					$this->load->model('RfidUser_model');
					$this->load->model('RfidEvent_model');
					$this->load->model('RfidCitymesh_model');
					$this->load->model('GlobalEvent_model');
					$this->load->model('Hardware_model');
					
					$frames = Transcoder::jsondecode($data['frames']);
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						foreach ( $frames as $f )
						{
							$this->Hardware_model->update_last_message( $f->id );
							
							$this->Rfid_model->add_cond( $f->id, $res['com_id'] );
							
							if ( $f->packet_type <= 0x7F )
							{
								if ( RfidType::RFID == $f->packet_type )
								{
									$open_barrier = FALSE;
									$user_id = $this->RfidUser_model->get_id_from_serial( $f->id );
									$state = $f->event_type == RfidEventType::DENIED_ACCESS ? 'REJECTED' : ( $f->event_type <= RfidEventType::LEAVE ? 'PENDING_VALIDATE' : 'ACCEPTED' );
									
									if ( isset( $f->resp_state ) && ( $f->resp_state & RfidResponseStateType::RESP_TIMEOUT ) )
									{
										$state = 'ERROR_TIMEOUT';
									}
									
									$city_type = RfidCitymeshType::from_event_type( $f->event_type );
									
									if ( -1 != $city_type )
									{
										$this->RfidCitymesh_model->update_type( $f->code, $res['com_id'], $city_type );
									}
									
									$rcity = $this->RfidCitymesh_model->get( $f->code, $res['com_id'] );
									
									if ( $f->event_type == RfidEventType::DENIED_ACCESS )
									{
										$person = $this->RfidUser_model->get_by_serial( $f->id );
										
										if ( isset( $person ) )
										{
											$add_type = $person['urfid_user_type'] == RfIdUserType::GUARD ? RfidCommandType::ADD_VIP : RfidCommandType::ADD;
											
											// Register the RFID in Citymesh
											$this->RfidEvent_model->add( $f->id, $f->code, RfidType::RFID, $add_type, time(), $res['com_id'], 'PENDING_SEND', $user_id );
											
											// Add the Rejected event, and then the access event
											$this->RfidEvent_model->add( $f->id, $f->code, $f->packet_type, $f->event_type, $f->timestamp, $res['com_id'], $state, $user_id );
											
											$state = 'PENDING_VALIDATE';
											
											$f->event_type = RfidEventType::UNKNOWN;
											
											if ( isset( $rcity ) )
											{
												$f->event_type = RfidCitymeshType::to_event_type( $rcity['rc_type'] );
											}
											
											if ( $person['urfid_user_type'] == RfIdUserType::GUARD )
											{
												$f->event_type += RfidEventType::UNKNOWN_VIP; // Convert to VIP if user is guard
											}
										}
									}
									else if ( !isset( $user_id ) )
									{
										$this->RfidEvent_model->add( $f->id, $f->code, RfidType::RFID, RfidCommandType::ERASE, time(), $res['com_id'], 'PENDING_SEND' );
									}
									else if ( isset( $rcity ) )
									{
										$this->load->model( 'CompanyTimeFrame_model' );
										$this->load->model( 'RfidUserTypeHours_model' );
										
										$time_frame_is_active = FALSE;
										
										if ( $rcity['rc_type'] != RfidCitymeshType::UNKNOWN )
										{
											$time_frame_is_active = $this->CompanyTimeFrame_model->is_active( $res['com_id'], $rcity['rc_type'], $f->code );
										}
										
										$person = $this->RfidUser_model->get( $user_id );
										
										$is_simple_access = $this->RfidUserTypeHours_model->is_simple_access( $person['urfid_user_type'], $rcity['rc_type'] );
										
										if ( ( $rcity['rc_type'] == RfidCitymeshType::ENTRY && $person['urfid_entrance_type'] == RfidUserEntranceType::SIMPLE ) || 
											 ( $rcity['rc_type'] == RfidCitymeshType::LEAVE && $person['urfid_exit_type'] == RfidUserEntranceType::SIMPLE ) || 
											$time_frame_is_active || 
											$is_simple_access
										)
										{
											$data = $this->RfidEvent_model->get_event_result( $user_id, $rcity['rc_id'], $person );
											
											if ( $data['re_result'] == RfidEventResultType::NONE )
											{
												$state = 'ACCEPTED';
												
												$open_barrier = TRUE;
											}
										}
									}
									
									$event_id = $this->RfidEvent_model->add( $f->id, $f->code, $f->packet_type, $f->event_type, $f->timestamp, $res['com_id'], $state, $user_id );
									$event_desc = $this->RfidEvent_model->get_event_desc( $f->event_type, $f->id, $f->code, $f->timestamp, $f->packet_type, $state );
									
									$ge_id = $this->GlobalEvent_model->add( GlobalEventType::RFID, $event_id, $user_id, $f->id, $f->id, $f->code, $res['com_id'], $f->timestamp, $event_desc, 1 );
									
									if ( $open_barrier )
									{
										$this->RfidEvent_model->add( $f->id, $f->code, RfidType::OPEN, RfidCommandType::ADD, time(), $res['com_id'], 'PENDING_SEND', $user_id );
										
										$this->RfidEvent_model->set_serial_accept_on_pending_validation( $f->id, RfidEventResultType::NONE );
										
										if (  $rcity['rc_type'] != RfidCitymeshType::UNKNOWN )
										{
											$is_entry = RfidCitymeshType::is_entry( $rcity['rc_type'] );
										
											$this->RfidUser_model->update_entry_leave_status( $user_id, $is_entry );
										}
									}
								}
								else if ( RfidType::REMOTE_CONTROL == $f->packet_type )
								{
									$user_id = null;
									$state = 'OK';
									$event_id = $this->RfidEvent_model->add( $f->id, $f->code, $f->packet_type, $f->event_type, $f->timestamp, $res['com_id'], $state, $user_id );
									$event_desc = $this->RfidEvent_model->get_event_desc( $f->event_type, $f->id, $f->code, $f->timestamp, $f->packet_type, $state );
									
									$ge_id = $this->GlobalEvent_model->add( GlobalEventType::REMOTE_CONTROL, $event_id, $user_id, $f->id, $f->id, $f->code, $res['com_id'], $f->timestamp, $event_desc, 1 );
								}
								else if ( RfidType::UPDATE_CITYMESH == $f->packet_type )
								{
									$city_type = RfidCitymeshType::from_event_type( $f->event_type );
									
									if ( -1 != $city_type )
									{
										$this->RfidCitymesh_model->update_type( $f->code, $res['com_id'], $city_type );
									}
									
									$this->RfidEvent_model->add( $f->id, $f->code, RfidType::UPDATE_CITYMESH, $f->event_type, time(), $res['com_id'], 'OK' );
								}
							}
							else
							{
								if ( isset( $f->resp_state ) )
								{
									switch( $f->packet_type )
									{
										case RfidResponseType::STATE:
										case RfidResponseType::ERASE:
										case RfidResponseType::ADD:
										case RfidResponseType::OPEN:
										{
											$this->RfidEvent_model->update_command_state( $f->packet_type, $f->id, $f->code, $f->event_type, $f->resp_state );
											break;
										}
									}
								}
							}
						}
						
						$this->RfidCitymesh_model->add_cond( $f->code, $res['com_id'] );
					}
					
					if ( MASTER_SERVER && 'NpaNd1gm' != $api_key )
					{
						$resp['frames'] = $frames = NULL;
					}
					else
					{
						$resp['frames'] = $frames = $this->RfidEvent_model->get_pending_commands( $res['com_id'] );
					}
					
					$ndata = Transcoder::zencode($resp);
					$signature = FrameUtils::calculate_signature($ndata);
					
					$response['signature_data'] = $signature;
					$response['data'] = $ndata;
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						foreach ( $frames as $frame )
						{
							$this->RfidEvent_model->set_waiting_response_by_event_id( $frame['re_id'] );
						}
					}
					
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendgenericmsg()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDGENERICMSG, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$this->load->model('HardwareGenericMessage_model');
			$this->load->model('Hardware_model');
			
			$resp = $frames = $this->HardwareGenericMessage_model->get_pending( $res['com_id'] );
			
			$ndata = Transcoder::zencode($resp);
			$signature = FrameUtils::calculate_signature($ndata);
			
			$response['signature_data'] = $signature;
			$response['data'] = $ndata;
			
			if ( isset( $frames ) && !empty( $frames ) )
			{
				foreach ( $frames as $frame )
				{
					$this->HardwareGenericMessage_model->set_send( $frame['hgm_id'] );
					
					$this->Hardware_model->update_last_message( $frame['hgm_serial'] );
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function sendkpanel()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');

		$res = NULL;
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::SENDKPANEL, $res['com_id'] );
			
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);
				
				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if( $calc_sign === $data['signature'] )
				{
					$this->load->model('KPanelMsgReceived_model');
					$this->load->model('KPanelMsgSend_model');
					$this->load->model('Hardware_model');
					
					$frames = Transcoder::zdecode($data['frames']);
					
					$this->db->trans_start();
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						foreach( $frames as $frame )
						{
							$f = new FrameKPanel();
							
							$f->decode( $frame );
							
							$hw_serial = $f->get_hw_serial();
							
							if ( !isset( $hw_serial ) || $hw_serial == 0 )
							{
								continue;
							}
							
							$f->process( $res['com_id'] );
							
							$this->KPanelMsgReceived_model->add( $res['com_id'], $f->get_fields(), $f->get_raw_data() );
							
							$this->Hardware_model->update_last_message( $f->get_hw_serial() );
						}
					}
					
					$this->db->trans_complete();
					
					$resp['frames'] = $this->KPanelMsgSend_model->get_pending( $res['com_id'] );
					
					$ndata = Transcoder::zencode($resp);
					$signature = FrameUtils::calculate_signature($ndata);
					
					$response['signature_data'] = $signature;
					$response['data'] = $ndata;
					
					if ( isset( $resp['frames'] ) )
					{
						foreach ( $resp['frames'] as $msg )
						{
							$this->KPanelMsgSend_model->set_waiting_response( $msg['kms_id'] );
						}
					}
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	protected function ip_do_update( &$ips )
	{
		$cip = $this->input->ip_address();
		
		// Update the ip if is in the array
		if ( !empty( $ips ) )
		{
			foreach ( $ips as &$ip )
			{
				if ( $cip == $ip['ip'] )
				{
					$ip['time'] = time();
					
					return $ips;
				}
			}
		}
		
		// Add the ip if is not in the array
		// Up to 4 ips
		if ( count($ips) < 4 )
		{
			$ips[] = array( 'ip' => $cip, 'time' => time() );
		}
		else
		{
			// Replace the oldest ip
			$oip = NULL;
			$tim = 0;
			
			foreach( $ips as &$ip )
			{
				if ( 0 == $tim || $ip['time'] < $tim )
				{
					$oip = &$ip;
					$tim = $ip['time'];
				}
			}
			
			$oip['time'] = time();
			$oip['ip'] = $cip;
		}
		
		return $ips;
	}
	
	protected function ip_history_update( $iph )
	{
		$iph = isset( $iph ) ? json_decode($iph,TRUE) : NULL;
		
		if ( isset( $iph ) )
		{
			$ips = $this->ip_do_update( $iph );
		}
		else
		{
			$ips[] = array( 'ip' => $this->input->ip_address(), 'time' => time() );
		}
		
		return json_encode( $ips );
	}
	
	public function query()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');
		
		$res = NULL;
		
		if(isset($api_key))
		{
			$res = $this->db->get_row("SELECT com_id, com_df_id, com_rec_id, com_ip_history FROM company WHERE com_apikey = ?", ARRAY_A, array( $api_key ) );
		}

		if(isset($res))
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::QUERY, $res['com_id'] );
			
			/**receiver tick**/
			$this->db->query("INSERT INTO receiver_ticks (rt_company_id) VALUES (?)", array($res['com_id']) );
			
			$cur_time = floor( time() / RECEIVER_TICKS_PERIOD_TIME ) * RECEIVER_TICKS_PERIOD_TIME;
			
			$rtp_id = $this->db->get_var( 'SELECT rtp_id FROM receiver_ticks_period WHERE rtp_com_id = ? AND rtp_from_time = ? LIMIT 1', array( $res['com_id'], $cur_time ) );
			
			if ( isset( $rtp_id ) )
			{
				$this->db->query( 'UPDATE receiver_ticks_period SET rtp_ticks_count=rtp_ticks_count+1 WHERE rtp_id = ?', array( $rtp_id ) );
			}
			else
			{
				$this->db->query( 'INSERT INTO receiver_ticks_period ( rtp_com_id, rtp_from_time, rtp_ticks_count ) VALUES ( ?, ?, 1 )', array( $res['com_id'], $cur_time ) );
			}
			
			/**incoming data -------------------------------- **/
			$postdata = get_post('data');
			
			if($postdata)
			{
				$data = json_decode( $postdata );

				if( isset( $data ) && $data->msg_log )
				{
					foreach($data->msg_log as $entry)
					{
						$datetime = str_replace(" ","+",trim($entry->date)); //fixes a datetime issue in mono when timezone is UTC (00:00)
						
						$this->db->query("INSERT INTO receiver_console_log (rcl_company_id, rcl_time, rcl_msg) VALUES (?,?,?)", array($res['com_id'],$datetime,$entry->msg));
					}
				}
			}
			
			// keey up to date the ip client address
			$iph = $this->ip_history_update( isset( $res['com_ip_history'] ) ? $res['com_ip_history'] : NULL );
			
			$this->db->set_qd( array( $this->input->ip_address(), $iph, $res['com_id'] ) );
			$this->db->query( 'UPDATE company SET com_ip = ?, com_ip_history = ? WHERE com_id = ?' );

			/**response -------------------------------- **/
			$actions = null;

			$data = Transcoder::zencode($actions);
			$signature = FrameUtils::calculate_signature($data);

			$result = array(
				'signature' => $signature,
				'data' => $data
			);
		}
		else
		{
			$result['error'] = 'Unauthorized api key'; 
		}
		
		echo json_encode($result);
		
		http_request_redirect_all();
	}
	
	public function receiver_commands()
	{
		http_header_json_no_cache();

		$api_key = get_var('api_key');
		
		$res = NULL;
		
		if( isset( $api_key ) )
		{
			$res = $this->db->get_row("SELECT com_id FROM company WHERE com_apikey = ?", ARRAY_A, array( $api_key ) );
		}

		if(isset($res))
		{
			$this->load->model('ReceiverCommand_model');
			
			$cmds = $this->ReceiverCommand_model->get_pending_send( $res['com_id'] );
			
			$result = array(
				'result' => 'success',
				'count' => count($cmds),
				'cmds' => $cmds
			);
			
			$this->ReceiverCommand_model->set_sent( $cmds );
		}
		else
		{
			$result['error'] = 'Unauthorized api key'; 
		}
		
		echo json_encode($result);
		
		http_request_redirect_all();
	}
	
	public function update()
	{
		http_header_json_no_cache();
		
		$db			= db_get();
		$json		= array();
		$commod		= load_model( 'Company_model' );
		$softmod	= load_model( 'Software_model' );
		
		$api_key = get_var( 'api_key' );

		if ( null != $api_key && ( $company = $commod->get_from_apikey( $api_key ) ) && isset( $company ) )
		{
			$update = $softmod->soft_update_get_last( $company->com_id );

			if ( isset( $update ) )
			{
				$json['software'] = array(	'version'	=> (string)$update->sr_id,
									'file'		=> 'update.zip.' . $update->sr_hash,
									'checksum'	=> $update->sr_hash,
									'size'		=> (string)$update->sr_size
								);
			}
			else
			{
				$json['software'] = array( 'error' => array( 'msg' => 'no updates found' ) );
			}
			
			$config	= $softmod->soft_config_get_last( $company->com_id );
			
			if ( isset( $config ) )
			{
				$json['config'] = array(	'version'	=> (string)$config->sc_id,
									'file'		=> 'config.ini.' . $config->sc_hash,
									'checksum'	=> $config->sc_hash,
									'size'		=> (string)$config->sc_size
								);
			}
			else
			{
				$json['config'] = array( 'error' => array( 'msg' => 'no config found' ) );
			}
			
			$script	= $softmod->soft_script_get_last( $company->com_id );
			
			if ( isset( $script ) )
			{
				$json['script'] = array(	'version'	=> (string)$config->ss_id,
									'file'		=> 'script.zip.' . $config->ss_hash,
									'checksum'	=> $config->ss_hash,
									'size'		=> (string)$config->ss_size
								);
			}
			else
			{
				$json['script'] = array( 'error' => array( 'msg' => 'no config found' ) );
			}
			
			$json_config	= $softmod->soft_json_config_get_last( $company->com_id );
			
			if ( isset( $json_config ) )
			{
				$json['json_config'] = array(	'version'	=> (string)$json_config->sjc_id,
									'file'		=> 'domo_config.json.' . $json_config->sjc_hash,
									'checksum'	=> $json_config->sjc_hash,
									'size'		=> (string)$json_config->sjc_size
								);
			}
			else
			{
				$json['json_config'] = array( 'error' => array( 'msg' => 'no config found' ) );
			}
		}
		else
		{
			$json['error'] = array( 'msg' => 'invalid api_key' );
		}
		
		echo json_enc( $json );
	}
	
	public function pendingsms()
	{
		http_header_json_no_cache();

		$companies	= get_post( 'companies' );
		$sec		= get_post( 'sec' );
		$response	= array();
		$myhash		= hash( 'md5', 'domo_sendsms_rand_' . $companies );

		if ( null != $companies && null != $sec && $myhash == strtolower( $sec ) )
		{
			$smsmod		= load_model( 'Sms_model' );
			
			// Remove already sent SMSs
			$smsmod->set_sent( get_post( 'sended' ) );

			// Remove failed sent SMSs
			$smsmod->set_failed( get_post( 'failed' ) );
			
			// Send pending SMSs
			$res		= $smsmod->get_pending_from_companies( $companies );
			
			$response['sms'] = array();
			
			if ( null != $res )
			{
				foreach ( $res as $row )
				{
					$response['sms'][]	= array( 'sms_id' => $row->sms_id, 'sms_txt' => $row->sms_txt, 'sms_com_id' => $row->sms_com_id, 'sms_destination' => $row->sms_destination );
				}
			}
		}
		else
		{
			$response['error']		= 'Unauthorized';
		}

		echo json_encode($response);
	}
	
	public function report()
	{
		http_header_json_no_cache();
		
		$ok = false;
		
		$this->load->model('Company_model');
		
		$api_key = get_var( 'api_key' );
		
		if ( null != $api_key && ( $company = $this->Company_model->get_from_apikey( $api_key ) ) && isset( $company ) )
		{
			$report = get_post('report');
			
			$valid_json = json_decode( $report );
			
			if ( isset( $report ) && isset( $valid_json ) )
			{
				$this->Company_model->update_report( $company->com_id, $report );
				
				$ok = true;
			}
		}
		
		echo json_enc( array( 'resp' => $ok ) );
	}
	
	public function request()
	{
		http_header_json_no_cache();

		$api_key	= get_var('api_key');
		$cmd		= get_var('cmd');
		$res		= NULL;
		$hardmod	= load_model( 'Hardware_model' );
		$commod		= load_model( 'Company_model' );

		if( isset( $api_key ) )
		{
			$res = $commod->get_from_apikey( $api_key, ARRAY_A );
		}

		if( isset($res) )
		{
			switch ( $cmd )
			{
				case 'get_macs':
				{
					$result['ack']	= 'OK';
					$result['data'] = $hardmod->get_company_macs( $res['com_id'] );
					break;
				}
				case 'get_macs_and_codes':
				{
					$result['ack']	= 'OK';
					$result['data'] = $hardmod->get_company_macs_and_code( $res['com_id'] );
					break;
				}
				case 'get_signal_null_macs':
				{
					$result['ack']	= 'OK';
					$result['data'] = $hardmod->get_company_macs_null_signal( $res['com_id'] );
					break;
				}
				case 'get_ssh_port':
				{
					echo (string)$commod->get_ssh_port( $res['com_id'] );
					exit;
				}
				default:
				{
					$result['error'] = 'Unknown Command'; 
				}
			}
		}
		else
		{
			$result['error'] = 'Unauthorized api key'; 
		}

		echo(json_encode($result));
	}
	
	public function validatekey()
	{
		http_header_json_no_cache();

		$api_key	= get_var('api_key');
		$res		= NULL;
		$commod		= load_model( 'Company_model' );

		if( isset( $api_key ) )
		{
			$res = $commod->get_from_apikey( $api_key );
		}

		if( isset($res) )
		{
			$result['ok'] = true;
			$result['company'] = $res->com_name;
		}
		else
		{
			$result['ok'] = false;
		}
		
		echo(json_encode($result));
	}
	
	protected function get_icon_bg_color( $col )
	{
		return array( intval( $col[0] / 4 ), intval( $col[1] / 4 ), intval( $col[2] / 4 ) );
	}
	
	protected function get_icon_color( $def )
	{
		$col	= get_var( 'color' );
		
		if ( NULL == $col )
		{
			return $def;
		}
		
		return hex2rgb( $col );
	}
	
	public function icon()
	{
		require_once( LIBSPATH . 'pngpainter.php' );
		
		define( 'PIN_PATH'					, ROOTPATH . 'assets/pin/' );
		define( 'PAINTER_CACHE_FOLDER_PATH'	, ROOTPATH . 'assets/pins/' );
		define( 'PAINTER_CACHE_URL_PATH'	, base_url( '/assets/pins/' ) );

		$icon	= get_var( 'icon' );
		$state	= strtolower( get_var( 'state' ) );
		$fname	= PIN_PATH.$icon.'.png';

		$opacity = 1.0;
		$def_opacity = 0.8;
		$def_low_opacity = 0.5;
		
		if ( $icon == 'NUCLEATOR' )
		{
			$def_opacity = 1.0;
			$def_low_opacity = 1.0;
		}

		if ( !isset($state) )
		{
			$state = "excellent";
		}

		if ( get_var( 'color' ) != null && get_var('color') != 'undefined' && ( $state == 'dead' || $state == 'low' || $state == 'good' || $state == 'excellent' || $state == 'fake' || $state == 'fucsia' ) )
		{
			$state_color		= $this->get_icon_color( array( 255, 0, 0 ) );
			$state_bg_color		= $this->get_icon_bg_color( $state_color );
			$opacity			= $def_opacity;
		}
		else if($state == 'radar')
		{
			$state_bg_color		= array( 0, 0, 0 );
			$state_color		= array( 0, 40, 220 );
			$opacity			= $def_opacity;
		}
		else if($state == 'dead')
		{
			$state_bg_color		= array( 64, 0, 0 );
			$state_color		= array( 255, 0, 0 );
			$opacity			= 1.0;
		}
		else if($state == 'low')
		{
			$state_bg_color		= array( 64, 32, 0 );
			$state_color		= array( 255, 128, 0 );
			$opacity			= 1.0;
		}
		else if($state == 'good')
		{
			$state_bg_color		= array( 64, 64, 0 );
			$state_color		= array( 255, 255, 0 );
			$opacity			= 1.0;
		}
		else if ($state == 'excellent')
		{
			$state_bg_color		= array( 0, 64, 0 );
			$state_color		= array( 0, 255, 0 );
			$opacity			= $def_low_opacity;
		}
		else if ($state == 'fake' || $state == 'blue')
		{
			$state_bg_color		= array( 0, 0, 64 );
			$state_color		= array( 0, 0, 255 );
			$opacity			= $def_low_opacity;
		}
		else if ($state == 'fucsia')
		{
			$state_bg_color		= array( 64, 0, 64 );
			$state_color		= array( 255, 0, 255 );
			$opacity			= $def_low_opacity;
		}
		else if ($state == 'noreport')
		{
			
			$state_color		= $this->get_icon_color( array( 255, 0, 0 ) );
			$state_bg_color		= $this->get_icon_bg_color( $state_color );
			$opacity			= $def_opacity;
		}
		else if ($state == 'moving')
		{
			$state_color		= $this->get_icon_color( array( 0, 204, 204 ) );
			$state_bg_color		= $this->get_icon_bg_color( $state_color );
			$opacity			= $def_opacity;
		}
		else if ($state == 'stopped')
		{
			$state_color		= $this->get_icon_color( array( 255, 102, 153 ) );
			$state_bg_color		= $this->get_icon_bg_color( $state_color );
			$opacity			= $def_opacity;
		}
		else if ($state == 'nogps')
		{
			$state_color		= $this->get_icon_color( array( 255, 243, 0 ) );
			$state_bg_color		= $this->get_icon_bg_color( $state_color );
			$opacity			= $def_opacity;
		}

		// Test image.
		$fn = png_painter_apply( $fname, $state_bg_color, $state_color, PAINTER_CACHE_FOLDER_PATH, PAINTER_CACHE_URL_PATH, true, $opacity );

		// Getting headers sent by the client.
		$headers = apache_request_headers(); 

		// Checking if the client is validating his cache and if it is current.
		if (isset($headers['If-Modified-Since']) && (strtotime($headers['If-Modified-Since']) == filemtime($fn)))
		{
			// Client's cache IS current, so we just respond '304 Not Modified'.
			header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime($fn)).' GMT', true, 304);
		}
		else
		{
			// Image not cached or cache outdated, we respond '200 OK' and output the image.
			header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime($fn)).' GMT', true, 200);
			header('Content-Length: '.filesize($fn));
			header('Content-Type: image/png');
			print file_get_contents($fn);
		}
	}
	
	public function radar_event()
	{
		$this->load->model('Radar_model');
		$this->load->model('RadarEvent_model');
		
		$post = $this->input->post();
		
		$resp['status'] = 'error';
		
		if ( !isset( $post['serial'] ) )
		{
			$resp['message'] = 'field "serial" required';
		}
		else if ( !isset( $post['country_id'] ) )
		{
			$resp['message'] = 'field "country_id" required';
		}
		else if ( !isset( $post['timestamp'] ) )
		{
			$resp['message'] = 'field "timestamp" required';
		}
		else if ( !isset( $post['max_speed'] ) )
		{
			$resp['message'] = 'field "max_speed" required';
		}
		else if ( !isset( $post['speed'] ) )
		{
			$resp['message'] = 'field "speed" required';
		}
		else if ( !isset( $post['type'] ) )
		{
			$resp['message'] = 'field "type" required';
		}
		else if ( $this->Radar_model->exists_serial( $post['serial'] ) )
		{
			if ( !$this->RadarEvent_model->exists( $post['serial'], $post['timestamp'] ) )
			{
				$this->load->library( 'UploadHandler', array( 
					'script_url' => base_url('/api/radar_event/'),
					'upload_dir' => FINESPATH,
					'upload_url' => base_url('/assets/tickets') . '/',
					'accept_file_types' => '/\.*$/i',
					'image_versions' => array( '' => array(),
						'medium' => array(
							'max_width' => 400,
							'max_height' => 200
						),
						'thumbnail' => array(
							'max_width' => 200,
							'max_height' => 100
						)
					)
				) );
				
				$resp = $this->uploadhandler->post(false);
				
				if ( isset( $resp['files'][0] ) && file_exists( FINESPATH . $resp['files'][0]->name ) )
				{
					$retry		= FALSE;
					$filename	= '';
					$ext		= '.jpg';
					
					do
					{
						$retry		= FALSE;
						$newname	= rand_string(64);
						$filename	= $newname . $ext;
						$oldfile	= FINESPATH . $resp['files'][0]->name;
						$newfile	= FINESPATH . $filename;
						
						$type		= $resp['files'][0]->type;
						
						if ( !file_exists( $newfile ) )
						{
							rename( $oldfile, $newfile );
							
							$oldmedfile	= FINESPATH . 'medium/' . $resp['files'][0]->name;
							$oldthumbfile	= FINESPATH . 'thumbnail/' . $resp['files'][0]->name;
							
							$resp['files'][0]->name	= $filename;
							$resp['files'][0]->url	= rawurldecode( base_url( '/assets/tickets/' ) . '/' . $filename );
							
							$newmedfile	= FINESPATH . 'medium/' . $filename;
							@rename( $oldmedfile, $newmedfile );
							$resp['files'][0]->mediumUrl	= rawurldecode( base_url( '/assets/tickets/medium/' ) . '/' . $filename );
							
							$newthumbfile	= FINESPATH . 'thumbnail/' . $filename;
							@rename( $oldthumbfile, $newthumbfile );
							$resp['files'][0]->thumbnailUrl	= rawurldecode( base_url( '/assets/tickets/thumbnail/' ) . '/' . $filename );
						}
						else
						{
							$retry = TRUE;
						}
					}
					while ( $retry );
					
					$id = $this->RadarEvent_model->add( $post['serial'], $post['country_id'], $filename, $post['timestamp'], $post['max_speed'], $post['speed'], $post['type'] );
					
					if ( intval( $post['type'] ) == RadarEventType::INFRACTION )
					{
						$this->load->model('GlobalEvent_model');
						$this->load->model('Radar_model');
						
						$radar = $this->Radar_model->get_from_serial( $post['serial'] );
						
						if ( isset( $radar ) )
						{
							$this->GlobalEvent_model->add( GlobalEventType::INFRACTION, $id, 0, $radar['rd_id'], $radar['rd_serial'], 0, $radar['rd_company'], $post['timestamp'], 'Exceso de Velocidad: ' . $post['speed'] . ' km/h', 0 );
						}
					}
					
					$resp['status'] = 'success';
					$resp['message'] = $id;
				}
				else
				{
					$resp['message'] = "upload failed";
				}
			}
			else
			{
				$resp['message'] = "radar event already exists";
			}
		}
		else
		{
			$resp['message'] = "radar " . $post['serial'] . " not found";
		}
		
		echo json_encode($resp);
	}
	
	public function senddtrans()
	{
		http_header_json_no_cache();
		
		$access_token = get_var('access_token');
		$api_key = get_var('api_key');
		
		if( isset($api_key) )
		{
			$res = $this->db->get_row( 'SELECT com_id, com_df_id, com_rec_id, com_hw_report_freq FROM company WHERE com_apikey = ?', ARRAY_A, array( $api_key ) );
		}

		if( isset( $res ) )
		{
			$GLOBALS['company'] = $res;
			
			$data = FrameUtils::get_posted_frames();
			
			if($data == null)
			{
				$response['ack'] = false;
				$response['signature'] = '';
				$response['msg'] = 'no data received';
			}
			else
			{
				$calc_sign = FrameUtils::calculate_signature($data['frames']);
				
				$response['ack'] = $calc_sign === $data['signature'];
				$response['signature'] = $data['signature'];
				
				if( $calc_sign === $data['signature'] )
				{
					$this->load->model('DTransFrames_model');
					
					$frames = Transcoder::jsondecode($data['frames']);
					
					if ( isset( $frames ) && !empty( $frames ) )
					{
						foreach ( $frames as $f )
						{
							$this->DTransFrames_model->add( $res['com_id'], $f->serial, $f->timestamp, $f->frame );
						}
					}
					
					$resp['status'] = 'success';
					
					$ndata = Transcoder::zencode($resp);
					$signature = FrameUtils::calculate_signature($ndata);
					
					$response['signature_data'] = $signature;
					$response['data'] = $ndata;
				}
			}
		}
		else
		{
			$response['error'] = 'Unauthorized api key';
		}
		
		echo json_encode($response);
		
		http_request_redirect_all();
	}
	
	public function radar_test()
	{
		$this->load->model('Company_model');
		
		$api_key = get_var( 'api_key' );
		
		if( isset( $api_key ) )
		{
			$res = $this->Company_model->get_from_apikey( $api_key, ARRAY_A );
		}
		
		if( isset( $res ) )
		{
			$serial = get_post( 'serial' );
			
			if ( isset( $serial ) )
			{
				$this->load->model('Radar_model');
				
				$radar = $this->Radar_model->get_from_serial( $serial );
				
				if ( isset( $radar ) )
				{
					$this->load->model('RadarTest_model');
					
					$this->RadarTest_model->add_from_serial( $serial );
					
					$config = array(
						"photo_timeout_ms" => $radar['rd_photo_timeout_ms'],
						"photo_count" => $radar['rd_photo_count'],
						"photo_index" => $radar['rd_photo_index'],
						"photo_speed_limit" => $radar['rd_trigger_speed'],
						"photo_speed_max" => $radar['rd_speed_ignore'],
						"country_id" => $radar['rd_country_id'],
						"radar_name" => $radar['rd_name'],
						"country_name" => $radar['rd_urbanization_address'],
						"host_address" => $radar['rd_host_addr'],
						"api_key" => ( isset( $radar['rd_api_key'] ) && !empty( $radar['rd_api_key'] ) ) ? $radar['rd_api_key'] : $api_key
					);
					
					echo json_encode( array( 'result' => 'OK', 'config' => $config ) );
				}
				else
				{
					http_response_code(404);
					echo json_encode( array( 'result' => 'SERIAL_NOT_FOUNT' ) );
				}
			}
			else
			{
				http_response_code(404);
				echo json_encode( array( 'result' => 'SERIAL_EXPECTED' ) );
			}
		}
		else
		{
			http_response_code(401);
			echo json_encode( array( 'result' => 'UNAUTHORIZED_API_KEY' ) );
		}
	}
	
	public function radar_log()
	{
		$this->load->model('Company_model');
		
		$api_key = get_var( 'api_key' );
		
		if( isset( $api_key ) )
		{
			$res = $this->Company_model->get_from_apikey( $api_key, ARRAY_A );
		}
		
		if( isset( $res ) )
		{
			$this->load->model('RadarLog_model');
			
			$body = get_json_body();
			
			if ( isset( $body ) )
			{
				$serial = get_var('serial');
				
				$this->RadarLog_model->add_batch( $res['com_id'], $serial, $body );
			}
			
			echo json_encode( array( 'result' => 'OK' ) );
		}
		else
		{
			http_response_code(401);
			echo json_encode( array( 'result' => 'UNAUTHORIZED_API_KEY' ) );
		}
	}
	
	public function update_nucleation_data()
	{
		$nl = "<br/>\n";
		$res = NULL;
		$api_key = get_var( 'api_key' );
		
		$this->load->model('Company_model');
		
		if( isset( $api_key ) )
		{
			$res = $this->Company_model->get_from_apikey( $api_key, ARRAY_A );
		}
		
		if( isset( $res ) )
		{
			load_model('RequestTracker_model')->add( RequestTrackerType::NUCLEATIONDATA, $res['com_id'] );
			
			$data = get_post( 'data' );
			$hws = json_decode( $data, TRUE );
			
			$this->load->model('Hardware_model');
			$this->load->model('HardwareGroup_model');
			
			$cores = array();
			$city7 = array();
			
			if ( isset( $hws ) && !empty( $hws ) )
			{
				foreach ( $hws as $hw )
				{
					if ( 0 != $hw['core'] )
					{
						$cores[ $hw['core'] ] = $hw['core'];
						
						$hwg_id = $this->HardwareGroup_model->get_by_serial( $hw['core'], $res['com_id'] );
						
						$hw_core = $this->Hardware_model->get_from_serial( $hw['core'], ARRAY_A );
						
						if ( isset( $hw_core ) )
						{
							$name = "Nucleados en " . dechex( $hw_core['hw_code'] );
						
							if ( !isset( $hwg_id ) )
							{
								$hwg_id = $this->HardwareGroup_model->add_with_serial( $name, $res['com_id'], $hw['core'] );
							}
							else
							{
								$this->HardwareGroup_model->update( $name, $hwg_id );
							}
							
							if ( isset( $hwg_id ) )
							{
								$hw_link = $this->Hardware_model->get_from_serial( $hw['hw'], ARRAY_A );
								
								if ( isset( $hw_link ) )
								{
									if ( isset( $hw_link['hw_is_city7'] ) && $hw_link['hw_is_city7'] == 1 )
									{
										$city7[ $hw['hw'] ] = $hw['hw'];
									}
									
									$this->HardwareGroup_model->unlink_from_cores( $hw_link['hw_id'] );
									$this->HardwareGroup_model->link( $hwg_id, $hw_link['hw_id'] );
								}
								else
								{
									$err = 'HW with MAC: ' . dechex( $hw['hw'] ) . ' not found';
									//log_error( $err ); echo $err . $nl;
								}
							}
							else
							{
								$err = 'Nucleator with MAC: ' . dechex( $hw_core['hw_code'] ) . ' failed to create.';
								log_error( $err ); echo $err . $nl;
							}
						}
						else
						{
							$fake_serial = 0xFFFFFFFE;
							$name = "Sin Nuclear por Error";
							$hwg_id	= $this->HardwareGroup_model->get_by_serial( $fake_serial, $res['com_id'] );
							
							if ( !isset( $hwg_id ) )
							{
								$hwg_id	= $this->HardwareGroup_model->add_with_serial( $name, $res['com_id'], $fake_serial );
							}
							
							if ( isset( $hwg_id ) )
							{
								$hw_link = $this->Hardware_model->get_from_serial( $hw['hw'], ARRAY_A );
								
								if ( isset( $hw_link ) )
								{
									if ( isset( $hw_link['hw_is_city7'] ) && $hw_link['hw_is_city7'] == 1 )
									{
										$city7[ $hw['hw'] ] = $hw['hw'];
									}
									
									$this->HardwareGroup_model->unlink_from_cores( $hw_link['hw_id'] );
									$this->HardwareGroup_model->link( $hwg_id, $hw_link['hw_id'] );
								}
								else
								{
									$err = 'HW with MAC: ' . dechex( $hw['hw'] ) . ' not found';
									//log_error( $err ); echo $err . $nl;
								}
							}
							else
							{
								$err = 'Nucleator ' . $name . ' failed to create.';
								log_error( $err ); echo $err . $nl;
							}
						}
					}
					else
					{
						$fake_serial = 0xFFFFFFFF;
						$name	= "No Nucleados";
						$hwg_id	= $this->HardwareGroup_model->get_by_serial( $fake_serial, $res['com_id'] );
						
						if ( !isset( $hwg_id ) )
						{
							$hwg_id	= $this->HardwareGroup_model->add_with_serial( $name, $res['com_id'], $fake_serial );
						}
						
						if ( isset( $hwg_id ) )
						{
							$hw_link = $this->Hardware_model->get_from_serial( $hw['hw'], ARRAY_A );
							
							if ( isset( $hw_link ) )
							{
								if ( isset( $hw_link['hw_is_city7'] ) && $hw_link['hw_is_city7'] == 1 )
								{
									$city7[ $hw['hw'] ] = $hw['hw'];
								}
								
								$this->HardwareGroup_model->unlink_from_cores( $hw_link['hw_id'] );
								$this->HardwareGroup_model->link( $hwg_id, $hw_link['hw_id'] );
							}
							else
							{
								$err = 'HW with MAC: ' . dechex( $hw['hw'] ) . ' not found';
								//log_error( $err ); echo $err . $nl;
							}
						}
						else
						{
							$err = 'Nucleator ' . $name . ' failed to create.';
							log_error( $err ); echo $err . $nl;
						}
					}
				}
				
				if ( !empty( $cores ) )
				{
					$fake_serial = 0xFFFFFFFD;
					$name	= "Nucleadores";
					$hwg_id	= $this->HardwareGroup_model->get_by_serial( $fake_serial, $res['com_id'] );
					
					if ( !isset( $hwg_id ) )
					{
						$hwg_id	= $this->HardwareGroup_model->add_with_serial( $name, $res['com_id'], $fake_serial );
					}
					
					if ( isset( $hwg_id ) )
					{
						$this->HardwareGroup_model->unlink_all_from_group( $hwg_id );
						
						foreach ( $cores as $core_mac )
						{
							$hw_link = $this->Hardware_model->get_from_serial( $core_mac, ARRAY_A );
							
							if ( isset( $hw_link ) )
							{
								$this->HardwareGroup_model->link( $hwg_id, $hw_link['hw_id'] );
							}
						}
					}
					else
					{
						$err = 'Nucleator ' . $name . ' failed to create.';
						log_error( $err ); echo $err . $nl;
					}
				}
				
				if ( !empty( $city7 ) )
				{
					$fake_serial = 0xFFFFFFFC;
					$name	= "Citymesh v7";
					$hwg_id	= $this->HardwareGroup_model->get_by_serial( $fake_serial, $res['com_id'] );
					
					if ( !isset( $hwg_id ) )
					{
						$hwg_id	= $this->HardwareGroup_model->add_with_serial( $name, $res['com_id'], $fake_serial );
					}
					
					if ( isset( $hwg_id ) )
					{
						$this->HardwareGroup_model->unlink_all_from_group( $hwg_id );
						
						foreach ( $city7 as $city7_mac )
						{
							$hw_link = $this->Hardware_model->get_from_serial( $city7_mac, ARRAY_A );
							
							if ( isset( $hw_link ) )
							{
								$this->HardwareGroup_model->link( $hwg_id, $hw_link['hw_id'] );
							}
						}
					}
					else
					{
						$err = 'Nucleator ' . $name . ' failed to create.';
						log_error( $err ); echo $err . $nl;
					}
				}
			}
			else
			{
				$err = 'No data in update_nucleation_data for api_key ' . $api_key;
				log_error( $err ); echo $err . $nl;
			}
		}
		else
		{
			echo 'Unauthorized api key' . $nl;
		}
	}
	
	public function write_geotrace_log()
	{
		$msg = get_post('data');
			
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) && isset( $msg ) )
		{
			$this->load->model( 'ReceiverGeotraceLog_model' );
			
			$this->ReceiverGeotraceLog_model->add( $msg );
		}
	}
}
