<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = 'main';
$route['404_override'] = '';

$route['recover/(:any)'] = 'main/recover/$1/$2';
$route['dshield/hw/all'] = 'hw/all';
$route['dshield/geotrace/all'] = 'geotrace/all';
$route['dshield/keychain/all'] = 'keychain/all';
$route['dshield/radars/all'] = 'radars/show';
$route['dshield/userrfid/all'] = 'userrfid/all';
$route['dshield/user'] = 'user';
$route['dshield/hw/view/(:any)'] = 'hw/view/$1';
$route['dshield/geotrace/view/(:any)'] = 'geotrace/view/$1';
$route['dshield/radars/events'] = 'radars/events';
$route['dshield/radars/events_tests'] = 'radars/events_tests';
$route['dshield/person/add'] = 'person/add';
$route['dshield/person/add/(:any)'] = 'person/add/$1';
$route['dshield/person/all'] = 'person/all';
$route['dshield/person/offside'] = 'person/offside';
$route['dshield/rfid/all'] = 'rfid/all';
$route['dshield/insurance/all'] = 'insurance/all';
$route['dshield/guest'] = 'guest';
$route['dshield/guest/all'] = 'guest/all';
$route['dshield/guest/event_visits/(:any)'] = 'guest/event_visits/$1';
$route['dshield/guest/event_visits_modal/(:any)'] = 'guest/event_visits_modal/$1';
$route['dshield/rfid/citymesh_show'] = 'rfid/citymesh_show';
$route['dshield/rfid/jobs'] = 'rfid/jobs';
$route['dshield/rfid/access_graph'] = 'rfid/access_graph';
$route['dshield/radars/validation'] = 'radars/validation';
$route['dshield/insurance/is_expiring_soon'] = 'insurance/is_expiring_soon';
$route['dshield/insurance/expiring_soon'] = 'insurance/expiring_soon';
$route['domo/version'] = 'main/version';
$route['dtrans/api/query'] = 'dtrans_api/query';

/* End of file routes.php */
/* Location: ./application/config/routes.php */