<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define('FILE_READ_MODE', 0644);
define('FILE_WRITE_MODE', 0666);
define('DIR_READ_MODE', 0755);
define('DIR_WRITE_MODE', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define('FOPEN_READ',							'rb');
define('FOPEN_READ_WRITE',						'r+b');
define('FOPEN_WRITE_CREATE_DESTRUCTIVE',		'wb'); // truncates existing file data, use with care
define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE',	'w+b'); // truncates existing file data, use with care
define('FOPEN_WRITE_CREATE',					'ab');
define('FOPEN_READ_WRITE_CREATE',				'a+b');
define('FOPEN_WRITE_CREATE_STRICT',				'xb');
define('FOPEN_READ_WRITE_CREATE_STRICT',		'x+b');

isset( $_SERVER['HTTPS'] ) ? define('PAGE_PROTOCOL', 'https://' ) : define('PAGE_PROTOCOL', 'http://' );
define( 'PAGE_HOST'		, isset( $_SERVER['HTTP_HOST'] ) ? $_SERVER['HTTP_HOST'] : '' );
define( 'ROOTPATH'		, dirname( realpath( __FILE__ ) ) . '/../../'  );
define( 'TMPPATH'		, ROOTPATH . 'tmp/' );
define( 'FINESPATH'		, ROOTPATH . 'assets/tickets/' );
define( 'RADARSLOGOSPATH', ROOTPATH . 'assets/radars_logos/' );
define( 'PHOTOSPATH'	, ROOTPATH . 'assets/photos/' );
define( 'IMGPATH'		, ROOTPATH . 'assets/images/' );
define( 'LIBSPATH'		, APPPATH . 'libraries/' );
define( 'FRAMES_PATH'	, LIBSPATH . 'frames/' );
define( 'MODEL_PATH'	, APPPATH . 'models/' );
define( 'SERVER_NAME'	, php_uname( 'n' ) );
define( 'CSV_SEPARATOR'	, ',' );
define( 'DEBUG_SERVER'	, SERVER_NAME != 'li531-54' && SERVER_NAME != 'deitres' && SERVER_NAME != 'arenasdelsur' && SERVER_NAME != 'bsvr' );
define( 'MASTER_SERVER'	, SERVER_NAME == 'li531-54' );
define( 'DEBUG'			, DEBUG_SERVER );
define( 'LIGHTWEIGHT_RESULTS', 'spartan' == SERVER_NAME || 'prognosys' == SERVER_NAME );
define( 'TESTS_LOG_TIMEOUT_SECONDS', 3600 * 96 );				# 3600 seconds = 1 hour
define( 'USE_POSTGRES', TRUE );
define( 'AVL_CMD_TIMEOUT',  30 );
define( 'RECEIVER_TICKS_PERIOD_TIME', 300 );
define( 'RECEIVER_TICKS_PERIOD_TIMEOUT_SECONDS', 3600 * 24 * 30 );
define( 'MAINTENANCE_MODE', FALSE );
define( 'MAINTENANCE_ALLOW_API', FALSE );
define( 'MAINTENANCE_ALLOW_CRON', FALSE );
define( 'DOMO_GOOGLE_MAPS_API_KEY', MASTER_SERVER ? 'AIzaSyByNKL7KsRIKM1dVEyt4uJGdsn9CdoAnNI' : '' );
define( 'OFFLINE_SERVER', 'bsvr' == SERVER_NAME );
define( 'BAD_PERFORMANE_ALERT', FALSE );

if ( LIGHTWEIGHT_RESULTS )
{
	//define( 'USE_REMOTE_DB', TRUE );
}

if ( SERVER_NAME == 'li531-54' )
{
	define( 'FORCE_HTTPS',  TRUE );
}

/** User level modes */
define( 'USER_TYPE_USER'		, 1 );			// Simple user
define( 'USER_TYPE_CPNY_RO'		, 1.9 );		// Company user READ-ONLY
define( 'USER_TYPE_CPNY'		, 2 );			// Company user
define( 'USER_TYPE_CPNY_RW'		, 2.1 );		// Company user READ-WRITE
define( 'USER_TYPE_CPNY_META'	, 2.5 );		// Big Company
define( 'USER_TYPE_GOD' 		, 3 );			// Deitres user
define( 'USER_TYPE_HW'			, 4 );			// this is a simple hack, don't use it if you don't know what it means

/* End of file constants.php */
/* Location: ./application/config/constants.php */