/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ir.server;

import android.app.ActivityManager;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import com.android.tools.ir.server.AppInfo;
import com.android.tools.ir.server.Server;

public final class InstantRunContentProvider
extends ContentProvider {
    public boolean onCreate() {
        if (this.isMainProcess()) {
            Log.i((String)"InstantRun", (String)"starting instant run server: is main process");
            Server.create(this.getContext());
        } else {
            Log.i((String)"InstantRun", (String)"not starting instant run server: not main process");
        }
        return true;
    }

    private boolean isMainProcess() {
        boolean isMainProcess = false;
        if (AppInfo.applicationId != null) {
            boolean foundPackage = false;
            int pid = Process.myPid();
            ActivityManager manager = (ActivityManager)this.getContext().getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (!AppInfo.applicationId.equals(processInfo.processName)) continue;
                foundPackage = true;
                if (processInfo.pid != pid) continue;
                isMainProcess = true;
                break;
            }
            if (!isMainProcess && !foundPackage) {
                isMainProcess = true;
                Log.w((String)"InstantRun", (String)"considering this process main process:no process with this package found?!");
            }
        }
        return isMainProcess;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("not a real content provider");
    }

    public String getType(Uri uri) {
        throw new UnsupportedOperationException("not a real content provider");
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("not a real content provider");
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("not a real content provider");
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("not a real content provider");
    }
}

