
function file_upload_init( fu /* file upload DOM element */, url /** request url */, done_cb /** on upload done callback */, start_cb /* on start callback */, progress_el /** progressbar element */ )
{
	if ( 'undefined' == typeof progress_el )
	{
		progress_el = $('#progress');
	}
	
	if ( fu.length > 0 )
	{
		fu.fileupload({
			url: url,
			dataType: 'json',
			start:function(e)
			{
				if ( 'undefined' != typeof progress_el )
				{
					progress_el.show();
					
					var progress_text = progress_el.find('.progress-text');
					
					if ( progress_text.length )
					{
						progress_text.text( '0%' );
					}
				}
				
				if ( 'undefined' != typeof start_cb )
				{
					start_cb(e);
				}
			},
			done: function (e, data)
			{
				done_cb( e, data );
			},
			progressall: function (e, data)
			{
				if ( 'undefined' != typeof progress_el )
				{
					var progress = parseInt( data.loaded / data.total * 100, 10 );
					
					progress_el.find('.progress-bar').css( 'width', progress + '%' );
					
					var progress_text = progress_el.find('.progress-text');
					
					if ( progress_text.length )
					{
						progress_text.text( progress + '%' );
					}
					
					if ( data.loaded == data.total )
					{
						progress_el.hide();
					}
					else
					{
						progress_el.show();
					}
				}
			}
		}).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
	}
}
 
