<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require(APPPATH.'libraries/REST_Controller.php');
require(APPPATH.'libraries/JWT.php');
use \Firebase\JWT\JWT;

class App extends REST_Controller
{
	var $sql;
	var $data;

	function __construct()
	{
		parent::__construct();

		$this->load->model('admin/profesionales_model', 'profesionales', TRUE);
		$this->load->model('admin/reporte_model', 'reporte', TRUE);

		$this->output->set_content_type('application/json');
	}

	public function index()
	{
		$this->data['seccion'] = "index";
	}

	function login_post()
	{
		if(!$this->post('user') || !$this->post('password'))
		{
			$this->response(NULL, 400);
		} 
		else
		{
			$objeto = array(
				'usuario' => $this->post('user'),
				'password' => md5($this->post('password')),
				'habilitado' => '1'
			);

			$rawData = $this->profesionales->getAll($objeto);

			$rawData = $rawData['rows'];

			if(empty($rawData)) {
				$this->response(array('error' => 'Usiario / Contraseña incorrecto o Profesional deshabilitado.'), 404);
			} else {
				//Se genera el token
				$token['id'] = $rawData['0']->id;
				$token['username'] = $this->post('user');
				$date = new DateTime();
				$token['iat'] = $date->getTimestamp();
				$token['exp'] = $date->getTimestamp() + 60*60*5;
				//Se guarda en el arreglo del profesional
				$rawData['0']->id_token = JWT::encode($token, "aegirsystem");
				//Se quita del arreglo el password
				unset($rawData['0']->password);
				//Time para el objeto del profesional
				$rawData['0']->timestamp = time();
				//Se guarda la sesion en la base de datos
				$objeto = array(
					'idProfesional' => $rawData['0']->id,
					'idToken' => $rawData['0']->id_token
				);

				$sesion = $this->profesionales->verificarSesion($objeto['idProfesional']);

				if(empty($sesion)):
					//Si no existe una sesion activa, simplemente la guarda.
					$this->profesionales->guardarSesion($objeto);
				else:
					//Elimina la sesion
					$this->profesionales->eliminarSesion($objeto['idProfesional']);
					//Guarda la sesion con otro idToken
					$this->profesionales->guardarSesion($objeto);
				endif;

				$this->response($rawData['0'], 200);
			}
		}
	}

	function checktoken_post()
	{
		if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$objeto['idToken'] = $this->head('Auth');

			$profesional = $this->profesionales->verificarToken($objeto['idToken']);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$objeto['id'] = $profesional['0']->idProfesional;

				$rawData = $this->profesionales->getAll($objeto);

				$rawData = $rawData['rows'];

				if(empty($rawData)) {
					$this->response(array('error' => 'El token ya no es valido'), 404);
				} else {
					//Se guarda en el arreglo del profesional
					$rawData['0']->id_token = $objeto['idToken'];
					//Se quita del arreglo el password
					unset($rawData['0']->password);
					//Time para el objeto del profesional
					$rawData['0']->timestamp = time();

					$this->response($rawData['0'], 200);
				}
			}
		}
	}
	
	function logout_post()
	{
		if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$objeto['idToken'] = $this->head('Auth');

			$profesional = $this->profesionales->verificarToken($objeto['idToken']);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$idProfesional = $profesional['0']->idProfesional;

				$rawData = $this->profesionales->eliminarSesion($idProfesional);

				if(empty($rawData)) {
					$this->response(array('error' => 'Error al eliminar la sesion'), 404);
				} else {
					$this->response(array('success' => 'Sesion finalizada'), 200);
				}
			}
		}
	}

	function changePassword_post()
	{
		if(!$this->head('Auth') || !$this->post('password') || !$this->post('old_password') )
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

			$profesional = $this->profesionales->verificarToken($idToken);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				if ( md5( $this->post('old_password') ) == $profesional['0']->password )
				{
					$idProfesional = $profesional['0']->idProfesional;

					$this->sql['password'] = md5($this->post('password'));

					$rawData = $this->profesionales->update($idProfesional, $this->sql);

					if(empty($rawData)) {
						$this->response(array('error' => 'ID Profesional incorrecto'), 404);
					} else {
						$this->response(array('success' => 'Password modificada'), 200);
					}
				}
				else
				{
					$this->response(array('error' => 'El password actual es incorrecto.'), 404);
				}
			}
		}
	}
	
	function rememberPassword_post()
	{
		if(!$this->post('user'))
		{
			$this->response(NULL, 400);
		}
		else
		{
			$this->sql['usuario'] = $this->post('user');

			$rawData = $this->profesionales->getAll($this->sql);

			if(empty($rawData)) {
				$this->response(array('error' => 'No existe un profesional con ese nombre de usuario'), 404);
			}
			else
			{
				$this->load->library('email');

				$tit_style = "font-family:tahoma, verdana, Arial, Helvetica, sans-serif;font-size:12px;color:#2961AD;font-weight:bold; padding:0px; margin-bottom:0px; margin-top:0px; line-height:13px;";

				$text_style = "margin-bottom:0px; margin-top:0px; padding:0px; line-height:13px;font-family:tahoma, verdana, Arial, Helvetica, sans-serif;font-size:12px;color:#333333;line-height:15pt;";


				$password = $this->profesionales->generaPass();
				$encrypt = md5($password);

				$objeto = array(
					'password' => $encrypt
				);
				
				$this->profesionales->update($rawData['rows'][0]->id, $objeto);

				$this->data['data'] = '

				<table width="100%" cellpadding="0" cellspacing="0" border="0">

					<tr>

						<td style="padding:10px 0;" valign="top" align="left">

							<table width="100%" border="1" style="border-style: outset;border-width: 1px;border-spacing:2px;border-color: gray;border-collapse: separate;" cellspacing="0" cellpadding="5">

								<tr><td width="30%"><p style="'.$tit_style.'">Nombre:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->nombre.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Apellido:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->apellido.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">E-mail:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->email.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Usuario:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->usuario.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Contraseña:</p></td>

								<td><p style="'.$text_style.'">'.$password.'</p></td></tr>

							</table>

						</td>

					</tr>

				</table>';

				$this->data['titulo'] = 'Contraseña nueva';

				$this->data['nombre'] = 'Aeir System';

				$address_from = 'info@aegirsystem.com';

				$address_to = $rawData['rows']['0']->email;

				$this->email->subject($this->data['titulo']);

				$this->email->from($address_from, $this->data['nombre']);

				$this->email->to($address_to);

				$this->email->message($this->load->view('sitio/emails/contacto', $this->data, TRUE));

				if (!$this->email->send())
				{
					$this->response(array('error' => $this->email->print_debugger()), 404);
				}
				else
				{
					$this->response(array('success' => 'E-Mail enviado con contraseña nueva'), 200);
				}
			}
		}
	}

	function patients_get()
	{
		if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

			$profesional = $this->profesionales->verificarToken($idToken);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$this->load->model('admin/equipos_model', 'equipos', TRUE);
				
				$objeto = array(
					'idProfesional' => $profesional['0']->idProfesional,
					'empresa' => $profesional['0']->empresa,
					'sucursal' => $profesional['0']->sucursal,
					'estado' => array("0" => "1", "1" => "2")
				);

				$pacientes = $this->profesionales->getAllList($objeto);

				foreach ($pacientes['rows'] as $key => $value) {
					$domicilio = explode(",", $value->direccion);
					if($value->ref_direccion != ''):
						$pacientes['rows'][$key]->direccion = trim( $domicilio['0'] ) .', '.$value->ref_direccion.', '.$value->localidad;
					else:
						$pacientes['rows'][$key]->direccion = trim( $domicilio['0'] ).', '.$value->localidad;
					endif;
					
					if ( $pacientes['rows'][$key]->latitud == '' )
					{
						$pacientes['rows'][$key]->latitud = 0;
					}
					
					if ( $pacientes['rows'][$key]->longitud == '' )
					{
						$pacientes['rows'][$key]->longitud = 0;
					}
					
					if ( $pacientes['rows'][$key]->honorarios == '' )
					{
						$pacientes['rows'][$key]->honorarios = 0;
					}
				}
				
				$objeto = array(
					'empresa' => $profesional['0']->empresa,
					'habilitado' => 1
				);
				
				$equipos = $this->equipos->getAll($objeto);
				
				$paciente_equipos = $this->profesionales->getPacientesEquipos( $profesional['0']->idProfesional );
				
				if(empty($pacientes)) {
					$this->response(array('error' => 'ID Profesional incorrecto'), 404);
				} else {
					$this->response(array( 'pacientes' => $pacientes['rows'], 'equipos' => $equipos['rows'], 'pacientes_equipos' => $paciente_equipos ), 200);
				}
			}
		}
	}

	function audit_post()
	{
		if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$this->load->model('admin/profesionales_model', 'profesionales', TRUE);
			$this->load->model('admin/pacientes_model', 'pacientes', TRUE);
			
			$idToken = $this->head('Auth');

			$profesional = $this->profesionales->verificarToken($idToken);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$idProfesional = $profesional['0']->idProfesional;
				$idPaciente = $this->post('idPaciente');
				$inicio = date("Y-m-d H:i:s", $this->post('initTime'));
				$fin = date("Y-m-d H:i:s", $this->post('endTime'));
				$observaciones = $this->post('observaciones');
				$equipment_state = $this->post('states');
				
				if ( isset( $equipment_state ) )
				{
					$rawData = $this->profesionales->getAllList( array( 'idProfesional' => $idProfesional, 'idPaciente' => $idPaciente ) );
					$rawData = $rawData['rows'];
					
					if(empty($rawData)) {
						$statusCode = 404;
						$rawData = array('error' => 'El profesional no esta asociado a este Paciente.');
					} else {
						$objeto = array(
							'idProfesional_Paciente' => $rawData[0]->id,
							'fecha_llego' => $inicio,
							'fecha_mevoy' => $fin,
							'tiempo' => $fin,
							'observaciones' => $observaciones,
							'honorarios' => $rawData[0]->honorarios
						);
						
						$idVisita = $this->profesionales->saveVisita($objeto);
						
						foreach ( $equipment_state as $es )
						{
							$es['idVisita'] = $idVisita;
							
							$this->profesionales->saveEquiposVisita( $es );
						}
						
						$this->pacientes->update( $idPaciente, array( 'auditado' => 1 ) );
						
						$statusCode = 200;
						$rawData = array('success' => 'Auditoría Guardada', 'id' => $idVisita);
					}
				}
				else
				{
					$statusCode = 400;
					$rawData = array('error' => 'Sin datos de estado.');
				}
				
				$this->response($rawData, $statusCode);
			}
		}
	}
	
	public function geodecode_patients_get()
	{
		require_once( LIBSPATH . 'geocode.php' );
		
		if ( $this->get('code') == 'seccodeACJDOQWTEJK17K191J2' )
		{
			$this->load->model('admin/pacientes_model','pacientes', TRUE);
			
			$patients = $this->pacientes->getAll();
			
			foreach ( $patients['rows'] as $p )
			{
				if ( !isset( $p->latitud ) || intval( $p->latitud ) == 0 )
				{
					$gdc_status	= '';
					$coords		= Geocode::GetLatLong($p->direccion, $p->localidad, $gdc_status);
					
					if( $coords )
					{
						$this->pacientes->update( $p->id, array( 'latitud' => $coords->lat, 'longitud' => $coords->lng ) );
						
						echo "Fixed location for: paciente: " . $p->id . " dir: " . $p->direccion . " ( " . $p->localidad . " )\n";
					}
					else
					{
						echo "Couldn't fix location for: paciente: " . $p->id . " dir: " . $p->direccion . " ( " . $p->localidad . " )\n";
					}
				}
			}
		}
	}
}
