<script type="text/javascript">
    $(document).ready(function () {
        // if all checkbox are selected, check the selectall checkbox
        // and viceversa
        $("#sub_all").click(function () {
            $('.sub_ele').attr('checked', this.checked);
        });
        $(".sub_ele").click(function () {
            if ($(".sub_ele").length == $(".sub_ele:checked").length) {
                $("#sub_all").attr("checked", "checked");
            } else {
                $("#sub_all").removeAttr("checked");
            }
        });

        $('#sub_nuevo').click(function () {
            $("#pacientes").load("<?php echo base_url('admin/' . $dir . '/sub_edit/0/' . '/' . $honorario)?>", {idProfesional: '<?php echo $idProfesional?>'});
        });

        $('#sub_restaurar').click(function () {
            $("#pacientes").load("<?php echo base_url('admin/' . $dir . '/sub_restaurar/' . $idProfesional) ?>");
        });

        $('.sub_edit').click(function (event) {
            $("#pacientes").load($(this).attr('href'), {idProfesional: '<?php echo $idProfesional?>'});
            return false;
        });

        $('#sub_eliminar').click(function () {
            var selectedItems = new Array();
            $("input[@name='sub_ele[]']:checked").each(function () {
                selectedItems.push($(this).val());
            });
            if (selectedItems.length > 0) {
                $("#pacientes").load("<?php echo base_url('admin/' . $dir . '/sub_delete/')?>", {
                    idProfesional: '<?php echo $idProfesional?>',
                    sub_ele: selectedItems
                });
                $(".close").click();
                return false;
            }
            else {
                $(".close").click();
            }
        });

    });
</script>

<div class="modal fade hide" id="myModal">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h3>Eliminar</h3>
    </div>
    <div class="modal-body">
        <p>¿Desea eliminar los registros?</p>
    </div>
    <div class="modal-footer">
        <a href="#" class="btn" data-dismiss="modal">Cancelar</a>
        <a href="#" class="btn btn-primary" id="sub_eliminar">Aceptar</a>
    </div>
</div>

<div id="page-title" class="clearfix">
    <span style="font-size:24px;font-weight:bold;float:left;margin-top:5px;"><?php echo $dir3; ?></span>
    <div class="item-content" style="float:right;">
        <button class="btn btn-inverse" id="sub_nuevo">Nuevo</button>
        <a href="#myModal" data-toggle="modal" class="btn btn-inverse">Eliminar</a>
        <button class="btn btn-inverse" id="sub_restaurar">Restaurar</button>
    </div>
</div> <!-- /.page-title -->

<div class="row">
    <div class="span12">
        <div class="widget widget-table">
            <div class="widget-content">
                <div id="example_wrapper" class="dataTables_wrapper form-inline" role="grid">
                    <?php // if(isset($message)) echo $message;?>

                    <table id="list" class="table table-bordered table-striped table-highlight">

                        <?php $this->load->view('partials/sub_table_header.php'); ?>

                        <form action="<?php echo base_url('admin/' . $dir . '/sub_delete/'); ?>" id="delete-form"
                              method="POST" class="form-horizontal">
                            <tbody>
                            <?php foreach ($rows as $row): ?>
                                <?php if($row->estado == 1): ?>
                                    <tr>
                                        <td style="text-align:center;"><input type="checkbox" name="sub_ele[]"
                                                                              id="sub_ele_<?php echo $row->id; ?>"
                                                                              class="sub_ele"
                                                                              value="<?php echo $row->id; ?>"/></td>
                                        <?php foreach ($fields as $field_name => $field_display): ?>
                                            <?php if ($field_display == 'Imagen') { ?>
                                                <td>
                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>"><img
                                                            class="min-back"
                                                            src="<?php echo base_url('assets/archivos/' . $dir . '/original/' . $row->foto); ?>"
                                                            alt="" style="opacity: 1; "> </a>
                                                </td>
                                            <?php } else if ($field_display == 'Principal') { ?>
                                                <td>

                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>">
                                                        <?php if ($row->$field_name == 1) echo 'Si'; else echo 'No'; ?>
                                                    </a>

                                                </td>
                                            <?php } else if ($field_display == 'Hora|Sesi&oacute;n') { ?>
                                                <td>

                                                    <?php 
                                                        $hora = date("H", strtotime($row->duracion_sesion));
                                                        $minutos = date("i", strtotime($row->duracion_sesion));
                                                        $duracion_sesion = $hora.':'.$minutos;
                                                    ?>
                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>">
                                                        <?php if ($row->$field_name == 1) echo 'Horas (Cantidad: ' . $duracion_sesion . ' Hs)'; else echo 'Sesiones de ' . $duracion_sesion . ' Hs'; ?>
                                                    </a>

                                                </td>

                                            <?php } else if ($field_display == 'Duraci&oacute;n') { ?>
                                                <td>
                                                    <?php 
                                                        $hora = date("H", strtotime($row->$field_name));
                                                        $minutos = date("i", strtotime($row->$field_name));
                                                        $duracion_sesion = ($hora*60) + $minutos;
                                                    ?>
                                                    <?php if ($row->$field_name == 0) { ?>
                                                        <a class="sub_edit"
                                                           href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>">
                                                            <?php echo 'Por horas'; ?>
                                                        </a>
                                                    <?php } else { ?>
                                                        <a class="sub_edit"
                                                           href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>">
                                                            <?php echo $duracion_sesion . ' minutos'; ?>
                                                        </a>
                                                    <?php } ?>

                                                </td>
                                            <?php } else if ($field_display == 'Creado' || $field_display == 'Modificado') { ?>
                                                <td>

                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/edit/' . $row->id); ?>">
                                                        <?php echo date("d-m-Y H:i:s", strtotime($row->$field_name)); ?>
                                                    </a>

                                                </td>
                                            <?php } else if ($field_display == 'Habilitado') { ?>
                                                <td>

                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id); ?>">
                                                        <?php if ($row->$field_name == 1) echo 'Si'; else echo 'No'; ?>
                                                    </a>

                                                </td>
                                            <?php } else { ?>
                                                <td>
                                                    <a class="sub_edit"
                                                       href="<?php echo site_url('admin/' . $dir . '/sub_edit/' . $row->id . '/' . $honorario); ?>"><?php echo character_limiter($row->$field_name, 120); ?></a>
                                                </td>
                                                <?php
                                            }
                                        endforeach; ?>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; ?>
                            </tbody>
                        </form>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>	