<script type="text/javascript">
    $(document).ready(function () {
        $('#sub_form').validate(
            {
                rules: {
                    nombre: {
                        required: true
                    }
                },
                focusCleanup: false,

                highlight: function (label) {
                    $(label).closest('.control-group').removeClass('success').addClass('error');
                },
                success: function (label) {
                    label
                        .text('OK!').addClass('valid')
                        .closest('.control-group').addClass('success');
                },
                errorPlacement: function (error, element) {
                    error.appendTo(element.parents('.controls'));
                }
            });
        $('.cancel').click(function () {
            $("#sucursales").load("<?php echo base_url('admin/' . $dir . '/sub_index/' . $empresa)?>");
        });
        $('#eliminar').click(function () {
            if (!confirm('Eliminar imagen?')) {
                return false
            }
        });
        $('.form').eq(0).find('input').eq(0).focus();
        $("form#sub_form").submit(function (event) {
            if ($(this).valid()) {
                event.preventDefault();
                //grab all form data
                var formData = new FormData($(this)[0]);

                $.ajax({
                    url: "<?php echo base_url('admin/' . $dir . '/sub_update')?>",
                    type: 'POST',
                    data: formData,
                    async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (returndata) {
                        $("#sucursales").html(returndata);
                    }
                });
                return false;
            }
        });
    });
</script>
<form action="" id="sub_form" method="POST" enctype="multipart/form-data" class="form-horizontal"
      novalidate="novalidate">
    <input type="hidden" id="id" name="id" value="<?php echo (isset($row->id)) ? $row->id : "0"; ?>"/>
    <input type="hidden" id="empresa" name="empresa" value="<?php echo $empresa ?>"/>

    <div id="page-title" class="clearfix">
        <span style="font-size:24px;font-weight:bold;float:left;margin-top:5px;"><?php echo $dir2; ?></span>
        <div class="item-content" style="float:right;">
            <button type="submit" class="btn btn-inverse">Guardar</button>
            <button class="btn cancel">Cancelar</button>
        </div>
    </div>

    <div class="row">
        <div class="span12">
            <div id="validation" class="widget highlight widget-form">

                <div class="widget-content">

                    <fieldset>

                        <div class="control-group">
                            <label class="control-label" for="nombre">Nombre</label>
                            <div class="controls">
                                <?php $nombre = (isset($row->nombre)) ? $row->nombre : ''; ?>
                                <input type="text" class="input-xxlarge" name="nombre" id="nombre"
                                       value="<?php echo set_value('nombre', $nombre); ?>">
                            </div>
                        </div>

                        <div class="control-group">
                            <label class="control-label" for="domicilio">Domicilio</label>
                            <div class="controls">
                                <?php $domicilio = (isset($row->domicilio)) ? $row->domicilio : ''; ?>
                                <input type="text" class="input-xxlarge" name="domicilio" id="domicilio"
                                       value="<?php echo set_value('domicilio', $domicilio); ?>">
                            </div>
                        </div>

                        <div class="control-group">
                            <label class="control-label" for="localidad">Localidad</label>
                            <div class="controls">
                                <?php $localidad = (isset($row->localidad)) ? $row->localidad : ''; ?>
                                <input type="text" class="input-xxlarge" name="localidad" id="localidad"
                                       value="<?php echo set_value('localidad', $localidad); ?>">
                            </div>
                        </div>

                        <div class="control-group">
                            <label class="control-label" for="telefono">Tel&eacute;fono</label>
                            <div class="controls">
                                <?php $telefono = (isset($row->telefono)) ? $row->telefono : ''; ?>
                                <input type="text" class="input-xxlarge" name="telefono" id="telefono"
                                       value="<?php echo set_value('telefono', $telefono); ?>">
                            </div>
                        </div>

                        <div class="control-group">
                            <label class="control-label" for="email">E-Mail</label>
                            <div class="controls">
                                <?php $email = (isset($row->email)) ? $row->email : ''; ?>
                                <input type="text" class="input-xxlarge" name="email" id="email"
                                       value="<?php echo set_value('email', $email); ?>">
                            </div>
                        </div>

                        <div class="control-group">
                            <label class="control-label">Habilitado</label>
                            <div class="controls">
                                <?php
                                $habilitado = (isset($row->habilitado)) ? $row->habilitado : '1';
                                $si = ($habilitado == 1) ? TRUE : FALSE;
                                $no = ($habilitado == 0) ? TRUE : FALSE;
                                ?>
                                <label class="radio">
                                    <input type="radio" name="habilitado" id="si"
                                           value="1" <?php echo set_radio('habilitado', '1', $si); ?>>
                                    Si
                                </label>
                                <label class="radio">
                                    <input type="radio" name="habilitado" id="no"
                                           value="0" <?php echo set_radio('habilitado', '0', $no); ?>>
                                    No
                                </label>
                            </div>
                        </div>

                        <div class="form-actions">
                            <button type="submit" id="sub_guardar" class="btn btn-inverse">Guardar</button>
                            <button class="btn cancel">Cancelar</button>
                        </div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
</form>