<?php

class usuarios_model extends CI_Model
{
    private $tabla = 'users';
    private $id = 'id';
    private $busqueda = 'username';
    private $order = array('username');
    private $campos = array(
        'username' => 'Usuario',
        'empresa' => 'Empresa',
        'pertenece' => 'Sucursal',
        'active' => 'Habilitado',
    );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        $this->db->select($this->tabla.'.*, empresas.razon_social as empresa, empresas_sucursales.nombre as pertenece');
        $this->db->join('empresas', 'empresas.id = '.$this->tabla.'.company', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = '.$this->tabla.'.sucursal', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        // Qualification
        if (isset($objeto['search'])) $this->db->like($this->tabla. '.' .$this->busqueda, $objeto['search']);

        if (isset($objeto['id'])) $this->db->where($this->tabla. '.' .$this->id, $objeto['id']);

        if (isset($objeto['empresa'])) $this->db->where($this->tabla.'.company', $objeto['empresa']);

        if (isset($objeto['sucursal'])) $this->db->where($this->tabla.'.sucursal', $objeto['sucursal']);

        if (isset($objeto['active'])) $this->db->where($this->tabla.'.active', $objeto['active']);

        /* limit / offset */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));

        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);

        // order
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);

        $ret['rows'] = $this->db->get($this->tabla)->result();

        //echo $this->db->last_query();

        // count query
        $q = $this->db->select('COUNT(*) as count', FALSE)
            ->from($this->tabla);

        $this->db->join('empresas', 'empresas.id = '.$this->tabla.'.company', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = '.$this->tabla.'.sucursal', 'left');

        if (isset($objeto['search'])) $this->db->like($this->tabla. '.' .$this->busqueda, $objeto['search']);

        if (isset($objeto['id'])) $this->db->where($this->tabla. '.' .$this->id, $objeto['id']);

        if (isset($objeto['empresa'])) $this->db->where($this->tabla.'.company', $objeto['empresa']);

        if (isset($objeto['sucursal'])) $this->db->where($this->tabla.'.sucursal', $objeto['sucursal']);

        if (isset($objeto['active'])) $this->db->where($this->tabla.'.active', $objeto['active']);

        $tmp = $q->get()->result();

        $ret['num_rows'] = $tmp[0]->count;

        return $ret;
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function delete($elementos)
    {
        $objeto = array("active" => 0);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function restore($elementos)
    {
        $objeto = array("active" => 1);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function deleteEmpresaYusuario($elementos)
    {
        $objeto = array('active' => 0);
        $this->db->where_in('company', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function restoreEmpresaYusuario($elementos)
    {
        $objeto = array('active' => 1);
        $this->db->where_in('company', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function deleteSucursalYusuario($elementos)
    {
        $objeto = array('active' => 0);
        $this->db->where_in('sucursal', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function restoreSucursalYusuario($elementos)
    {
        $objeto = array('active' => 1);
        $this->db->where_in('sucursal', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function getGrupos()
    {
        $this->db->select('id, name, description');
        return $this->db->get('groups')->result();
    }

    function getUsuarioXGrupo($id)
    {
        $select = $this->db->select('users_groups.user_id, users_groups.group_id, groups.id, groups.name, groups.description')->from('users_groups');
        $this->db->join('groups', 'groups.id = users_groups.group_id', 'left');
        $this->db->join('users', 'users.id = users_groups.user_id', 'left');
        $this->db->where('users_groups.user_id', $id);
        return $select->get()->result();
    }
}