<?php

class reporte_model extends CI_Model
{
    private $tabla = 'profesionales';
    private $id = 'id';
    private $busqueda = 'apellidoynombre';
    private $order = array('apellidoynombre');

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        //$this->db->select($this->tabla.'.*, categoria.nombre as categoria');
        //$this->db->join('categoria', 'categoria.id = '.$this->tabla.'.id_categoria', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Limit / Offset - */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
            
        /* - Order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Join - Quitar si no hace falta */
        //$this->db->join('categoria', 'categoria.id = ' . $this->tabla . '.id_categoria', 'left');
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function delete($elementos)
    {
        $this->db->where_in($this->id, $elementos);
        $this->db->delete($this->tabla);
    }

    function verificarTiempo()
    {
        $actual = date('Y-m-d H:i:s');
        $this->db->select('profesionales_pacientes_visitas.id, profesionales_pacientes_visitas.fecha_llego, profesionales_pacientes_visitas.tiempo, profesionales_pacientes_visitas.cont_cronjob');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NULL');
        $this->db->where('profesionales_pacientes_visitas.tiempo != "00:00:00"');

        $ret['rows'] = $this->db->get('profesionales_pacientes_visitas')->result();
        $ret['diff'] = '';

        foreach($ret['rows'] as $row):
            $fecha_llego = new DateTime($row->tiempo);
            $diferencia = $fecha_llego->diff(new DateTime($actual));
            //$diff = $diferencia->h.':'.$diferencia->i.':'.$diferencia->s;
            $diff = $diferencia->format("%H:%I:%S");

            $ret['diff'][$row->id] = $diff;
        endforeach;

        return $ret;
    }

    function reporteProfesionales($objeto = array())
    {
        $this->db->select('profesionales.apellidoynombre as nombreProfesional,
        profesionales_pacientes.visitasxmes cantidadMaxPorMes, 
        profesionales_pacientes.idPaciente as idPaciente,
        profesionales_pacientes.idProfesional as idProfesional,
        COUNT(DISTINCT profesionales_pacientes.id) as visitasrealizadas, 
        COUNT(DISTINCT profesionales_pacientes_visitas.id) as sesiones, 
        pacientes.nombreyapellido as nombrePaciente , 
        localidades.nombre as localidad, 
        SUM(TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego ))) as cantidad, 
        profesionales_pacientes_visitas.idProfesional_Paciente', FALSE);
        $this->db->join('profesionales_pacientes', $this->tabla.'.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('localidades', 'localidades.id = pacientes.idLocalidad', 'left');
        $this->db->where($this->tabla.'.id', $objeto['idProfesional']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        if(isset($objeto['notnull'])):
            $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        endif;

        if(isset($objeto['pormes'])):
            $mes = date('m');
            $this->db->where('MONTH(profesionales_pacientes_visitas.fecha_llego) = '.$mes);
        endif;

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        if (isset($objeto['empresa'])) $this->db->where('pacientes.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('pacientes.sucursal', $objeto['sucursal']);
        $this->db->group_by('profesionales_pacientes_visitas.idProfesional_Paciente');
        $this->db->order_by('pacientes.nombreyapellido', 'ASC');

        $ret['rows'] = $this->db->get($this->tabla)->result();
        //echo $this->db->last_query();

        return $ret;
    }

    function cantPacientesXProfesional($objeto = array())
    {
    	$this->db->select('COUNT(profesionales_pacientes.id) AS cantidad');
    	$this->db->join('profesionales', 'profesionales_pacientes.idProfesional = profesionales.id', 'left');
    	$this->db->where($this->tabla.'.id', $objeto['idProfesional']);
    	if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes.creado  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        $ret['cantidad'] = $this->db->get('profesionales_pacientes')->result();

        return $ret;
    }

    function sesionesTotalesPorPaciente($objeto = array())
    {
        $this->db->select('profesionales_pacientes.idProfesional, profesionales_pacientes.idPaciente, COUNT(profesionales_pacientes_visitas.id) as totalSesiones');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->where('profesionales_pacientes.idProfesional', $objeto['idProfesional']);
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        $this->db->group_by('profesionales_pacientes_visitas.idProfesional_Paciente');

        $ret['visitasTotal'] = $this->db->get('profesionales_pacientes_visitas')->result();

        //echo $this->db->last_query();

        return $ret;
    }

    function reportePacientes($objeto = array())
    {
        $this->db->select('profesionales.apellidoynombre as nombreProfesional, 
        COUNT(profesionales_pacientes_visitas.id) as sesiones, 
        pacientes.nombreyapellido as nombrePaciente , 
        localidades.nombre as localidad, 
        SUM(TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego ))) as cantidad, 
        profesionales_pacientes_visitas.idProfesional_Paciente, 
        especialidades.nombre as especialidad', FALSE);
        $this->db->join('profesionales_pacientes', $this->tabla.'.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('especialidades', $this->tabla.'.idEspecialidad = especialidades.id', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('localidades', 'localidades.id = pacientes.idLocalidad', 'left');
        $this->db->where('pacientes.id', $objeto['idPaciente']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        $this->db->group_by('nombreProfesional, nombrePaciente, profesionales_pacientes_visitas.idProfesional_Paciente');
        $this->db->order_by($this->tabla.'.apellidoynombre', 'ASC');

        $ret['rows'] = $this->db->get($this->tabla)->result();

        return $ret;
    }

    function reporteLocalidades($objeto = array())
    {
        $this->db->select('profesionales.apellidoynombre as nombreProfesional, 
        COUNT(profesionales_pacientes_visitas.id) as sesiones, 
        pacientes.nombreyapellido as nombrePaciente , 
        localidades.nombre as localidad, 
        SUM(TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego ))) as cantidad, 
        profesionales_pacientes_visitas.idProfesional_Paciente, 
        especialidades.nombre as especialidad', FALSE);
        $this->db->join('profesionales_pacientes', $this->tabla.'.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('especialidades', $this->tabla.'.idEspecialidad = especialidades.id', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('localidades', 'localidades.id = pacientes.idLocalidad', 'left');
        $this->db->where('localidades.id', $objeto['idLocalidad']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        $this->db->group_by('nombrePaciente, nombreProfesional');
        $this->db->order_by('pacientes.nombreyapellido', 'ASC');

        $ret['rows'] = $this->db->get($this->tabla)->result();

        return $ret;
    }

    function obtenerDetalle($objeto = array())
    {
        $this->db->select('profesionales_pacientes_visitas.id, 
        profesionales_pacientes_visitas.idProfesional_Paciente, 
        profesionales_pacientes_visitas.fecha_llego as entrada, 
        profesionales_pacientes_visitas.fecha_mevoy as salida, 
        profesionales_pacientes_visitas.observaciones as observaciones,
        especialidades.nombre as especialidad, 
        pacientes.nombreyapellido as nombrePaciente, 
        profesionales.apellidoynombre as nombreProfesional, 
        TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) as cantidad, 
        TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy , profesionales_pacientes_visitas.fecha_llego )) as semaforo', FALSE);

        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');

        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');

        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');

        $this->db->join('especialidades', 'especialidades.id = profesionales.idEspecialidad', 'left');

        $this->db->where('profesionales_pacientes_visitas.idProfesional_Paciente', $objeto['id']);

        if($objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '') {
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        }

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        if (isset($objeto['empresa'])) $this->db->where('pacientes.empresa', $objeto['empresa']);

        $this->db->order_by($this->tabla.'.apellidoynombre', 'ASC');
        $this->db->order_by('profesionales_pacientes_visitas.fecha_llego', 'DESC');

        $ret['rows'] = $this->db->get('profesionales_pacientes_visitas')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function obtenerEquiposXVisita($objeto = array())
    {
        $this->db->select('visitas_equipos.idVisita, visitas_equipos.estado, equipos.nombre');
        $this->db->join('equipos', 'equipos.id = visitas_equipos.idEquipo', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes_visitas.id = visitas_equipos.idVisita', 'left');
        
        $this->db->where('profesionales_pacientes_visitas.idProfesional_Paciente', $objeto['id']);

        if($objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '') {
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        }

        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        $this->db->order_by('visitas_equipos.estado DESC');

        $ret['equipos'] = $this->db->get('visitas_equipos')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function obtenerPacientes($objeto = array())
    {
        $this->db->select('pacientes.id as idPaciente, pacientes.nombreyapellido as nombrePaciente', FALSE);
        if (isset($objeto['empresa'])) $this->db->where('pacientes.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('pacientes.sucursal', $objeto['sucursal']);
        $this->db->order_by('pacientes.nombreyapellido', 'ASC');
        $ret = $this->db->get('pacientes')->result();

        return $ret;
    }

    function obtenerProfecionales($objeto = array())
    {
        $this->db->select($this->tabla.'.id as idProfesional, profesionales.apellidoynombre as nombreProfesional, '.$this->tabla.'.idEspecialidad', FALSE);
        if (isset($objeto['idEspecialidad'])) $this->db->where($this->tabla . '.idEspecialidad', $objeto['idEspecialidad']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        $this->db->order_by($this->tabla.'.apellidoynombre', 'ASC');
        $ret = $this->db->get($this->tabla)->result();

        return $ret;
    }

    function obtenerEspecialidades($objeto = array())
    {
        $this->db->select('especialidades.id as idEspecialidad, especialidades.nombre as especialidad');
        $this->db->join('profesionales', 'profesionales.idEspecialidad = especialidades.id', 'left');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.idProfesional = profesionales.id', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes_visitas.idProfesional_Paciente = profesionales_pacientes.id', 'left');

        if (isset($objeto['empresa'])) $this->db->where('especialidades.empresa', $objeto['empresa']);

        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        $this->db->group_by('especialidades.id');
        $this->db->order_by('especialidades.nombre', 'ASC');
        $ret = $this->db->get('especialidades')->result();

        return $ret;
    }

    function obtenerPacientesPorProfesional($objeto = array())
    {
        $this->db->select('profesionales_pacientes.id as idProfesional_Paciente, profesionales_pacientes.idProfesional, profesionales_pacientes.idPaciente, profesionales_pacientes.honorarios');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('profesionales_pacientes_visitas', 'profesionales_pacientes_visitas.idProfesional_Paciente = profesionales_pacientes.id', 'left');
        if (isset($objeto['idProfesional'])) $this->db->where('profesionales_pacientes.idProfesional', $objeto['idProfesional']);
        if (isset($objeto['idPaciente'])) $this->db->where('profesionales_pacientes.idPaciente', $objeto['idPaciente']);
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        $this->db->group_by('profesionales_pacientes.id');
        $ret = $this->db->get('profesionales_pacientes')->result();

        return $ret;
    }

    function obtenerCantVisitas($objeto = array())
    {
        $this->db->select('COUNT(profesionales_pacientes_visitas.id) as sesiones');
        if (isset($objeto['idProfesional_Paciente'])) $this->db->where('profesionales_pacientes_visitas.idProfesional_Paciente', $objeto['idProfesional_Paciente']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        $ret['cantidad'] = $this->db->get('profesionales_pacientes_visitas')->result();

        //echo $this->db->last_query();

        return $ret;
    }

    function obtenerSumaHonorarios($objeto = array())
    {
        $this->db->select('SUM(profesionales_pacientes_visitas.honorarios) as honorarios');
        if (isset($objeto['idProfesional_Paciente'])) $this->db->where('profesionales_pacientes_visitas.idProfesional_Paciente', $objeto['idProfesional_Paciente']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        //$this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');

        $ret['honorarios'] = $this->db->get('profesionales_pacientes_visitas')->result();

        //echo $this->db->last_query();

        return $ret;
    }
    
    function obtenerObservaciones($objeto = array())
    {
        $this->db->select('observaciones');
        if (isset($objeto['idProfesional_Paciente'])) $this->db->where('profesionales_pacientes_visitas.idProfesional_Paciente', $objeto['idProfesional_Paciente']);
        if (isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');

        $ret['observaciones'] = $this->db->get('profesionales_pacientes_visitas')->result();

        return $ret;
    }
    
    function obtenerEspecialidades2($objeto = array())
    {
        $this->db->select('especialidades.id as idEspecialidad, especialidades.nombre as especialidad');
        $this->db->join('profesionales', 'profesionales.idEspecialidad = especialidades.id', 'left');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.idProfesional = profesionales.id', 'left');
        if (isset($objeto['empresa'])) $this->db->where('especialidades.empresa', $objeto['empresa']);
        $this->db->where('profesionales_pacientes.id', $objeto['idProfesional_Paciente']);
        $this->db->order_by('especialidades.nombre', 'ASC');
        $ret = $this->db->get('especialidades')->result();

        return $ret;
    }

    function obtenerPacientesUnicos($objeto = array())
    {
        $this->db->distinct();
        $this->db->select('pacientes.id as idPaciente, pacientes.nombreyapellido as nombrePaciente, profesionales_pacientes_visitas.idProfesional_Paciente', FALSE);
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        if (isset($objeto['empresa'])) $this->db->where('profesionales.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('profesionales.sucursal', $objeto['sucursal']);
        $this->db->where('profesionales.empresa', $objeto['empresa']);
        $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        $this->db->order_by('nombrePaciente', 'ASC');
        $rows = $this->db->get('profesionales_pacientes_visitas')->result();
        $resul = array();
        //echo $this->db->last_query();
        foreach($rows as $row):
            $objetoCant = array(
                'idProfesional_Paciente' => $row->idProfesional_Paciente,
                'fecha_desde' => $objeto['fecha_desde'],
                'fecha_hasta' => $objeto['fecha_hasta']
            );
            $cant = $this->obtenerCantVisitas($objetoCant);
            $sesiones = $cant['cantidad']['0']->sesiones;
            //var_dump($row);
            if($sesiones > 0 ) $resul[] = (object) array('idPaciente' => $row->idPaciente, 'nombrePaciente'=>$row->nombrePaciente);
        endforeach;
        //var_dump($resul);        
        $resultado = array_map("unserialize", array_unique(array_map("serialize", $resul)));
        //var_dump($resultado);
        //die();
        return($resultado);
    }

    function obtenerProfesionalesUnicos($objeto = array())
    {
        $this->db->distinct();
        $this->db->select('profesionales.id as idProfesional, profesionales.apellidoynombre as nombreProfesional, profesionales_pacientes_visitas.idProfesional_Paciente', FALSE);
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        if (isset($objeto['empresa'])) $this->db->where('profesionales.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('profesionales.sucursal', $objeto['sucursal']);
        $this->db->where('profesionales.empresa', $objeto['empresa']);
        $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NOT NULL');
        $this->db->order_by('nombreProfesional', 'ASC');
        $rows = $this->db->get('profesionales_pacientes_visitas')->result();
        $resul = array();
        //echo $this->db->last_query();
        foreach($rows as $row):
            $objetoCant = array(
                'idProfesional_Paciente' => $row->idProfesional_Paciente,
                'fecha_desde' => $objeto['fecha_desde'],
                'fecha_hasta' => $objeto['fecha_hasta']
            );
            $cant = $this->obtenerCantVisitas($objetoCant);
            $sesiones = $cant['cantidad']['0']->sesiones;
            //var_dump($row);
            if($sesiones > 0 ) $resul[] = (object) array('idProfesional' => $row->idProfesional, 'nombreProfesional'=>$row->nombreProfesional);
        endforeach;
        //var_dump($resul);        
        $resultado = array_map("unserialize", array_unique(array_map("serialize", $resul)));
        //var_dump($resultado);
        //die();
        return($resultado);
    }

    function obtenerSucursalesDeEmpresa($objeto = array())
    {
        $this->db->select('first_name, sucursal, COALESCE(empresas_sucursales.nombre,empresas.nombre,users.first_name) AS sucursal_name');
        $this->db->where('company', $objeto['empresa']);
        if (isset($objeto['todas']) && $objeto['todas'] == 'no') $this->db->where('sucursal', $objeto['sucursal']);
        $this->db->where('sucursal != "Master"');
        $this->db->where('active', 1);
        if (isset($objeto['user_id'])) $this->db->where('users.id',$objeto['user_id']);
        
        $this->db->join('empresas', 'empresas.id = CONVERT(users.company,SIGNED)', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = CONVERT(users.sucursal,SIGNED) AND empresas_sucursales.empresa = CONVERT(users.company,SIGNED)', 'left');
        
        $this->db->order_by('sucursal', 'ASC');

        return $this->db->get('users')->result();
    }

    function exportarExcel($objeto = array())
    {
        $this->load->library('PHPExcel');
        $this->phpexcel->getProperties()
            ->setTitle("Reporte")
            ->setDescription("Detalle de profesionales y pacientes");
        // Setiar la solapa que queda actia al abrir el excel
        $this->phpexcel->setActiveSheetIndex(0)->mergeCells('A1:E1');
        // Solapa excel para trabajar con PHP
        $sheet = $this->phpexcel->getActiveSheet();
        $sheet->setTitle("Detalle");
        $sheet->getRowDimension('1')->setRowHeight(73);        
        $path = $_SERVER['DOCUMENT_ROOT'].'/assets/admin/img/title.png';
        
        if (file_exists($path)) {
            $objDrawing = new PHPExcel_Worksheet_Drawing();
            $objDrawing->setName('Aeir system');
            $objDrawing->setDescription('Aeir system');
            //Path to signature .jpg file
            $objDrawing->setPath($path);
            $objDrawing->setOffsetX(8);                     //setOffsetX works properly
            $objDrawing->setCoordinates('A1');             //set image to cell E38
            $objDrawing->setHeight(90);                     //signature height  
            $objDrawing->setWorksheet($sheet);  //save      
        }

        $a = 2;
        $b = 2;
        $gananciaT = 0;

        foreach($this->obtenerSucursalesDeEmpresa($objeto) as $sucursal):
            
            $sheet->getRowDimension('$b')->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Sucursal: '.$sucursal->sucursal_name);
            $sheet->getStyle('A'.$b)->getFont()->setBold(true);
            $sheet->mergeCells("A".$b.":"."E".$b);
            $sheet->getStyle("A".$b.":"."E".$b)
                        ->getAlignment()
                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A".$b.":"."E".$b)
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setRGB('#7B68EE');

            $a++;
            $b++;

            $sheet->getRowDimension($b)->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Pacientes');
            $sheet->getColumnDimension('B')->setWidth(40);
            $sheet->setCellValue('B'.$b, 'Profesionales');
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->setCellValue('C'.$b, 'Importes');
            $sheet->getColumnDimension('D')->setWidth(15);
            $sheet->setCellValue('D'.$b, 'Cant. Visitas');
            $sheet->getColumnDimension('E')->setWidth(10);
            $sheet->setCellValue('E'.$b, 'Total');
            $sheet->getStyle("A".$b.":"."E".$b)
                ->getFill()
                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                ->getStartColor()
                ->setRGB('e5e5e5');
            $sheet->getStyle("A".$b.":"."E".$b)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
            $sheet->getStyle("A:E")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

            $a++;
            $b++;
            $ganancia = 0;

            $objeto['sucursal'] = $sucursal->sucursal;

            foreach($this->obtenerPacientesUnicos($objeto) as $pacientes):
                $objetoVerif = array(
                    'idPaciente' => $pacientes->idPaciente,
                    'fecha_desde' => $objeto['fecha_desde'],
                    'fecha_hasta' => $objeto['fecha_hasta']
                );


                $objetoPacientesPorProfesional = array(
                    'idPaciente' => $pacientes->idPaciente
                );
                if($this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) != NULL && $this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) != '') {
                    $honorarios = 0;
                    $sesionesT = 0;
                    $honorariosT = 0;
                    $sheet->getRowDimension("$a")->setRowHeight(20);
                    $sheet->setCellValue("A$a", $pacientes->nombrePaciente);
                    $objetoPacientesPorProfesional = array(
                        'idPaciente' => $pacientes->idPaciente
                    );
                    //$objeto['idProfesional_Paciente'] = $pacientes->idProfesional_Paciente;= 1)
                    foreach ($this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) as $union):
                        foreach ($this->obtenerProfecionales($objeto) as $profesional):
                            if ($union->idProfesional == $profesional->idProfesional && $union->idPaciente == $pacientes->idPaciente):
                                $sheet->setCellValue("B$b", $profesional->nombreProfesional);
                                $honorarios = 0;
                                $objetoCant = array(
                                    'idProfesional_Paciente' => $union->idProfesional_Paciente,
                                    'fecha_desde' => $objeto['fecha_desde'],
                                    'fecha_hasta' => $objeto['fecha_hasta']
                                );

                                $cant = $this->obtenerCantVisitas($objetoCant);

                                $hon = $this->obtenerSumaHonorarios($objetoCant);

                                $sesiones = $cant['cantidad']['0']->sesiones;

                                $honorarios += $hon['honorarios']['0']->honorarios;
                                $honorariosT += $honorarios;
                                
                                if($sesiones > 0):

                                    $sheet->setCellValue("C$b", "$".$union->honorarios." por visita");

                                    $sheet->getRowDimension("$b")->setRowHeight(20);
                                    $sheet->setCellValue("D$b", $sesiones);
                                    $sheet->setCellValue("E$b", $honorarios);
                                    $sheet->getStyle("C$b:E$b")
                                        ->getAlignment()
                                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                                    $sheet->getStyle("E$b")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);

                                    $b++;
                                endif;
                            endif;
                        endforeach;
                    endforeach;

                    $sheet->getStyle("A$b:E$b")
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setRGB('E0EAF1');
                    $sheet->getRowDimension("$b")->setRowHeight(20);
                    $sheet->getStyle("C$b:E$b")
                        ->getAlignment()
                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                    $sheet->setCellValue("A$b", "Total ".$pacientes->nombrePaciente);
                    $sheet->getStyle("A$b")->getFont()->setBold(true);

                    $sheet->setCellValue("E$b", $honorariosT);

                    $ganancia += $honorariosT;

                    $sheet->getStyle("E$b")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                    $sheet->getStyle("E$b")->getFont()->setBold(true);
                    $b++;
                    $a = $b;
                }

            endforeach;

            $b++;

             $sheet->getStyle("A$b:E$b")
                        ->getFill()
                        ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setRGB('E0EAF1');
                    $sheet->getRowDimension("$b")->setRowHeight(20);
                    $sheet->getStyle("C$b:E$b")
                        ->getAlignment()
                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $sheet->setCellValue("A$b", "Total sucursal");
            $sheet->getStyle("A$b")->getFont()->setBold(true);

            $sheet->setCellValue("E$b", $ganancia);

            $sheet->getStyle("E$b")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
            $sheet->getStyle("E$b")->getFont()->setBold(true);

            $gananciaT = $gananciaT + $ganancia;

            $b = $b+2;

            $a = $b;

        endforeach;

        $sheet->getStyle("A$b:E$b")
                    ->getFill()
                    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setRGB('E0EAF1');
                $sheet->getRowDimension("$b")->setRowHeight(20);
                $sheet->getStyle("C$b:E$b")
                    ->getAlignment()
                    ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

        $sheet->setCellValue("A$b", "Total empresa");
        $sheet->getStyle("A$b")->getFont()->setBold(true);

        $sheet->setCellValue("E$b", $gananciaT);

        $sheet->getStyle("E$b")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
        $sheet->getStyle("E$b")->getFont()->setBold(true);

        // Salida
        header( "Content-type: application/vnd.ms-excel; charset=UTF-8" );
        $nombreArchivo = 'Detalle Pacientes ('.date('d-m-Y').')';
        header("Content-Disposition: attachment; filename=\"$nombreArchivo.xls\"");
        header("Cache-Control: max-age=0");
        // Genera Excel
        $writer = PHPExcel_IOFactory::createWriter($this->phpexcel, "Excel5");
        // Escribir
        $writer->save('php://output');

        exit;
    }

    function exportarExcel2($objeto = array())
    {
        $this->load->library('PHPExcel');
        $this->phpexcel->getProperties()
            ->setTitle("Reporte")
            ->setDescription("Detalle de profesionales y pacientes");
        // Setiar la solapa que queda actia al abrir el excel
        $this->phpexcel->setActiveSheetIndex(0)->mergeCells('A1:E1');
        // Solapa excel para trabajar con PHP
        $sheet = $this->phpexcel->getActiveSheet();
        $sheet->setTitle("Detalle");
        $sheet->getRowDimension('1')->setRowHeight(73);        
        $path = $_SERVER['DOCUMENT_ROOT'].'/assets/admin/img/title.png';
        
        if (file_exists($path)) {
            $objDrawing = new PHPExcel_Worksheet_Drawing();
            $objDrawing->setName('Aeir system');
            $objDrawing->setDescription('Aeir system');
            //Path to signature .jpg file
            $objDrawing->setPath($path);
            $objDrawing->setOffsetX(8);                     //setOffsetX works properly
            $objDrawing->setCoordinates('A1');             //set image to cell E38
            $objDrawing->setHeight(90);                     //signature height  
            $objDrawing->setWorksheet($sheet);  //save      
        }

        $a = 2;
        $b = 2;
        $gananciaT = 0;

        foreach($this->obtenerSucursalesDeEmpresa($objeto) as $sucursal):
            
            $sheet->getRowDimension('$b')->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Sucursal: '.$sucursal->sucursal_name);
            $sheet->getStyle('A'.$b)->getFont()->setBold(true);
            $sheet->mergeCells("A".$b.":"."E".$b);
            $sheet->getStyle("A".$b.":"."E".$b)
                        ->getAlignment()
                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

            $a++;
            $b++;

            $sheet->getRowDimension('$b')->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Fecha desde: '.date('d/m/Y', strtotime($objeto['fecha_desde'])));
            $sheet->getStyle('A'.$b)->getFont()->setBold(true);
            $sheet->mergeCells("A".$b.":"."E".$b);

            $a++;
            $b++;

            $sheet->getRowDimension('$b')->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Fecha hasta: '.date('d/m/Y', strtotime($objeto['fecha_hasta'])));
            $sheet->getStyle('A'.$b)->getFont()->setBold(true);
            $sheet->mergeCells("A".$b.":"."E".$b);

            $a++;
            $b++;

            $sheet->getRowDimension($b)->setRowHeight(20);
            $sheet->getColumnDimension('A')->setWidth(40);
            $sheet->setCellValue('A'.$b, 'Profesionales');
            $sheet->getColumnDimension('B')->setWidth(40);
            $sheet->setCellValue('B'.$b, 'Pacientes auditados');
            $sheet->getColumnDimension('C')->setWidth(20);
            $sheet->setCellValue('C'.$b, 'Importe por visita');
            $sheet->getColumnDimension('D')->setWidth(15);
            $sheet->setCellValue('D'.$b, 'Observaciones');
            $sheet->getStyle("A".$b.":"."D".$b)
                ->getFill()
                ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
                ->getStartColor()
                ->setRGB('e5e5e5');
            $sheet->getStyle("A".$b.":"."D".$b)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER)
                ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
            $sheet->getStyle("A:E")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

            $a++;
            $b++;
            $ganancia = 0;

            $objeto['sucursal'] = $sucursal->sucursal;

            foreach($this->obtenerProfesionalesUnicos($objeto) as $profesional):
                $objetoVerif = array(
                    'idProfesional' => $profesional->idProfesional,
                    'fecha_desde' => $objeto['fecha_desde'],
                    'fecha_hasta' => $objeto['fecha_hasta']
                );


                $objetoPacientesPorProfesional = array(
                    'idProfesional' => $profesional->idProfesional
                );
                if($this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) != NULL && $this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) != '') {
                    $honorarios = 0;
                    $sesionesT = 0;
                    $honorariosT = 0;
                    $sheet->getRowDimension("$a")->setRowHeight(20);
                    $sheet->setCellValue("A$a", $profesional->nombreProfesional);
                    $objetoPacientesPorProfesional = array(
                        'idProfesional' => $profesional->idProfesional
                    );
                    
                    foreach ($this->obtenerPacientesPorProfesional($objetoPacientesPorProfesional) as $union):
                        foreach ($this->obtenerPacientes($objeto) as $paciente):
                            if ($union->idPaciente == $paciente->idPaciente && $union->idProfesional == $profesional->idProfesional):

                                $objetoCant = array(
                                    'idProfesional_Paciente' => $union->idProfesional_Paciente,
                                    'fecha_desde' => $objeto['fecha_desde'],
                                    'fecha_hasta' => $objeto['fecha_hasta']
                                );

                                $cant = $this->obtenerCantVisitas($objetoCant);

                                $sesiones = $cant['cantidad']['0']->sesiones;

                                if($sesiones > 0):

                                    $sheet->setCellValue("B$b", $paciente->nombrePaciente);
                                    $honorarios = 0;
                                    
                                    $hon = $this->obtenerSumaHonorarios($objetoCant);

                                    $honorarios += $hon['honorarios']['0']->honorarios;
                                    $honorariosT += $honorarios;
                                    
                                    $observaciones = '';
                                    $observacionesD = $this->obtenerObservaciones($objetoCant);
                                
									if ( isset( $observacionesD['observaciones'] ) && !empty( $observacionesD['observaciones'] ) )
									{
										$fo = true;
										
										foreach ( $observacionesD['observaciones'] as $o )
										{
											if ( !$fo )
												$observaciones .= "\n";
											
											$observaciones .= $o->observaciones; $fo = false;
										}
									}
									
                                    $sheet->setCellValue("C$b", $union->honorarios);
									$sheet->getStyle("C$b")->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
                    
                                    $sheet->getRowDimension("$b")->setRowHeight(20);
                                    $sheet->setCellValue("D$b", $observaciones);
                                    $sheet->getStyle("C$b:D$b")
                                        ->getAlignment()
                                        ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

                                    $b++;
                                endif;
                            endif;
                        endforeach;
                    endforeach;

                    $a = $b;
                }

            endforeach;

            $b++;

            $a = $b;

        endforeach;

        // Salida
        header( "Content-type: application/vnd.ms-excel; charset=UTF-8" );
        $nombreArchivo = 'Detalle Pacientes ('.date('d-m-Y').')';
        header("Content-Disposition: attachment; filename=\"$nombreArchivo.xls\"");
        header("Cache-Control: max-age=0");
        // Genera Excel
        $writer = PHPExcel_IOFactory::createWriter($this->phpexcel, "Excel5");
        // Escribir
        $writer->save('php://output');

        exit;
    }
}
