<?php

class profesionales_model extends CI_Model
{
    private $tabla = 'profesionales';
    private $id = 'id';
    private $busqueda = 'apellidoynombre';
    private $order = array('apellidoynombre');
        private $campos = array(
            'apellidoynombre' => 'Apellido y Nombre',            
            //'especialidad' => 'Especialidad',
            'celulares' => 'Celular/es',
            //'usuario' => 'Usuario',            
            'habilitado' => 'Habilitado'
        );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        $this->db->select($this->tabla.'.*, profesionales.apellidoynombre as nombreCompleto, especialidades.nombre as especialidad, empresas.razon_social as nombreEmpresa, empresas_sucursales.nombre as nombreSucursal');
        $this->db->join('especialidades', 'especialidades.id = '.$this->tabla.'.idEspecialidad', 'left');
        $this->db->join('empresas', 'empresas.id = '.$this->tabla.'.empresa', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = '.$this->tabla.'.sucursal', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['idEspecialidad'])) $this->db->where($this->tabla . '.idEspecialidad', $objeto['idEspecialidad']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        if (isset($objeto['email'])) $this->db->where($this->tabla . '.email', $objeto['email']);
        if (isset($objeto['usuario'])) $this->db->where($this->tabla . '.usuario', $objeto['usuario']);
        if (isset($objeto['password'])) $this->db->where($this->tabla . '.password', $objeto['password']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        if (isset($objeto['asignado'])) $this->db->where_not_in($this->tabla . '.' . $this->id, $objeto['asignado']);
        if (isset($objeto['idLocalidad'])): 
            $this->db->join('profesionales_localidades', 'profesionales_localidades.idProfesional = '.$this->tabla.'.id', 'left');
            $this->db->where('profesionales_localidades.idLocalidad', $objeto['idLocalidad']);
        endif;
        /* - limit / offset - */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
            
        /* - order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Join -  */
        $this->db->join('especialidades', 'especialidades.id = '.$this->tabla.'.idEspecialidad', 'left');
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        if (isset($objeto['usuario'])) $this->db->where($this->tabla . '.usuario', $objeto['usuario']);
        if (isset($objeto['password'])) $this->db->where($this->tabla . '.password', $objeto['password']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        if (isset($objeto['asignado'])) $this->db->where_not_in($this->tabla . '.' . $this->id, $objeto['asignado']);
        if (isset($objeto['idLocalidad'])): 
            $this->db->join('profesionales_localidades', 'profesionales_localidades.idProfesional = '.$this->tabla.'.id', 'left');
            $this->db->where('profesionales_localidades.idLocalidad', $objeto['idLocalidad']);
        endif;
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function exists( $name, $company )
    {
		return $this->db->get_var('SELECT id FROM ' . $this->tabla . ' WHERE usuario = ? AND empresa = ? LIMIT 1', array( $name, $company ) );
	}
    
    function upsert($object)
    {
		if ( $id = $this->exists( $object['usuario'], $object['empresa'] ) )
		{
			unset($object['password']);
			unset($object['observaciones']);
			$this->update( $id, $object );
			
			return $id;
		}
		else
		{
			return $this->save( $object );
		}
	}

    function delete($elementos)
    {
        $objeto = array("habilitado" => 0);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function restore($elementos)
    {
        $objeto = array("habilitado" => 1);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function deletePacientesAsignados($elementos)
    {
        $objeto = array('estado' => 0);
        $this->db->where_in('idProfesional', $elementos);
        $this->db->update('profesionales_pacientes', $objeto);
        //$this->db->delete($this->tabla);
    }

    function restorePacientesAsignados($elementos)
    {
        $objeto = array('estado' => 1);
        $this->db->where_in('idProfesional', $elementos);
        $this->db->update('profesionales_pacientes', $objeto);
        //$this->db->delete($this->tabla);
    }

    function deleteEspecialidadYprofesional($elementos)
    {
        $objeto = array('habilitado' => 0);
        $this->db->where_in('idEspecialidad', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }
    
    /* - Sub ABM - */
    function savePaciente($objeto)
    {
        $this->db->insert('profesionales_pacientes', $objeto);
        return $this->db->insert_id();
    }

    function sub_update($objeto)
    {
        $this->db->where('id', $objeto['id']);
        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();
    }

    function getPaciente($objeto = array())
    {
        $this->db->select('profesionales_pacientes.*, localidades.id as idLocalidad');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('localidades', 'localidades.id = pacientes.idLocalidad', 'left');
        $this->db->where('profesionales_pacientes.id', $objeto['id']);
        //$this->db->order_by("apellido", "asc");
        $ret['rows'] = $this->db->get('profesionales_pacientes')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function getAllList($objeto = array())
    {
        $this->db->select('profesionales_pacientes.*, pacientes.telefono, pacientes.direccion, pacientes.ref_direccion, localidades.nombre as localidad, pacientes.nombreyapellido as paciente, pacientes.latitud as latitud, pacientes.longitud as longitud, pacientes.auditado');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('localidades', 'localidades.id = pacientes.idLocalidad', 'left');
        $this->db->where('profesionales_pacientes.idProfesional', $objeto['idProfesional']);
        if (isset($objeto['idProfesional'])) $this->db->where('profesionales_pacientes.idProfesional', $objeto['idProfesional']);
        if (isset($objeto['idPaciente'])) $this->db->where('profesionales_pacientes.idPaciente', $objeto['idPaciente']);
        if (isset($objeto['empresa'])) $this->db->where('pacientes.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('pacientes.sucursal', $objeto['sucursal']);
        if (isset($objeto['estado'])) $this->db->where_in('profesionales_pacientes.estado', $objeto['estado']);
        if (isset($objeto['filtro'])) $this->db->where('profesionales_pacientes.id != ' . $objeto['filtro']);
        $this->db->order_by("pacientes.nombreyapellido", "asc");
        $ret['rows'] = $this->db->get('profesionales_pacientes')->result();
        //echo $this->db->last_query();

        return $ret;
    }

    function visitaActiva($objeto = array())
    {
        $this->db->select('pacientes.id as idPaciente, profesionales.id as idProfesional, profesionales_pacientes_visitas.id as idVisita, profesionales_pacientes_visitas.fecha_llego as inicio, profesionales_pacientes.duracion_sesion as duracion');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        if (isset($objeto['idProfesional'])) $this->db->where('profesionales_pacientes.idProfesional', $objeto['idProfesional']);
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NULL');
        $this->db->order_by("pacientes.nombreyapellido", "asc");
        $ret['rows'] = $this->db->get('profesionales_pacientes_visitas')->result();

        return $ret;
    }

    function deletePaciente($elementos, $idProfesional)
    {
        $objeto = array('estado' => '0');
        $this->db->where_in('id', $elementos);
        $this->db->where('idProfesional', $idProfesional);

        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();

        //$this->db->delete('profesionales_pacientes');
    }

    function restorePaciente($elementos, $idProfesional)
    {
        $objeto = array('estado' => '1');
        $this->db->where_in('id', $elementos);
        $this->db->where('idProfesional', $idProfesional);
        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();

        //$this->db->delete('profesionales_pacientes');
    }

    function saveVisita($objeto)
    {
        $this->db->insert('profesionales_pacientes_visitas', $objeto);
        return $this->db->insert_id();
    }

    function updateVisita($id, $objeto = array())
    {
        $this->db->where('id', $id);
        $this->db->update('profesionales_pacientes_visitas', $objeto);
        return $this->db->affected_rows();
    }

    function estadoVisita($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('profesionales_pacientes_visitas')->result();
    }

    function controlVisita($idProfesional)
    {
        $this->db->select('profesionales_pacientes_visitas.*, profesionales_pacientes.duracion_sesion as duracion, pacientes.id as idPaciente, pacientes.latitud, pacientes.longitud');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = profesionales_pacientes_visitas.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->where('profesionales_pacientes.idProfesional', $idProfesional);
        $this->db->where('profesionales_pacientes_visitas.fecha_mevoy IS NULL');
        $this->db->limit('1');
        return $this->db->get('profesionales_pacientes_visitas')->result();
    }

    function saveEquiposVisita($objeto)
    {
        $this->db->insert('visitas_equipos', $objeto);
        return $this->db->insert_id();
    }

    function getProfesionalesXLocalidades($id)
    {
        $select = $this->db->select('localidades.id, localidades.nombre, profesionales_localidades.idProfesional, profesionales_localidades.idLocalidad')->from('profesionales_localidades');
        $this->db->join('localidades', 'localidades.id = profesionales_localidades.idLocalidad', 'left');
        $this->db->where('idProfesional', $id);
        $this->db->order_by('localidades.nombre');
        return $select->get()->result();
    }

    function updateLocalidades($objetos)
    {
        $this->deleteLocalidades($objetos['idProfesional']);
        if ($objetos['idLocalidad'] != NULL):
            foreach ($objetos['idLocalidad'] as $localidad):
                $objeto = array('idProfesional' => $objetos['idProfesional'], 'idLocalidad' => $localidad);
                $this->db->insert('profesionales_localidades', $objeto);
            endforeach;
        endif;
    }

    function deleteLocalidades($elementos)
    {
        $this->db->where_in('idProfesional', $elementos);
        $this->db->delete('profesionales_localidades');
    }

    function distanciaGeodesica($lat1, $long1, $lat2, $long2){

        $degtorad = 0.01745329;
        $radtodeg = 57.29577951;

        $dlong = ($long1 - $long2);
        $dvalue = (sin($lat1 * $degtorad) * sin($lat2 * $degtorad))
            + (cos($lat1 * $degtorad) * cos($lat2 * $degtorad)
                * cos($dlong * $degtorad));

        $dd = acos($dvalue) * $radtodeg;

        $miles = ($dd * 69.16);
        $km = ($dd * 111.302);

        return round(($km  * 1000), 2);
    }

    function generaPass()
    {
        $cadena = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
        $longitudCadena=strlen($cadena);

        $pass = "";
        $longitudPass=10;

        for($i=1 ; $i<=$longitudPass ; $i++){
            $pos=rand(0,$longitudCadena-1);
            $pass .= substr($cadena,$pos,1);
        }
        return $pass;
    }

    function guardarSesion($objeto = array())
    {
        $this->db->insert('profesionales_sesiones', $objeto);
        return $this->db->insert_id();
    }

    function verificarSesion($idProfesional)
    {
        $this->db->where('idProfesional', $idProfesional);
        return $this->db->get('profesionales_sesiones')->result();
    }

    function verificarToken($idToken)
    {
        $this->db->select('profesionales_sesiones.idProfesional, profesionales.empresa, profesionales.sucursal, profesionales.password');
        $this->db->join('profesionales', 'profesionales.id = profesionales_sesiones.idProfesional', 'left');
        $this->db->join('empresas', 'empresas.id = profesionales.empresa', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = profesionales.sucursal', 'left');
        $this->db->where('idToken', $idToken);
        $this->db->limit('1');
        $row = $this->db->get('profesionales_sesiones')->result();
        return $row;
    }

    function eliminarSesion($idProfesional)
    {
        $this->db->where('idProfesional', $idProfesional);
        $this->db->delete('profesionales_sesiones');
    }
    
    function getPacientesEquipos( $idProfesional )
    {
		$q = $this->db->query(
			'SELECT pe.*
			 FROM pacientes_equipos AS pe
			 INNER JOIN pacientes AS p ON pe.idPaciente = p.id
			 INNER JOIN profesionales_pacientes AS pp ON pp.idPaciente = p.id
			 WHERE pp.idProfesional = ?',
			 array( $idProfesional )
		);
		
		return $q->num_rows() ? $q->result() : array();
	}

	function deletePacientes($idProfesional)
	{
		$this->db->where('idProfesional', $idProfesional);
		$this->db->delete('profesionales_pacientes');
	}
	
	function updatePacientes($objetos)
	{
		$this->deletePacientes($objetos['idProfesional']);
		if ($objetos['idPaciente'] != NULL)
		{
			foreach ($objetos['idPaciente'] as $paciente)
			{
				$objeto = array('idProfesional' => $objetos['idProfesional'], 'idPaciente' => $paciente, 'estado' => 1, 'creado' => date("Y-m-d H:i:s", time()), 'honorarios' => 120, 'visitasxmes' => 1 );
				$this->db->insert('profesionales_pacientes', $objeto);
			}
		}
	}
}
