<?php

class pacientes_model extends CI_Model
{
    private $tabla = 'pacientes';
    private $id = 'id';
    private $busqueda1 = 'nombreyapellido';
    private $busqueda2 = 'direccion';
    private $order = array('nombreyapellido');
    private $campos = array(
        'nombreyapellido' => 'Apellido y Nombre',
        'direccion' => 'Domicilio',
        'telefono' => 'Teléfono',
        'id' => 'Equipos en domicilio',
        'localidad' => 'Localidad'
    );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        $this->db->select($this->tabla.'.*, pacientes.nombreyapellido as nombreCompleto, localidades.nombre as localidad');
        $this->db->join('localidades', 'localidades.id = '.$this->tabla.'.idLocalidad', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda1, $objeto['search']);
        if (isset($objeto['search'])) $this->db->or_like($this->tabla . '.' . $this->busqueda2, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        if (isset($objeto['habilitado'])) $this->db->where_in($this->tabla . '.habilitado', $objeto['habilitado']);
        if (isset($objeto['idLocalidad'])) $this->db->where_in($this->tabla . '.idLocalidad', $objeto['idLocalidad']);
        if (isset($objeto['asignado'])) $this->db->where_not_in($this->tabla . '.' . $this->id, $objeto['asignado']);
        /* - limit / offset - */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
        
        /* - order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Join -  */
        $this->db->join('localidades', 'localidades.id = '.$this->tabla.'.idLocalidad', 'left');
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda1, $objeto['search']);
        if (isset($objeto['search'])) $this->db->or_like($this->tabla . '.' . $this->busqueda2, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla . '.sucursal', $objeto['sucursal']);
        if (isset($objeto['habilitado'])) $this->db->where_in($this->tabla . '.habilitado', $objeto['habilitado']);
        if (isset($objeto['idLocalidad'])) $this->db->where_in($this->tabla . '.idLocalidad', $objeto['idLocalidad']);
        if (isset($objeto['asignado'])) $this->db->where_not_in($this->tabla . '.' . $this->id, $objeto['asignado']);
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function exists( $idPaciente, $company )
    {
		return $this->db->get_var('SELECT id FROM ' . $this->tabla . ' WHERE idPaciente = ? AND empresa = ? LIMIT 1', array( $idPaciente, $company ) );
	}
    
    function upsert($object)
    {
		if ( $id = $this->exists( $object['idPaciente'], $object['empresa'] ) )
		{
			$this->update( $id, $object );
			
			return $id;
		}
		else
		{
			return $this->save( $object );
		}
	}
	
	function resetSucursal( $sucursal, $habilitado = 0 )
	{
        $this->db->where('sucursal', $sucursal);
        $this->db->update($this->tabla, array( 'habilitado' => $habilitado ) );
	}

    function delete($elementos)
    {
        $objeto = array("habilitado" => 0);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //echo $this->db->last_query();
        //$this->db->delete($this->tabla);
    }

    function restore($elementos)
    {
        $objeto = array("habilitado" => 1);
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    function deleteProfesionalesAsignados($elementos)
    {
        $objeto = array('estado' => 0);
        $this->db->where_in('idPaciente', $elementos);
        $this->db->update('profesionales_pacientes', $objeto);
        //$this->db->delete($this->tabla);
    }

    function deshabilitarProfesionalesAsignados($elementos)
    {
        $objeto = array('estado' => 2);
        $this->db->where_in('idPaciente', $elementos);
        $this->db->update('profesionales_pacientes', $objeto);
        //$this->db->delete($this->tabla);
    }

    function restoreProfesionalesAsignados($elementos)
    {
        $objeto = array('estado' => 1);
        $this->db->where_in('idPaciente', $elementos);
        $this->db->update('profesionales_pacientes', $objeto);
        //$this->db->delete($this->tabla);
    }

    function deleteLocalidadYpacientes($elementos)
    {
        $objeto = array('habilitado' => 0);
        $this->db->where_in('idLocalidad', $elementos);
        $this->db->update($this->tabla, $objeto);
        //$this->db->delete($this->tabla);
    }

    /* - Sub ABM - */
    function saveProfesional($objeto)
    {
        $this->db->insert('profesionales_pacientes', $objeto);
        return $this->db->insert_id();
    }

    function sub_update($objeto)
    {
        $this->db->where('id', $objeto['id']);
        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();
    }

    function getProfesional($objeto = array())
    {
        $this->db->select('profesionales_pacientes.*, especialidades.id as idEspecialidad');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('especialidades', 'especialidades.id = profesionales.idEspecialidad', 'left');
        $this->db->where('profesionales_pacientes.id', $objeto['id']);
        $this->db->order_by("profesionales_pacientes.id", "asc");
        $ret['rows'] = $this->db->get('profesionales_pacientes')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function getAllList($objeto = array())
    {
        $this->db->select('profesionales_pacientes.*, profesionales.apellidoynombre as profesional');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->where('profesionales_pacientes.idPaciente', $objeto['idPaciente']);
        if (isset($objeto['empresa'])) $this->db->where('profesionales.empresa', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('profesionales.sucursal', $objeto['sucursal']);
        if (isset($objeto['estado'])) $this->db->where_in('profesionales_pacientes.estado', $objeto['estado']);
        if (isset($objeto['filtro'])) $this->db->where('profesionales_pacientes.id != ' . $objeto['filtro']);
        $this->db->order_by("profesionales.apellidoynombre", "asc");
        $ret['rows'] = $this->db->get('profesionales_pacientes')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function deleteProfesional($elementos, $idPaciente)
    {
        $objeto = array('estado' => '0');
        $this->db->where_in('id', $elementos);
        $this->db->where('idPaciente', $idPaciente);
        
        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();

        //$this->db->delete('profesionales_pacientes');
    }

    function restoreProfesional($elementos, $idPaciente)
    {
        $objeto = array('estado' => '1');
        $this->db->where_in('id', $elementos);
        $this->db->where('idPaciente', $idPaciente);
        $this->db->update('profesionales_pacientes', $objeto);
        return $this->db->affected_rows();

        //$this->db->delete('profesionales_pacientes');
    }

    function getAllPacientesXEquipos()
    {
        $select = $this->db->select('equipos.id, equipos.nombre, pacientes_equipos.idPaciente, pacientes_equipos.idEquipo')->from('pacientes_equipos');
        $this->db->join('equipos', 'equipos.id = pacientes_equipos.idEquipo', 'left');
        $this->db->order_by('equipos.nombre');
        return $select->get()->result();
    }

    function getPacientesXEquipos($id)
    {
        $select = $this->db->select('equipos.id, equipos.nombre, pacientes_equipos.idPaciente, pacientes_equipos.idEquipo')->from('pacientes_equipos');
        $this->db->join('equipos', 'equipos.id = pacientes_equipos.idEquipo', 'left');
        $this->db->where('idPaciente', $id);
        $this->db->order_by('equipos.nombre');
        return $select->get()->result();
    }

    function updateEquipos($objetos)
    {
        $this->deleteEquipos($objetos['idPaciente']);
        if ($objetos['idEquipo'] != NULL):
            foreach ($objetos['idEquipo'] as $equipo):
                $objeto = array('idPaciente' => $objetos['idPaciente'], 'idEquipo' => $equipo);
                $this->db->insert('pacientes_equipos', $objeto);
            endforeach;
        endif;
    }

    function deleteEquipos($elementos)
    {
        $this->db->where_in('idPaciente', $elementos);
        $this->db->delete('pacientes_equipos');
    }
    
    function disable( $empresa, $sucursal )
    {
		$this->db->query('UPDATE pacientes SET habilitado = 0 WHERE empresa = ? AND sucursal = ?', array( $empresa, $sucursal ) );
	}
}