<?php

class empresas_model extends CI_Model
{
    private $tabla = 'empresas';
    private $id = 'id';
    private $busqueda = 'nombre';
    private $order = array('nombre');
    private $campos = array(
        'nombre' => 'Nombre',
        'razon_social' => 'Raz&oacute;n social',
        'cuit' => 'C.U.I.T.',
        'localidad' => 'Localidad',
        'telefono' => 'Tel&eacute;fono',
        'habilitado' => 'Habilitado'
    );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla.'.sucursal', $objeto['sucursal']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Limit / Offset - */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
            
        /* - Order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['sucursal'])) $this->db->where($this->tabla.'.sucursal', $objeto['sucursal']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function delete($elementos)
    {
        $objeto = array("habilitado" => 0);
        // Elimina empresas seleccionadas
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);

        //Elimina sucursales de las empresas seleccionadas
        $this->db->where_in('empresa', $elementos);
        $this->db->update('empresas_sucursales', $objeto);

        //$this->db->delete($this->tabla);
    }

    function restore($elementos)
    {
        $objeto = array("habilitado" => 1);
        // Elimina empresas seleccionadas
        $this->db->where_in($this->id, $elementos);
        $this->db->update($this->tabla, $objeto);

        //Elimina sucursales de las empresas seleccionadas
        $this->db->where_in('empresa', $elementos);
        $this->db->update('empresas_sucursales', $objeto);

        //$this->db->delete($this->tabla);
    }

    /* - Sub ABM - */
    function saveSucursal($objeto)
    {
        $this->db->insert('empresas_sucursales', $objeto);
        return $this->db->insert_id();
    }

    function sub_update($objeto)
    {
        $this->db->where('id', $objeto['id']);
        $this->db->update('empresas_sucursales', $objeto);
        return $this->db->affected_rows();
    }

    function existsSucursal( $name, $company )
    {
		return $this->db->get_var('SELECT id FROM empresas_sucursales WHERE nombre = ? AND empresa = ? LIMIT 1', array( $name, $company ) );
	}
    
    function upsertSucursal($object)
    {
		if ( $id = $this->existsSucursal( $object['nombre'], $object['empresa'] ) )
		{
			$object['id'] = $id;
			
			$this->sub_update( $object );
			
			return $id;
		}
		else
		{
			return $this->saveSucursal( $object );
		}
	}
	
    function getSucursal($objeto = array())
    {
        $this->db->where('id', $objeto['id']);
        $this->db->order_by("id", "asc");
        $ret['rows'] = $this->db->get('empresas_sucursales')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function getAllList($objeto = array())
    {
        $this->db->where('empresas_sucursales.empresa', $objeto['empresa']);
        if (isset($objeto['habilitado'])) $this->db->where('empresas_sucursales.habilitado', $objeto['habilitado']);
        $this->db->order_by("empresas_sucursales.id", "asc");
        $ret['rows'] = $this->db->get('empresas_sucursales')->result();
        //echo $this->db->last_query();
        return $ret;
    }

    function deleteSucursal($elementos, $empresa)
    {
        $objeto = array('habilitado' => 0);
        $this->db->where_in('id', $elementos);
        $this->db->where('empresa', $empresa);
        $this->db->update('empresas_sucursales', $objeto);
        //$this->db->delete('empresas_sucursales');
    }

    function restoreSucursal($elementos, $empresa)
    {
        $objeto = array('habilitado' => 1);
        $this->db->where_in('id', $elementos);
        $this->db->where('empresa', $empresa);
        $this->db->update('empresas_sucursales', $objeto);
        //$this->db->delete('empresas_sucursales');
    }
}