<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Reporte extends MY_Controller
{
    private $dir = 'reporte';
    private $nom = 'Reporte';
    private $dir1 = 'Reporte';
    private $dir2 = 'Reporte';

    private $user_reg = '';

    function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('ubicacion') != $this->dir):
            $array_items = array('per_page' => NULL, 'sort_order' => NULL, 'sort_by' => NULL,);
            $this->session->unset_userdata($array_items);
            $this->session->set_userdata('ubicacion', $this->dir);
        endif;

        $this->user_reg = $this->session->userdata('user_reg');

        $this->load->model($this->dir . '_model', 'modelo', TRUE);
        $this->data['dir'] = $this->dir;
        $this->data['nom'] = $this->nom;
        $this->data['dir1'] = $this->dir1;
        $this->data['dir2'] = $this->dir2;
    }

    function index()
    {
        $this->data['action'] = site_url('admin/' . $this->dir . '/update');

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function select_profesionales()
    {
        /* - Filtros - */
        $sql['empresa'] = $this->user_reg['company'];
        if($this->user_reg['sucursal'] != "Master"):
            $sql['sucursal'] = $this->user_reg['sucursal'];
        endif;
        $sql['sort_order'] = 'asc';
        $sql['sort_by'] = 'apellido';
        $sql['habilitado'] = 1;

        $this->load->model('admin/profesionales_model', '', TRUE);
        $profesionales = $this->profesionales_model->getAll($sql);
        $this->data['profesionales'] = $profesionales['rows'];

        $this->load->view('admin/reporte/select_profesionales', $this->data);
    }

    function select_pacientes()
    {
        /* - Filtros - */
        $sql['empresa'] = $this->user_reg['company'];
        if($this->user_reg['sucursal'] != "Master"):
            $sql['sucursal'] = $this->user_reg['sucursal'];
        endif;
        $sql['sort_order'] = 'asc';
        $sql['sort_by'] = 'nombreyapellido';
        $sql['habilitado'] = 1;

        $this->load->model('admin/pacientes_model', '', TRUE);
        $pacientes = $this->pacientes_model->getAll($sql);
        $this->data['pacientes'] = $pacientes['rows'];

        $this->load->view('admin/reporte/select_pacientes', $this->data);
    }

    function select_localidades()
    {
        /* - Filtros - */
        $sql['empresa'] = $this->user_reg['company'];
        $sql['sort_order'] = 'asc';
        $sql['sort_by'] = 'nombre';
        $sql['habilitado'] = 1;

        $this->load->model('admin/localidades_model', '', TRUE);
        $localidades = $this->localidades_model->getAll($sql);
        $this->data['localidades'] = $localidades['rows'];

        $this->load->view('admin/reporte/select_localidades', $this->data);
    }

    function edit()
    {
        $this->template->title($this->data['nombre'] . ' :: Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function update()
    {
		$post = $this->input->get();
		
        if ( !isset($post['opcion']) ):

            $this->data['action'] = site_url('admin/' . $this->dir . '/update');

            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Errores !</h4>" . validation_errors() . "</div>";

            $this->template->title($this->data['nombre'] . ' :: Administración');

            $this->template->build('admin/' . $this->dir . '/edit', $this->data);

        else:

            $opcion = $post['opcion'];

            if($this->user_reg['sucursal'] != "Master"):
                $objeto = array(
                    'empresa' => $this->user_reg['company'],
                    'sucursal' => $this->user_reg['sucursal'],
                    'todas' => 'no',
                    'fecha_desde' => $post['fecha_desde'],
                    'fecha_hasta' => $post['fecha_hasta'],
                    'notnull' => 1
                );
            else:
                $objeto = array(
                    'empresa' => $this->user_reg['company'],
                    'todas' => 'si',
                    'fecha_desde' => $post['fecha_desde'],
                    'fecha_hasta' => $post['fecha_hasta'],
                    'notnull' => 1
                );
            endif;

            if ($opcion == 1): //Profesionales

                $objeto['idProfesional'] = $post['idProfesional'];

                $this->data['fields'] = array(
                    'nombrePaciente' => 'Paciente',
                    'localidad' => 'Localidad',
                    'cantidad' => 'Cantidad'
                );

                $reporte = $this->modelo->reporteProfesionales($objeto);
                $this->data['rows'] = $reporte['rows'];

                $cantidad = $this->modelo->cantPacientesXProfesional($objeto);
                $this->data['cantidad'] = $cantidad['cantidad']['0']->cantidad;

                $this->data['fecha_desde'] = $post['fecha_desde'];
                $this->data['fecha_hasta'] = $post['fecha_hasta'];

                $this->template->title($this->data['nombre'], 'Administración');
                $this->template->build('admin/' . $this->dir . '/reporteProfesional', $this->data);

            elseif($opcion == 2):

                $objeto['idPaciente'] = $post['idPaciente'];

                $this->data['fields'] = array(
                    'nombreProfesional' => 'Profesional',
                    'especialidad' => 'Especialidad',
                    'cantidad' => 'Cantidad'
                );

                $reporte = $this->modelo->reportePacientes($objeto);
                $this->data['rows'] = $reporte['rows'];

                $this->data['fecha_desde'] = $post['fecha_desde'];
                $this->data['fecha_hasta'] = $post['fecha_hasta'];

                $this->template->title($this->data['nombre'], 'Administración');
                $this->template->build('admin/' . $this->dir . '/reportePaciente', $this->data);

            elseif($opcion == 3):

                $objeto['idLocalidad'] = $post['idLocalidad'];

                $this->data['fields'] = array(                    
                    'nombrePaciente' => 'Paciente',
                    'nombreProfesional' => 'Profesional',
                    'especialidad' => 'Especialidad',
                    'cantidad' => 'Cantidad'
                );

                $reporte = $this->modelo->reporteLocalidades($objeto);
                $this->data['rows'] = $reporte['rows'];

                $this->data['fecha_desde'] = $post['fecha_desde'];
                $this->data['fecha_hasta'] = $post['fecha_hasta'];

                $this->template->title($this->data['nombre'], 'Administración');
                $this->template->build('admin/' . $this->dir . '/reporteLocalidad', $this->data);
            elseif($opcion == 4): //Exportar
				$objeto['user_id'] = $this->user_reg['id'];
                $this->modelo->exportarExcel2($objeto);
            endif;
        endif;
    }

    function delete()
    {
        $this->modelo->delete($this->input->post('ele'));
        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/index', 'refresh');
    }

    function detalleProfesional($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'id' => 'Equipo/os',
            'observaciones' => 'Observaciones',
            'cantidad' => 'Duración'
        );

        if($this->user_reg['sucursal'] != "Master"):
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'sucursal' => $this->user_reg['sucursal'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        else:
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        endif;

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $equipos = $this->modelo->obtenerEquiposXVisita($objeto);
        $this->data['equipos'] = $equipos['equipos'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detalleProfesional', $this->data);
    }

    function detallePaciente($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'id' => 'Equipo/os',
            'observaciones' => 'Observaciones',
            'cantidad' => 'Duración'
        );

        if($this->user_reg['sucursal'] != "Master"):
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'sucursal' => $this->user_reg['sucursal'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        else:
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        endif;

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $equipos = $this->modelo->obtenerEquiposXVisita($objeto);
        $this->data['equipos'] = $equipos['equipos'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detallePaciente', $this->data);
    }

    function detalleLocalidad($id, $desde = '', $hasta = '')
    {
        $this->data['fields'] = array(            
            'nombreProfesional' => 'Profesional',
            'especialidad' => 'Especialidad',
            'nombrePaciente' => 'Paciente',
            'entrada' => 'Entrada',
            'salida' => 'Salida',
            'id' => 'Equipo/os',
            'observaciones' => 'Observaciones',
            'cantidad' => 'Duración'
        );

        if($this->user_reg['sucursal'] != "Master"):
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'sucursal' => $this->user_reg['sucursal'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        else:
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'id' => $id,
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        endif;

        $detalle = $this->modelo->obtenerDetalle($objeto);
        $this->data['rows'] = $detalle['rows'];

        $equipos = $this->modelo->obtenerEquiposXVisita($objeto);
        $this->data['equipos'] = $equipos['equipos'];

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/detalleLocalidad', $this->data);
    }

    function exportarExcel($desde = null, $hasta = null)
    {
        if($this->user_reg['sucursal'] != "Master"):
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'sucursal' => $this->user_reg['sucursal'],
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        else:
            $objeto = array(
                'empresa' => $this->user_reg['company'],
                'fecha_desde' => $desde,
                'fecha_hasta' => $hasta
            );
        endif;

        $this->modelo->exportarExcel($objeto);
    }
}
