<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Profesionales extends MY_Controller
{
    private $dir = 'profesionales';
    private $nom = 'Profesionales';
    private $dir1 = 'Nuevo Profesional';
    private $dir2 = 'Editar Profesional';
    private $dir3 = 'Pacientes';
    private $dir4 = 'Editar Pacientes';

    private $user_reg = '';

    function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('ubicacion') != $this->dir):
            $array_items = array('per_page' => NULL, 'sort_order' => NULL, 'sort_by' => NULL,);
            $this->session->unset_userdata($array_items);
            $this->session->set_userdata('ubicacion', $this->dir);
        endif;

        $this->user_reg = $this->session->userdata('user_reg');

        $this->load->model($this->dir . '_model', 'modelo', TRUE);
        $this->data['dir'] = $this->dir;
        $this->data['nom'] = $this->nom;
        $this->data['dir1'] = $this->dir1;
        $this->data['dir2'] = $this->dir2;
        $this->data['dir3'] = $this->dir3;
        $this->data['dir4'] = $this->dir4;
    }

    function index($sort_by = 'apellidoynombre', $sort_order = 'asc', $offset = 0)
    {
        $this->load->helper('text');
        $this->load->library('pagination');
        $this->load->library('table');

        $this->data['fields'] = $this->modelo->getCampos();

        /* - search - */
        if ($this->get_search($this->dir) != '') $sql['search'] = $this->get_search($this->dir);
        /* - limit - */
        $sql['limit'] = $this->get_limit($this->dir);
        /* - sort_order - */
        $sql['sort_order'] = $this->get_sort_order($this->dir, $sort_order);
        /* - sort_by - */
        $sql['sort_by'] = $this->get_sort_by($this->dir, $sort_by);
        /* - offset - */
        $sql['offset'] = ($offset > 1) ? $offset : NULL;
        /* - Empresa y Sucursal - */
        $sql['empresa'] = ($this->user_reg['company'] != '')?$this->user_reg['company']:'';
        if($this->user_reg['sucursal'] != "Master"):
            $sql['sucursal'] = ($this->user_reg['sucursal'] != '')?$this->user_reg['sucursal']:'';
        endif;
        /* - Habilitado 1 - Activo | 0 - Eliminado */
        $sql['habilitado'] = 1;

        $results = $this->modelo->getAll($sql);

        $this->data['rows'] = $results['rows'];
        $this->data['num_results'] = $results['num_rows'];

        $config = array();
        $config['base_url'] = site_url("admin/" . $this->dir . "/index/$sort_by/$sort_order");
        $config['uri_segment'] = 5;
        $config['total_rows'] = $this->data['num_results'];
        $config['per_page'] = $sql['limit'];

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->pagination->initialize($config);
        $this->data['pagination'] = $this->pagination->create_links();
        $this->data['cur_page'] = $this->pagination->cur_page;
        $this->data['pagination_tot'] = ceil(($config['total_rows'] / $this->pagination->per_page));
        $this->data['action'] = site_url('admin/' . $this->dir . '/index');
        $this->data['search'] = $this->session->userdata($this->dir . '_search');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/list', $this->data);
    }

    function restaurar($sort_by = 'apellidoynombre', $sort_order = 'asc', $offset = 0)
    {
        $this->load->helper('text');
        $this->load->library('pagination');
        $this->load->library('table');

        $this->data['fields'] = $this->modelo->getCampos();

        /* - search - */
        if ($this->get_search($this->dir) != '') $sql['search'] = $this->get_search($this->dir);
        /* - limit - */
        $sql['limit'] = $this->get_limit($this->dir);
        /* - sort_order - */
        $sql['sort_order'] = $this->get_sort_order($this->dir, $sort_order);
        /* - sort_by - */
        $sql['sort_by'] = $this->get_sort_by($this->dir, $sort_by);
        /* - offset - */
        $sql['offset'] = ($offset > 1) ? $offset : NULL;
        /* - Empresa y Sucursal - */
        $sql['empresa'] = ($this->user_reg['company'] != '')?$this->user_reg['company']:'';
        if($this->user_reg['sucursal'] != "Master"):
            $sql['sucursal'] = ($this->user_reg['sucursal'] != '')?$this->user_reg['sucursal']:'';
        endif;
        /* - Habilitado 1 - Activo | 0 - Eliminado */
        $sql['habilitado'] = 0;

        $results = $this->modelo->getAll($sql);

        $this->data['rows'] = $results['rows'];
        $this->data['num_results'] = $results['num_rows'];

        $config = array();
        $config['base_url'] = site_url("admin/" . $this->dir . "/restaurar/$sort_by/$sort_order");
        $config['uri_segment'] = 5;
        $config['total_rows'] = $this->data['num_results'];
        $config['per_page'] = $sql['limit'];

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->pagination->initialize($config);
        $this->data['pagination'] = $this->pagination->create_links();
        $this->data['cur_page'] = $this->pagination->cur_page;
        $this->data['pagination_tot'] = ceil(($config['total_rows'] / $this->pagination->per_page));
        $this->data['action'] = site_url('admin/' . $this->dir . '/index');
        $this->data['search'] = $this->session->userdata($this->dir . '_search');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/restaurar', $this->data);
    }

    function edit($id)
    {
        $this->load->model('admin/especialidades_model', '', TRUE);
        $sqlEsp['habilitado'] = 1;
        $sqlEsp['empresa'] = $this->user_reg['company'];
        $sqlEsp['sort_order'] =  'asc';
        $sqlEsp['sort_by'] = 'nombre';
        $especialidades = $this->especialidades_model->getAll($sqlEsp);
        $this->data['especialidades'] = $especialidades['rows'];

        $this->load->model('admin/localidades_model', '', TRUE);
        $this->data['profxloc'] = $this->modelo->getProfesionalesXLocalidades($id);
        $sqlLocalidades['habilitado'] = 1;
        $sqlLocalidades['empresa'] = $this->user_reg['company'];
        $sqlLocalidades['sort_order'] =  'asc';
        $sqlLocalidades['sort_by'] = 'nombre';
        $localidades = $this->localidades_model->getAll($sqlLocalidades);
        $this->data['localidades'] = $localidades['rows'];

        if($this->user_reg['sucursal'] == "Master"):
            $this->load->model('admin/sucursales_model', '', TRUE);
            $sucursales = $this->sucursales_model->getAll($sqlLocalidades);
            $this->data['sucursales'] = $sucursales['rows'];
            $this->data['master'] = TRUE;
        endif;

        if ($id != 0):
            $sql['id'] = $id;
            $sql['empresa'] = $this->user_reg['company'];
            $results = $this->modelo->getAll($sql);
            $this->data['row'] = $results['rows'][0];
            $this->data['num_results'] = $results['num_rows'];
        endif;

        $this->data['action'] = site_url('admin/' . $this->dir . '/update');

        $this->template->title($this->data['nombre'] . ' :: Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function update()
    {
        $id = $this->input->post('id');

        /* - Campos requeridos - */
        $this->form_validation->set_rules('apellidoynombre', 'Apellido y Nombre', 'required');
        $this->form_validation->set_rules('idEspecialidad', 'Especialidad', 'required');
        $this->form_validation->set_message('is_unique', 'El %s ya está ocupado.');
        if ($id == 0):
            $this->form_validation->set_rules('usuario', 'Usuario', 'required|is_unique[profesionales.usuario]');
            $this->form_validation->set_rules('password', 'Contraseña', 'required|matches[password_confirm]');
            $this->form_validation->set_rules('password_confirm', 'Confirme Contraseñaa', 'required');
        endif;
        /* - Campos NO requeridos - */
        $this->form_validation->set_rules('email', 'E-Mail');
        $this->form_validation->set_rules('observaciones', 'Observaciones');

        if ($this->form_validation->run() == FALSE):

            $this->load->model('admin/especialidades_model', '', TRUE);
            $sql['habilitado'] = 1;
            $sql['empresa'] = $this->user_reg['company'];
            $especialidades = $this->especialidades_model->getAll($sql);
            $this->data['especialidades'] = $especialidades['rows'];

            $this->data['action'] = site_url('admin/' . $this->dir . '/update');

            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Errores !</h4>" . validation_errors() . "</div>";

            $this->template->title($this->data['nombre'] . ' :: Administración');

            $this->template->build('admin/' . $this->dir . '/edit', $this->data);

        else:

            if($this->user_reg['sucursal'] != "Master"):
                $objeto = array(
                    'empresa' => $this->user_reg['company'],
                    'sucursal' => $this->user_reg['sucursal'],
                    'apellidoynombre' => $this->input->post('apellidoynombre'),
                    'idEspecialidad' => $this->input->post('idEspecialidad'),
                    'email' => $this->input->post('email'),
                    'celulares' => $this->input->post('celulares'),
                    'usuario' => $this->input->post('usuario'),
                    'observaciones' => $this->input->post('observaciones'),
                    'honorarios' => $this->input->post('honorarios'),
                    'habilitado' => $this->input->post('habilitado')
                );
            else:
                $objeto = array(
                    'empresa' => $this->user_reg['company'],
                    'sucursal' => $this->input->post('sucursal'),
                    'apellidoynombre' => $this->input->post('apellidoynombre'),
                    'idEspecialidad' => $this->input->post('idEspecialidad'),
                    'email' => $this->input->post('email'),
                    'celulares' => $this->input->post('celulares'),
                    'usuario' => $this->input->post('usuario'),
                    'observaciones' => $this->input->post('observaciones'),
                    'honorarios' => $this->input->post('honorarios'),
                    'habilitado' => $this->input->post('habilitado')
                );
            endif;

            $objetoLocalidad = array(
                'idProfesional' => $id,
                'idLocalidad' => $this->input->post('localidades')
            );

            if ($this->input->post('password')) $objeto['password'] = md5($this->input->post('password'));

            if ($id == 0):

                $creado = date("Y-m-d H:i:s");
                $objeto['creado'] = $creado;

                $id = $this->modelo->save($objeto);

                if ($this->input->post('localidades') != FALSE) {
                    $objetoLocalidad = array(
                        'idProfesional' => $id,
                        'idLocalidad' => $this->input->post('localidades')
                    );
                    $this->modelo->updateLocalidades($objetoLocalidad);
                }

                $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Guardado</div>";
                $this->session->set_flashdata('template_msg', $this->data['message']);
                //redirect('admin/' . $this->dir . '/index', 'refresh');
                redirect('admin/' . $this->dir . '/edit/' . $id, 'refresh');
            else:

            	if($objeto['habilitado'] == 0):
            		$this->modelo->delete($id);
        			$this->modelo->deletePacientesAsignados($id);
        		elseif($objeto['habilitado'] == 1):
        			$this->modelo->restore($id);
        			$this->modelo->restorePacientesAsignados($id);
            	endif;

                $this->modelo->update($id, $objeto);

                $this->modelo->updateLocalidades($objetoLocalidad);

                $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Modificado</div>";
                $this->session->set_flashdata('template_msg', $this->data['message']);
                //redirect('admin/' . $this->dir . '/index', 'refresh');
                redirect('admin/' . $this->dir . '/edit/' . $id, 'refresh');
            endif;
        endif;
    }

    function change_password()
    {
        $this->form_validation->set_rules('password', 'Contraseña', 'required|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', 'Confirme Contraseña', 'required');

        if ($this->form_validation->run() == false)
        {
            echo "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Error !</h4>".validation_errors()."</div>";
        }
        else
        {
            $id = $this->input->post('id');
            $password = $this->input->post('password');
            $objeto['password']  = md5($password);
            $this->modelo->update($id, $objeto);
            echo "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Contraseña actualizada</div>";
        }
    }

    function delete()
    {
        $this->modelo->delete($this->input->post('ele'));

        $this->modelo->deletePacientesAsignados($this->input->post('ele'));

        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/index', 'refresh');
    }

    function restore()
    {
        $this->modelo->restore($this->input->post('ele'));

        $this->modelo->restorePacientesAsignados($this->input->post('ele'));

        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/restaurar', 'refresh');
    }

    /* - Sub AMB - */
    function sub_index($id, $honorarios = NULL)
    {
        $this->data['fields'] = array(
            'paciente' => 'Paciente',
            'visitasxmes' => 'Visitas por mes',
            'honorarios' => 'Honorarios'
        );
        $this->data['idProfesional'] = $id;
        $this->data['honorario'] = $honorarios;
        $this->data['estado'] = 1;
        if($this->user_reg['sucursal'] != "Master"):
            $this->data['sucursal'] = $this->user_reg['sucursal'];
        endif;
        $results = $this->modelo->getAllList($this->data);
        $this->data['rows'] = $results['rows'];
        //$this->data['num_results'] = $results['num_rows'];

        $this->load->view('admin/' . $this->dir . '/sub_list', $this->data);
    }

    function sub_restaurar($id)
    {
        $this->data['fields'] = array(
            'paciente' => 'Paciente',
            'visitasxmes' => 'Visitas por mes',
            'honorarios' => 'Honorarios'
        );
        $this->data['idProfesional'] = $id;
        $this->data['estado'] = 0;
        if($this->user_reg['sucursal'] != "Master"):
            $this->data['sucursal'] = $this->user_reg['sucursal'];
        endif;
        $results = $this->modelo->getAllList($this->data);
        $this->data['rows'] = $results['rows'];
        //$this->data['num_results'] = $results['num_rows'];

        $this->load->view('admin/' . $this->dir . '/sub_restaurar', $this->data);
    }

    function sub_edit($id, $honorarios = NULL)
    {
        $this->data['idProfesional'] = $this->input->post('idProfesional');
        $this->data['honorario'] = $honorarios;

        $this->data['estado'] = 1;
        $this->data['filtro'] = $id;
        $pacientesAsignados = $this->modelo->getAllList($this->data);
        foreach($pacientesAsignados['rows'] as $pacienteAsignado):
            $sql['asignado'][] = $pacienteAsignado->idPaciente;
        endforeach;

        $this->data['localidades'] = $this->modelo->getProfesionalesXLocalidades($this->input->post('idProfesional'));

        $this->load->model('admin/pacientes_model', '', TRUE);
        $sql['habilitado'] = 1;
        $sql['empresa'] = $this->user_reg['company'];
        $sql['sucursal'] = $this->user_reg['sucursal'];
        $sql['sort_order'] =  'asc';
        $sql['sort_by'] = 'nombreyapellido';
        $pacientes = $this->pacientes_model->getAll($sql);
        $this->data['pacientes'] = $pacientes['rows'];

        if ($id != 0) {
            $sql['id'] = $id;
            $results = $this->modelo->getPaciente($sql);
            $this->data['row'] = $results['rows'][0];
        }

        $this->load->view('admin/' . $this->dir . '/sub_edit', $this->data);
    }

    function filtrarPacienteXLocalidad($idLocalidad, $idProfesional, $filtro)
    {
        //$sql['estado'] = 1;
        $sql['idProfesional'] = $idProfesional;
        $sql['filtro'] = $filtro;
        $pacientesAsignados = $this->modelo->getAllList($sql);
        foreach($pacientesAsignados['rows'] as $pacienteAsignado):
            $sql['asignado'][] = $pacienteAsignado->idPaciente;
        endforeach;

        $this->load->model('admin/pacientes_model', '', TRUE);
        $sql['habilitado'] = 1;
        $sql['empresa'] = $this->user_reg['company'];
        $sql['sucursal'] = $this->user_reg['sucursal'];
        $sql['sort_order'] =  'asc';
        $sql['sort_by'] = 'nombreyapellido';
        $sql['idLocalidad'] = $idLocalidad;
        $pacientes = $this->pacientes_model->getAll($sql);
        $this->data['pacientes'] = $pacientes['rows'];

        $this->load->view('admin/profesionales/select_pacientes', $this->data);
    }

    function sub_update()
    {
        $id = $this->input->post('id');

        if ($id == 0) {
            $objeto = $this->input->post();

            $creado = date("Y-m-d H:i:s");
            $objeto['creado'] = $creado;;

            $id = $this->modelo->savePaciente($objeto);
            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Guardado</div>";
        } else {
            $objeto = $this->input->post();

            $this->modelo->sub_update($objeto);
            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Modificado</div>";
        }
        $this->session->set_flashdata('template_msg', $this->data['message']);
        $this->sub_index($this->input->post('idProfesional'));
    }

    function sub_delete()
    {
        $this->modelo->deletePaciente($this->input->post('sub_ele'), $this->input->post('idProfesional'));
        //echo $this->db->last_query();
        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        $this->sub_index($this->input->post('idProfesional'));
    }

    function sub_restore()
    {
        $this->modelo->restorePaciente($this->input->post('sub_ele'), $this->input->post('idProfesional'));
        //echo $this->db->last_query();
        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        $this->sub_index($this->input->post('idProfesional'));
    }

    function duracion_sesion()
    {

    }

    function APIPacientesProfesionales($idProfesional)
    {
        header('Content-Type: application/JSON');
        $method = $_SERVER['REQUEST_METHOD'];
        switch ($method) {
            case 'GET'://consulta
                $sql['idProfesional'] = $idProfesional;
                $result = $this->modelo->getAllList($sql);
                $json_encode = json_encode($result['rows']);
                json_decode($json_encode);
                echo $json_encode;
                break;
            case 'POST'://inserta
                echo 'POST';
                break;
            case 'PUT'://actualiza
                echo 'PUT';
                break;
            case 'DELETE'://elimina
                echo 'DELETE';
                break;
            default://metodo NO soportado
                echo 'METODO NO SOPORTADO';
                break;
        }
    }
}