<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Archivos extends MY_Controller
{
    private $dir = 'archivos';
    private $nom = 'Archivos';
    private $dir1 = 'Nuevo archivo';
    private $dir2 = 'Editar archivo';

    private $user_reg = '';

    function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('ubicacion') != $this->dir):
            $array_items = array('per_page' => NULL, 'sort_order' => NULL, 'sort_by' => NULL,);
            $this->session->unset_userdata($array_items);
            $this->session->set_userdata('ubicacion', $this->dir);
        endif;

        $this->user_reg = $this->session->userdata('user_reg');

        $this->load->model($this->dir . '_model', 'modelo', TRUE);
        $this->data['dir'] = $this->dir;
        $this->data['nom'] = $this->nom;
        $this->data['dir1'] = $this->dir1;
        $this->data['dir2'] = $this->dir2;
    }

    function index($sort_by = 'creado', $sort_order = 'asc', $offset = 0)
    {
        $this->load->helper('text');
        $this->load->library('pagination');
        $this->load->library('table');

        $this->data['fields'] = $this->modelo->getCampos();

        /* - search - */
        if ($this->get_search($this->dir) != '') $sql['search'] = $this->get_search($this->dir);
        /* - limit - */
        $sql['limit'] = $this->get_limit($this->dir);
        /* - sort_order - */
        $sql['sort_order'] = $this->get_sort_order($this->dir, $sort_order);
        /* - sort_by - */
        $sql['sort_by'] = $this->get_sort_by($this->dir, $sort_by);
        /* - offset - */
        $sql['offset'] = ($offset > 1) ? $offset : NULL;
        /* - Empresa - */
        $sql['empresa'] = ($this->user_reg['company'] != '')?$this->user_reg['company']:'';
        /* - Habilitado 1 - Activo | 0 - Eliminado */
        $sql['habilitado'] = 1;

        $results = $this->modelo->getAll($sql);

        $this->data['rows'] = $results['rows'];
        $this->data['num_results'] = $results['num_rows'];

        $config = array();
        $config['base_url'] = site_url("admin/" . $this->dir . "/index/$sort_by/$sort_order");
        $config['uri_segment'] = 5;
        $config['total_rows'] = $this->data['num_results'];
        $config['per_page'] = $sql['limit'];

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->pagination->initialize($config);
        $this->data['pagination'] = $this->pagination->create_links();
        $this->data['cur_page'] = $this->pagination->cur_page;
        $this->data['pagination_tot'] = ceil(($config['total_rows'] / $this->pagination->per_page));
        $this->data['action'] = site_url('admin/' . $this->dir . '/index');
        $this->data['search'] = $this->session->userdata($this->dir . '_search');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/list', $this->data);
    }

    function restaurar($sort_by = 'creado', $sort_order = 'asc', $offset = 0)
    {
        $this->load->helper('text');
        $this->load->library('pagination');
        $this->load->library('table');

        $this->data['fields'] = $this->modelo->getCampos();

        /* - search - */
        if ($this->get_search($this->dir) != '') $sql['search'] = $this->get_search($this->dir);
        /* - limit - */
        $sql['limit'] = $this->get_limit($this->dir);
        /* - sort_order - */
        $sql['sort_order'] = $this->get_sort_order($this->dir, $sort_order);
        /* - sort_by - */
        $sql['sort_by'] = $this->get_sort_by($this->dir, $sort_by);
        /* - offset - */
        $sql['offset'] = ($offset > 1) ? $offset : NULL;
        /* - Empresa - */
        $sql['empresa'] = ($this->user_reg['company'] != '')?$this->user_reg['company']:'';
        /* - Habilitado 1 - Activo | 0 - Eliminado */
        $sql['habilitado'] = 0;

        $results = $this->modelo->getAll($sql);

        $this->data['rows'] = $results['rows'];
        $this->data['num_results'] = $results['num_rows'];

        $config = array();
        $config['base_url'] = site_url("admin/" . $this->dir . "/index/$sort_by/$sort_order");
        $config['uri_segment'] = 5;
        $config['total_rows'] = $this->data['num_results'];
        $config['per_page'] = $sql['limit'];

        if ($this->session->flashdata('template_msg'))
            $this->data['message'] = $this->session->flashdata('template_msg');

        $this->pagination->initialize($config);
        $this->data['pagination'] = $this->pagination->create_links();
        $this->data['cur_page'] = $this->pagination->cur_page;
        $this->data['pagination_tot'] = ceil(($config['total_rows'] / $this->pagination->per_page));
        $this->data['action'] = site_url('admin/' . $this->dir . '/index');
        $this->data['search'] = $this->session->userdata($this->dir . '_search');

        $this->template->title($this->data['nombre'], 'Administración');
        $this->template->build('admin/' . $this->dir . '/restaurar', $this->data);
    }

    function edit($id)
    {
        if ($id != 0):
            $sql['id'] = $id;
            $results = $this->modelo->getAll($sql);
            $this->data['row'] = $results['rows'][0];
            $this->data['num_results'] = $results['num_rows'];
        endif;

        $this->data['action'] = site_url('admin/' . $this->dir . '/update');

        $this->template->title($this->data['nombre'] . ' :: Administración');
        $this->template->build('admin/' . $this->dir . '/edit', $this->data);
    }

    function update()
    {
        $id = $this->input->post('id');

        $config['upload_path'] = 'data/';
        $config['file_name'] = 'data.csv';
        $config['overwrite'] = TRUE;
        $config['allowed_types'] = '*';
        $config['max_size'] = '0';
        $config['carpeta'] = array();

        $archivo = '';
        $error = NULL;

        if (isset($_FILES['nombre']) && $_FILES['nombre']['name'] != ''):
            $this->load->model('imagenes_model', '', TRUE);
            $archivo = $this->imagenes_model->do_upload($config);
        endif;

        if ($archivo == FALSE) $this->index();

        $objeto = array(
            'empresa' => $this->user_reg['company']
        );

        if ($id == 0):

            $creado = date("Y-m-d H:i:s");
            $objeto['creado'] = $creado;

            if ($archivo != '') $objeto['nombre'] = $archivo;

            $id = $this->modelo->save($objeto);

            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Guardado</div>";
            $this->session->set_flashdata('template_msg', $this->data['message']);
            redirect('admin/' . $this->dir . '/index', 'refresh');
        else:

            if ($archivo != '') $objeto['nombre'] = $archivo;

            $this->modelo->update($id, $objeto);

            $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Modificado</div>";
            $this->session->set_flashdata('template_msg', $this->data['message']);
            redirect('admin/' . $this->dir . '/index', 'refresh');
        endif;
    }

    function delete()
    {
        $this->modelo->delete($this->input->post('ele'));

        $this->load->model('admin/pacientes_model', '', TRUE);

        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/index', 'refresh');
    }

    function restore()
    {
        $this->modelo->restore($this->input->post('ele'));

        $this->data['message'] = "<div class='alert alert-block'><a class='close' data-dismiss='alert' href='#'>&times;</a><h4 class='alert-heading'>Info !</h4>Registro Eliminado</div>";
        $this->session->set_flashdata('template_msg', $this->data['message']);
        redirect('admin/' . $this->dir . '/index', 'refresh');
    }
}