package com.ensoft.aeir.ui.holder;

import android.database.Cursor;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.EquipmentModel;
import com.ensoft.aeir.ui.listener.EquipmentCheckListener;

public class EquipmentHolder extends RecyclerView.ViewHolder
{
	protected TextView nameView;
	protected CheckBox checkBox;
	protected EquipmentCheckListener equipmentCheckListener;
	
	public EquipmentHolder( View itemView, EquipmentCheckListener equipmentCheckListener )
	{
		super( itemView );
		
		nameView = (TextView)itemView.findViewById( R.id.equipment_name );
		checkBox = (CheckBox)itemView.findViewById( R.id.equipment_check );
		this.equipmentCheckListener = equipmentCheckListener;
	}
	
	public void setData( final EquipmentModel equipmentModel )
	{
		nameView.setText( equipmentModel.getName() );
		nameView.setOnClickListener( new View.OnClickListener()
		{
			@Override
			public void onClick( View v )
			{
				checkBox.setChecked( !checkBox.isChecked() );
			}
		} );
		checkBox.setOnCheckedChangeListener( new CompoundButton.OnCheckedChangeListener()
		{
			@Override
			public void onCheckedChanged( CompoundButton buttonView, boolean isChecked )
			{
				equipmentCheckListener.onEquipmentCheck( equipmentModel, isChecked );
			}
		} );
	}
	
	public void setData( Cursor cursor )
	{
		EquipmentModel equipmentModel = new EquipmentModel();
		equipmentModel.fromCursor( cursor );
		setData( equipmentModel );
	}
}
