package com.ensoft.aeir.ui.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.InputType;
import android.view.Gravity;
import android.widget.EditText;

import com.afollestad.materialdialogs.MaterialDialog;

public class AuditDialog
{
	public static void newDialog( Context context, MaterialDialog.SingleButtonCallback positiveCb )
	{
		MaterialDialog dialog = new MaterialDialog.Builder(context)
			.title( "Confirmación de fin de visita" )
			.content( "Observaciones de visita:")
			.inputType( InputType.TYPE_CLASS_TEXT )
			.negativeText( "Cancelar" )
			.positiveText( "Confirmar" )
			.inputType( InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_FLAG_MULTI_LINE | InputType.TYPE_TEXT_FLAG_IME_MULTI_LINE | InputType.TYPE_TEXT_FLAG_CAP_SENTENCES )
			.onPositive( positiveCb )
			.input( "", "", new MaterialDialog.InputCallback()
			{
				@Override
				public void onInput( @NonNull MaterialDialog dialog, CharSequence input )
				{
				}
			} ).show();
		
		EditText editText = dialog.getInputEditText();
		
		if ( null != editText )
		{
			editText.setGravity( Gravity.TOP | Gravity.START );
			editText.setMinLines( 4 );
			editText.setLines( 4 );
		}
	}
}
