package com.ensoft.aeir.ui.adapter;

import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.ensoft.aeir.App;
import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.aeir.ui.activity.LoginActivity;

import butterknife.Bind;
import butterknife.ButterKnife;

public class UsersAdapter extends RecyclerView.Adapter<UsersAdapter.ItemViewHolder>
{
	private UserModel[] items;
	private UserAdapterInterface adapterInterface;
	private Context context;
	
	public UsersAdapter( UserModel[] items, UserAdapterInterface adapterInterface, Context context )
	{
		this.items = items;
		this.context = context;
		this.adapterInterface = adapterInterface;
	}
	
	@Override
	public void onAttachedToRecyclerView( RecyclerView recyclerView )
	{
		super.onAttachedToRecyclerView( recyclerView );
	}
	
	@Override
	public ItemViewHolder onCreateViewHolder( ViewGroup viewGroup, int i )
	{
		View v = LayoutInflater.from( viewGroup.getContext() ).inflate( R.layout.item_user, viewGroup, false );
		return new ItemViewHolder( v, adapterInterface, context );
	}
	
	@Override
	public void onBindViewHolder( ItemViewHolder personViewHolder, int i )
	{
		personViewHolder.setItem( items[i] );
	}
	
	@Override
	public int getItemCount()
	{
		return items.length;
	}

	public interface UserAdapterInterface
	{
		void onClickPressItem();
	}
	
	static class ItemViewHolder extends RecyclerView.ViewHolder
	{
		@Bind( R.id.card_title )
		protected TextView patientName;
		
		@Bind( R.id.card_company )
		protected TextView patientCompany;
		
		@Bind( R.id.user_login_button )
		protected Button userLoginButton;
		
		@Bind( R.id.user_delete_button )
		protected Button userDeleteButton;
		
		Context context;
		UserAdapterInterface adapterInterface;
		
		ItemViewHolder( View itemView, UserAdapterInterface adapterInterface, Context context )
		{
			super( itemView );
			this.context = context;
			this.adapterInterface = adapterInterface;
			ButterKnife.bind( this, itemView );
		}
		
		public void setItem( final UserModel user )
		{
			patientCompany.setVisibility( View.VISIBLE );
			patientName.setText( user.getUser() );
			
			if ( null != user.getCompany() && !user.getCompany().isEmpty() )
			{
				patientCompany.setText( user.getCompany() );
			}
			else
			{
				patientCompany.setVisibility( View.GONE );
			}
			
			userDeleteButton.setOnClickListener( new View.OnClickListener()
			{
				@Override
				public void onClick( View view )
				{
					user.delete();
					
					adapterInterface.onClickPressItem();
				}
			} );
			
			userLoginButton.setOnClickListener( new View.OnClickListener()
			{
				@Override
				public void onClick( View view )
				{
					App.getInstance().getPreferencesService().setUser( user );

					context.startActivity( new Intent( context, LoginActivity.class ).setFlags( Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK ) );
				}
			} );
		}
	}
}