package com.ensoft.aeir.ui.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.EquipmentModel;
import com.ensoft.aeir.ui.holder.EquipmentHolder;
import com.ensoft.aeir.ui.listener.EquipmentCheckListener;

public class EquipmentAdapter extends RecyclerView.Adapter<EquipmentHolder>
{
	protected EquipmentModel[] items;
	protected EquipmentCheckListener equipmentCheckListener;
	
	public EquipmentAdapter( EquipmentModel[] items, EquipmentCheckListener equipmentCheckListener )
	{
		this.items = items;
		this.equipmentCheckListener = equipmentCheckListener;
	}
	
	@Override
	public EquipmentHolder onCreateViewHolder( ViewGroup parent, int viewType )
	{
		View v = LayoutInflater.from( parent.getContext() ).inflate( R.layout.item_equipment, parent, false );
		return new EquipmentHolder( v, equipmentCheckListener );
	}
	
	@Override
	public void onBindViewHolder( EquipmentHolder holder, int position )
	{
		holder.setData( items[ position ] );
	}
	
	@Override
	public int getItemCount()
	{
		return null != items ? items.length : 0;
	}
}
