package com.ensoft.aeir.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

import com.ensoft.aeir.App;
import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.aeir.domain.table.UserTable;
import com.ensoft.aeir.ui.adapter.UsersAdapter;

public class UsersActivity extends AppCompatActivity
{
	RecyclerView usersList;
	
	@Override
	protected void onCreate( @Nullable Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		setContentView( R.layout.activity_usuarios );
		findViews();
		setTitle( "Usuarios" );
	}
	
	void findViews()
	{
		usersList = (RecyclerView) findViewById( R.id.users_list );
		usersList.setLayoutManager( new LinearLayoutManager( getApplicationContext() ) );
		getData();
	}
	
	void getData()
	{
		UserModel[] users = new UserTable().getAll();
		UsersAdapter usersAdapter = new UsersAdapter( users, new UsersAdapter.UserAdapterInterface()
		{
			@Override
			public void onClickPressItem()
			{
				getData();
			}
		}, UsersActivity.this );
		usersList.setAdapter( usersAdapter );
	}
	
	@Override
	public boolean onCreateOptionsMenu( Menu menu )
	{
		MenuInflater inflater = getMenuInflater();
		inflater.inflate( R.menu.menu_add, menu );
		return true;
	}
	
	@Override
	public boolean onOptionsItemSelected( MenuItem item )
	{
		switch ( item.getItemId() )
		{
			case R.id.new_game:
				
				App.getInstance().getPreferencesService().clearAll();

				startActivity( new Intent( UsersActivity.this, LoginActivity.class ).setFlags( Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK ) );
				return true;
			
			default:
				return super.onOptionsItemSelected( item );
		}
	}
}
