package com.ensoft.aeir.ui.activity;

import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.aeir.infrastructure.service.LocationService;
import com.ensoft.aeir.ui.broadcast.LocationServicesReceiver;

public class LocationAwareActivity extends BaseActivity implements LocationServicesReceiver.LocationServiceListener
{
	private LocationServicesReceiver mLocationServicesReceiver;
	private IntentFilter mLocationServicesChangeFilter;

	@Override
	protected void onPostCreate( Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );

		mLocationServicesReceiver = new LocationServicesReceiver(this);

		mLocationServicesChangeFilter = mLocationServicesReceiver.getIntentFilter();

		if ( !new LocationService(this).isEnable() )
		{
			onLocationServicesDisabled();
		}
	}

	@Override
	public void onLocationServicesEnabled()
	{

	}

	@Override
	public void onLocationServicesDisabled()
	{
		errorMessage( "Debe activar el GPS para poder utilizar la aplicación.", new MaterialDialog.SingleButtonCallback()
		{
			@Override
			public void onClick( @NonNull MaterialDialog dialog, @NonNull DialogAction which )
			{
				new LocationService( LocationAwareActivity.this ).requestEnableLocation( LocationAwareActivity.this );
			}
		} );
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		registerReceiver(mLocationServicesReceiver, mLocationServicesChangeFilter);
	}

	@Override
	protected void onPause()
	{
		unregisterReceiver(mLocationServicesReceiver);
		super.onPause();
	}
}