package com.ensoft.aeir.ui.activity;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;

import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.aeir.App;
import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.aeir.infrastructure.responseDTO.ResponseMessage;
import com.ensoft.restafari.ui.view.RequestResponseAppCompatActivity;
import com.evernote.android.state.StateSaver;
import com.google.gson.Gson;

public class BaseActivity extends RequestResponseAppCompatActivity
{
	protected ProgressDialog progressDialog;
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		StateSaver.restoreInstanceState(this, savedInstanceState);
	}
	
	@Override
	protected void onSaveInstanceState(Bundle outState)
	{
		super.onSaveInstanceState(outState);
		StateSaver.saveInstanceState(this, outState);
	}
	
	public void hideSoftKeyboard()
	{
		if ( getCurrentFocus() != null )
		{
			InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(INPUT_METHOD_SERVICE);
			inputMethodManager.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
		}
	}

	public void showSoftKeyboard(View view)
	{
		InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(INPUT_METHOD_SERVICE);
		view.requestFocus();
		inputMethodManager.showSoftInput(view, 0);
	}
	
	protected void errorMessage( String message )
	{
		Toast.makeText( this, message, Toast.LENGTH_SHORT ).show();
	}
	
	protected void errorMessageFromResponse( String message )
	{
		try
		{
			ResponseMessage errorMessageModel = new Gson().fromJson( message, ResponseMessage.class );
			
			errorMessage( errorMessageModel.getMessage() );
		}
		catch ( Exception e )
		{
			UserModel user = App.getInstance().getPreferencesService().getUser();
			
			if ( null != user && ( user.getId() == 46 || user.getId() == 61 ) )
			{
				errorMessage( "Error: " + message );
			}
			else
			{
				errorMessage( "Error en la comunicación con el servidor. Por favor verifique su conexión a internet." );
			}
		}
	}
	
	void createdDialog( String msg )
	{
		if ( null == progressDialog )
			progressDialog = new ProgressDialog( this );
		progressDialog.setMessage( msg );
		progressDialog.show();
	}
	
	void closeDialog()
	{
		if ( progressDialog != null && progressDialog.isShowing() )
		{
			progressDialog.dismiss();
		}
	}

	protected void alertMessage( String title, String message, String okText, MaterialDialog.SingleButtonCallback onOkClick )
	{
		new MaterialDialog.Builder(this)
			.title( title )
			.content( message )
			.positiveText( okText )
			.onPositive( onOkClick )
			.show();
	}

	protected void alertMessage( String title, String message, String okText )
	{
		alertMessage( title, message, okText, null );
	}

	protected void alertMessage( String title, String message, MaterialDialog.SingleButtonCallback onOkClick )
	{
		alertMessage( title, message, getString( R.string.ok ), onOkClick );
	}

	protected void alertMessage( String title, String message )
	{
		alertMessage( title, message, getString( R.string.ok ), null );
	}

	protected void errorMessage( String message, MaterialDialog.SingleButtonCallback onOkClick )
	{
		alertMessage( getString( R.string.error ), message, getString( R.string.ok ), onOkClick );
	}
}
