package com.ensoft.aeir.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.Toast;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.ensoft.aeir.R;
import com.ensoft.aeir.domain.model.EquipmentModel;
import com.ensoft.aeir.domain.model.EquipmentStateModel;
import com.ensoft.aeir.domain.model.PatientEquipmentModel;
import com.ensoft.aeir.domain.table.EquipmentTable;
import com.ensoft.aeir.domain.table.PatientEquipmentTable;
import com.ensoft.aeir.infrastructure.provider.DelayedTask;
import com.ensoft.aeir.infrastructure.request.AuditPostRequest;
import com.ensoft.aeir.infrastructure.service.DateService;
import com.ensoft.aeir.infrastructure.service.DelayedTaskService;
import com.ensoft.aeir.infrastructure.service.LocationService;
import com.ensoft.aeir.ui.adapter.EquipmentAdapter;
import com.ensoft.aeir.ui.dialog.AuditDialog;
import com.ensoft.aeir.ui.listener.EquipmentCheckListener;
import com.evernote.android.state.State;

import java.util.HashMap;

import butterknife.Bind;
import butterknife.ButterKnife;
import butterknife.OnClick;

public class AuditActivity extends BaseActivity implements EquipmentCheckListener
{
	protected static final String PATIENT_ID = "patientId";
	
	@Bind( R.id.equipment_list )
	protected RecyclerView list;
	
	protected DelayedTaskService delayedStart = new DelayedTaskService();
	protected EquipmentAdapter adapter;
	@State protected HashMap<Long, EquipmentStateModel> states = new HashMap<>();
	@State protected long patientId;
	@State protected long startTime;
	@State protected long reqId;
	
	public static void newInstance( Context context, long patientId )
	{
		Intent intent = new Intent( context, AuditActivity.class );
		intent.putExtra( PATIENT_ID, patientId );
		
		context.startActivity( intent );
	}
	
	public void onCreate( Bundle savedInstanceState )
	{
		super.onCreate( savedInstanceState );
		
		setContentView( R.layout.activity_audit );
		
		ButterKnife.bind( this );
	}
	
	public void onPostCreate( Bundle savedInstanceState )
	{
		super.onPostCreate( savedInstanceState );
		
		startTime = new DateService().getCurrentTimestamp();
		
		Bundle bundle = getIntent().getExtras();
		
		patientId = bundle.getLong( PATIENT_ID );
		
		PatientEquipmentModel[] patientEquipmentModels = new PatientEquipmentTable().getEquipmentFromPatient( patientId );
		
		if ( null == patientEquipmentModels || patientEquipmentModels.length == 0 )
		{
			errorMessage( "La persona no posee equipos para auditar.", new MaterialDialog.SingleButtonCallback()
			{
				@Override
				public void onClick( @NonNull MaterialDialog dialog, @NonNull DialogAction which )
				{
					finish();
				}
			} );
		}
		else
		{
			EquipmentModel[] equipmentModels = new EquipmentTable().getFromPatientEquipment( patientEquipmentModels );
			
			if ( null != equipmentModels && equipmentModels.length > 0 )
			{
				for ( EquipmentModel equipmentModel : equipmentModels )
				{
					states.put( equipmentModel.getId(), new EquipmentStateModel( equipmentModel.getId(), false ) );
				}
				
				adapter = new EquipmentAdapter( equipmentModels, this );
				list.setAdapter( adapter );
				list.setLayoutManager( new LinearLayoutManager( this ) );
			}
		}
	}
	
	@Override
	public void onEquipmentCheck( EquipmentModel equipmentModel, boolean checked )
	{
		states.put( equipmentModel.getId(), new EquipmentStateModel( equipmentModel.getId(), checked ) );
	}
	
	@Override
	protected void onActivityResult( int requestCode, int resultCode, Intent data )
	{
		if ( requestCode == LocationService.REQUEST_LOCATION )
		{
			if ( Activity.RESULT_OK == resultCode )
			{
				delayedStart.run();
			}
		}
	}
	
	protected void saveAudit()
	{
		AuditDialog.newDialog( this, new MaterialDialog.SingleButtonCallback()
		{
			@Override
			public void onClick( @NonNull MaterialDialog dialog, @NonNull DialogAction which )
			{
				String observations = dialog.getInputEditText().getText().toString();
				
				createdDialog( "Guardando Auditoría" );
				
				getRequestReceiverService().addRequest(
					reqId = AuditPostRequest.addRequest(
						patientId,
						observations,
						startTime,
						new DateService().getCurrentTimestamp(),
						states.values().toArray( new EquipmentStateModel[ states.size() ] )
					)
				);
			}
		} );
	}
	
	@OnClick( R.id.save_button )
	protected void onSaveClick()
	{
		LocationService locationService = new LocationService( this );
		
		if ( locationService.isEnable() )
		{
			saveAudit();
		}
		else
		{
			delayedStart.add( new DelayedTask()
			{
				@Override
				public void run()
				{
					saveAudit();
				}
			} );
			
			locationService.requestEnableLocation( this );
		}
	}
	
	@Override
	public void onRequestSuccess( long requestId )
	{
		if ( reqId == requestId )
		{
			Toast.makeText( this, "Auditoría guardada con éxito.", Toast.LENGTH_SHORT ).show();
			
			closeDialog();
			
			finish();
		}
	}
	
	@Override
	public void onRequestError( long requestId, int resultCode, String resultMsg )
	{
		if ( reqId == requestId )
		{
			closeDialog();
			
			errorMessageFromResponse( resultMsg );
		}
	}
}
