package com.ensoft.aeir.infrastructure.service.preference;

import android.content.Context;
import android.location.Location;

import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.restafari.network.service.NetworkPreferencesService;
import com.google.gson.Gson;

public class PreferencesService extends NetworkPreferencesService
{
	public static final String USER_MODEL = "userModel";
	public static final String FCM_TOKEN = "fcmToken";
	public static final String SERVER_TIME_DIFF = "serverTimeDiff";
	public static final String LATITUDE = "latitude";
	public static final String LONGITUDE = "longitude";

	public PreferencesService( Context context )
	{
		super( context );
	}
	
	public void clearAll()
	{
		getDefaultSharedPreferences().edit().clear().apply();
	}

	public UserModel getUser()
	{
		String userModelString = getDefaultSharedPreferences().getString( USER_MODEL, "" );

		if ( !"".equals( userModelString ) )
		{
			try
			{
				return new Gson().fromJson( userModelString, UserModel.class );
			}
			catch ( Exception e )
			{
			}
		}

		return null;
	}

	public void setUser( UserModel userModel )
	{
		String userModelString = null;

		if ( null != userModel )
		{
			try
			{
				userModelString = new Gson().toJson( userModel );
			}
			catch ( Exception e )
			{
			}
		}

		getDefaultSharedPreferences().edit().putString( USER_MODEL, null == userModelString ? "" : userModelString ).apply();
	}

	public void setFcmToken( String token )
	{
		getDefaultSharedPreferences().edit().putString( FCM_TOKEN, token ).apply();
	}

	public String getFcmToken()
	{
		return getDefaultSharedPreferences().getString( FCM_TOKEN, "" );
	}

	public void setServerTimeDiff( long timeDiff )
	{
		getDefaultSharedPreferences().edit().putLong( SERVER_TIME_DIFF, timeDiff ).apply();
	}

	public long getServerTimeDiff()
	{
		return getDefaultSharedPreferences().getLong( SERVER_TIME_DIFF, 0 );
	}

	public void setLatitude( double latitude )
	{
		getDefaultSharedPreferences().edit().putString( LATITUDE, String.valueOf( latitude ) ).apply();
	}

	public void setLongitude( double longitude )
	{
		getDefaultSharedPreferences().edit().putString( LONGITUDE, String.valueOf( longitude ) ).apply();
	}

	public double getLatitude()
	{
		return Double.valueOf( getDefaultSharedPreferences().getString( LATITUDE, "0" ) );
	}

	public double getLongitude()
	{
		return Double.valueOf( getDefaultSharedPreferences().getString( LONGITUDE, "0" ) );
	}

	public void setLocation( double latitude, double longitude )
	{
		setLatitude( latitude );
		setLongitude( longitude );
	}

	public void setLocation( Location location )
	{
		setLocation( location.getLatitude(), location.getLongitude() );
	}
}
