package com.ensoft.aeir.infrastructure.service;

import com.ensoft.aeir.BuildConfig;
import com.ensoft.restafari.network.helper.RequestParameters;

import org.json.JSONObject;

public class EndpointService
{
	//public static final String BASE_URL = BuildConfig.DEBUG ? "http://192.168.0.6" : "https://aeir.aegirsystem.com";
	public static final String BASE_URL = "https://aeir.aegirsystem.com";

	public static String fromPath( String path )
	{
		return BASE_URL + path;
	}

	public static String fromPath( String path, JSONObject parameters )
	{
		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}

	public static String fromPath( String path, JSONObject parameters, String idFieldName )
	{
		try
		{
			long id = parameters.getLong( idFieldName );

			if ( !path.endsWith( "/" ) )
			{
				path += "/";
			}

			path += String.valueOf( id );
		}
		catch ( Exception e )
		{
		}

		return fromPath( path + RequestParameters.getUrlQuery( parameters ) );
	}
}
