package com.ensoft.aeir.infrastructure.service;

import com.ensoft.aeir.infrastructure.provider.DelayedTask;

import java.util.ArrayList;

public class DelayedTaskService
{
	protected boolean taskCondEnabled = false;
	protected ArrayList<DelayedTask> tasks = new ArrayList<>();
	protected final Object taskMutex = new Object();

	public DelayedTaskService()
	{
	}

	public DelayedTaskService( boolean taskCondEnabled )
	{
		this.taskCondEnabled = taskCondEnabled;
	}

	public void run()
	{
		synchronized ( taskMutex )
		{
			taskCondEnabled = true;

			for ( DelayedTask task : tasks )
			{
				task.run();
			}

			tasks.clear();

			taskCondEnabled = false;
		}
	}

	public void clear()
	{
		synchronized ( taskMutex )
		{
			tasks.clear();

			taskCondEnabled = false;
		}
	}

	public void add( DelayedTask task )
	{
		synchronized ( taskMutex )
		{
			if ( taskCondEnabled )
			{
				task.run();
			}
			else
			{
				tasks.add( task );
			}
		}
	}

	public boolean isTaskCondEnabled()
	{
		return taskCondEnabled;
	}

	public void setTaskCondEnabled( boolean taskCondEnabled )
	{
		synchronized ( taskMutex )
		{
			this.taskCondEnabled = taskCondEnabled;
		}
	}
}
