package com.ensoft.aeir.infrastructure.service;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateService
{
	public int timeToSeconds( String time )
	{
		String[] parts = time.split( ":" );
		
		if ( parts.length == 3 )
		{
			return Integer.parseInt( parts[0] ) * 3600 + Integer.parseInt( parts[1] ) * 60 + Integer.parseInt( parts[2] );
		}
		
		return 0;
	}
	
	public Calendar toCalendar( Date date )
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		return cal;
	}
	
	public Date fromString( String date )
	{
		return fromString( date, null );
	}
	
	public Date fromString( String date, String time )
	{
		if ( null != date && ( null == time || time.isEmpty() ) )
		{
			if ( date.contains( " " ) )
			{
				String[] dateSplit = date.split( " " );
				
				if ( dateSplit.length >= 2 )
				{
					time = dateSplit[1];
				}
				else
				{
					time = "00:00:00";
				}
			}
			else
			{
				time = "00:00:00";
			}
		}
		
		String string = date + " " + time;
		
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
		format.setTimeZone( TimeZone.getTimeZone("GMT-3") );
		
		Date ret = null;
		
		try
		{
			ret = format.parse(string);
		}
		catch ( ParseException e )
		{
		}
		
		return ret;
	}
	
	public long fromStringToTimestamp( String date )
	{
		return fromStringToTimestamp( date, null );
	}
	
	public long fromStringToTimestamp( String date, String time )
	{
		Date newDate = fromString( date, time );
		
		if ( null != newDate )
		{
			return newDate.getTime() / 1000L;
		}
		
		return 0;
	}
	
	public long getCurrentTimestamp()
	{
		return Calendar.getInstance().getTime().getTime() / 1000L;
	}
	
	public Date fromTimestamp( long timestamp )
	{
		return new Date( timestamp * 1000L );
	}
	
	public String secondsToString( long seconds )
	{
		int day = (int) TimeUnit.SECONDS.toDays(seconds);
		long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(day);
		long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.HOURS.toMinutes(TimeUnit.SECONDS.toHours(seconds));
		long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds));
		String ret = second + "s ";
		
		if ( hours > 0 || minute > 0 )
			ret = minute + "m " + ret;
		
		if ( hours > 0 )
			ret = hours + "hs " + ret;
		
		if ( day > 0 )
			ret = day + "d " + ret;
		
		return ret.trim();
	}
	
	public String getTimeString( Date fromDate )
	{
		if ( null == fromDate )
		{
			fromDate = Calendar.getInstance().getTime();
		}
		
		return new SimpleDateFormat( "HH:mm:ss" ).format( fromDate );
	}
	
	public String getTimeString( long timestamp )
	{
		return getTimeString( fromTimestamp( timestamp ) );
	}
}
