package com.ensoft.aeir.infrastructure.response;

import android.content.Context;
import android.util.Log;

import com.ensoft.aeir.domain.table.EquipmentTable;
import com.ensoft.aeir.domain.table.PatientEquipmentTable;
import com.ensoft.aeir.domain.table.PatientTable;
import com.ensoft.aeir.infrastructure.responseDTO.PatientsGetDTO;
import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

public class PatientsGetResponse extends ResponseProcessor<PatientsGetDTO>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, PatientsGetDTO response )
	{
		if ( null != response )
		{
			PatientTable patientTable = new PatientTable();
			patientTable.truncate();
			patientTable.insert( response.patient );
			
			EquipmentTable equipmentTable = new EquipmentTable();
			equipmentTable.truncate();
			equipmentTable.insert( response.equipment );
			
			PatientEquipmentTable patientEquipmentTable = new PatientEquipmentTable();
			patientEquipmentTable.truncate();
			patientEquipmentTable.insert( response.patientEquipment );
		}
	}
	
	@Override
	public void handleError( Context context, RequestConfiguration request, int errorCode, String errorMessage )
	{
		Log.d( PatientsGetResponse.class.getCanonicalName(), errorMessage );
	}
}
