package com.ensoft.aeir.infrastructure.response;

import android.content.Context;

import com.ensoft.aeir.App;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.aeir.domain.table.UserTable;
import com.ensoft.aeir.infrastructure.service.DateService;
import com.ensoft.restafari.network.processor.ResponseProcessor;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

public class LoginResponse extends ResponseProcessor<UserModel>
{
	@Override
	public void handleResponse( Context context, RequestConfiguration request, UserModel response )
	{
		response.generateFields();

		new UserTable().insertOrUpdate( response );

		App.getInstance().getResponseManager().add( getRequestId(), response );

		App.getInstance().getPreferencesService().setUser( response );

		App.getInstance().getPreferencesService().setServerTimeDiff( new DateService().getCurrentTimestamp() - response.getServerTimestamp() );
	}
}
