package com.ensoft.aeir.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.aeir.App;
import com.ensoft.aeir.infrastructure.response.MessageResponse;
import com.ensoft.aeir.infrastructure.responseDTO.ResponseMessage;
import com.ensoft.aeir.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.BaseJsonRequest;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class RememberPasswordRequest extends BaseJsonRequest
{
	public RememberPasswordRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/rememberPassword" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( RememberPasswordRequest.class, MessageResponse.class, ResponseMessage.class ), parameters );
	}
	
	public static long addRequest( String username )
	{
		RequestParameters parameters = new RequestParameters();
		
		parameters.putString( "usuario", username );
		
		return addRequest( parameters );
	}
}
