package com.ensoft.aeir.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.aeir.App;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.aeir.infrastructure.response.LoginResponse;
import com.ensoft.aeir.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.BaseJsonRequest;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class LoginRequest extends BaseJsonRequest
{
	public LoginRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/login" ), parameters, headers, listener, errorListener );
	}

	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( LoginRequest.class, LoginResponse.class, UserModel.class ), parameters );
	}

	public static long addRequest( String login, String password )
	{
		RequestParameters parameters = new RequestParameters();

		parameters.putString( "user", login );
		parameters.putString( "password", password );

		return addRequest( parameters );
	}
}
