package com.ensoft.aeir.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.aeir.App;
import com.ensoft.aeir.infrastructure.response.MessageResponse;
import com.ensoft.aeir.infrastructure.responseDTO.ResponseMessage;
import com.ensoft.aeir.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class ChangePasswordRequest extends BaseAuthorizedRequest
{
	public ChangePasswordRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/change_password" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( ChangePasswordRequest.class, MessageResponse.class, ResponseMessage.class ), parameters );
	}
	
	public static long addRequest( String oldPassword, String newPassword )
	{
		RequestParameters parameters = new RequestParameters();
		parameters.putString( "old_password", oldPassword );
		parameters.putString( "password", newPassword );
		return addRequest( parameters );
	}
}
