package com.ensoft.aeir.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.aeir.App;
import com.ensoft.aeir.domain.model.UserModel;
import com.ensoft.restafari.network.rest.request.BaseJsonArrayRequest;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

public class BaseAuthorizedArrayRequest extends BaseJsonArrayRequest
{
	protected BaseAuthorizedArrayRequest( int method, String url, JSONObject parameters, Map<String, String> headers, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener )
	{
		super( method, url, parameters, headers, listener, errorListener );
		
		UserModel user = App.getInstance().getPreferencesService().getUser();
		
		if ( null != user && null != user.getToken() && !user.getToken().isEmpty() )
		{
			headers.put( "Auth", App.getInstance().getPreferencesService().getUser().getToken() );
		}
	}
}
