package com.ensoft.aeir.infrastructure.request;

import com.android.volley.Response;
import com.ensoft.aeir.App;
import com.ensoft.aeir.domain.model.EquipmentStateModel;
import com.ensoft.aeir.domain.model.PatientModel;
import com.ensoft.aeir.infrastructure.response.AuditPostResponse;
import com.ensoft.aeir.infrastructure.service.EndpointService;
import com.ensoft.restafari.network.helper.RequestParameters;
import com.ensoft.restafari.network.rest.request.RequestConfiguration;

import org.json.JSONObject;

import java.util.Map;

public class AuditPostRequest extends BaseAuthorizedRequest
{
	public AuditPostRequest( JSONObject parameters, Map<String, String> headers, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener )
	{
		super( Method.POST, EndpointService.fromPath( "/audit" ), parameters, headers, listener, errorListener );
	}
	
	public static long addRequest( RequestParameters parameters )
	{
		return App.getInstance().getRequestService().addRequest( new RequestConfiguration( AuditPostRequest.class, AuditPostResponse.class, PatientModel.class ), parameters );
	}
	
	public static long addRequest( long idPaciente, String observations, long initTime, long endTime, EquipmentStateModel[] states )
	{
		RequestParameters parameters = new RequestParameters();
		parameters.putLong( "idPaciente", idPaciente );
		parameters.putLong( "initTime", initTime );
		parameters.putLong( "endTime", endTime );
		parameters.putString( "observaciones", observations );
		parameters.putObjectArray( "states", states );
		return addRequest( parameters );
	}
	
	public static long addRequest()
	{
		return addRequest( new RequestParameters() );
	}
}
