package com.ensoft.aeir.domain.table;

import android.content.CursorLoader;
import android.database.Cursor;

import com.ensoft.aeir.domain.model.PatientModel;
import com.ensoft.restafari.database.DatabaseTableModel;

public class PatientTable extends DatabaseTableModel<PatientModel>
{
	public PatientTable()
	{
		super( PatientModel.class );
	}
	
	public CursorLoader getAll()
	{
		return getAll( null );
	}
	
	public CursorLoader getAll( String name )
	{
		if ( name != null )
		{
			String search = "%" + name.toUpperCase() + "%";
			return getAllLoader( "UPPER(paciente) LIKE ?", new String[]{ search }, "paciente ASC" );
		}
		
		return getAllLoader( null, null, "paciente ASC" );
	}
	
	public PatientModel getModelFromId( long id )
	{
		PatientModel model = null;
		Cursor cursor = getFromId( id );
		
		if ( null != cursor && cursor.moveToFirst() )
		{
			 model = (PatientModel)new PatientModel().fromCursor( cursor );
			
			cursor.close();
		}
		
		return model;
	}
}
