package com.ensoft.aeir.domain.table;

import com.ensoft.aeir.domain.model.EquipmentModel;
import com.ensoft.aeir.domain.model.PatientEquipmentModel;
import com.ensoft.restafari.database.DatabaseTableModel;

public class EquipmentTable extends DatabaseTableModel<EquipmentModel>
{
	public EquipmentTable()
	{
		super( EquipmentModel.class );
	}
	
	public EquipmentModel[] getFromPatientEquipment( PatientEquipmentModel[] patientEquipmentModels )
	{
		if ( null != patientEquipmentModels && patientEquipmentModels.length > 0 )
		{
			String selection = "";
			String[] selectionArgs = new String[ patientEquipmentModels.length ];
			
			for ( int i = 0; i < patientEquipmentModels.length; i++ )
			{
				selection += "id = ? ";
				selectionArgs[i] = String.valueOf( patientEquipmentModels[i].getEquipmentId() );
				
				if ( i != patientEquipmentModels.length - 1 )
				{
					selection += "OR ";
				}
			}
			
			return getAllToModelArray( selection, selectionArgs, "nombre ASC" );
		}
		
		return null;
	}
}
