package com.ensoft.aeir.domain.model;

import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

public class UserModel extends BaseModel
{
	@SerializedName( "id" )
	@DbField
	@DbPrimaryKey
	protected long id;

	@SerializedName( "empresa" )
	@DbField
	protected long comId;

	@SerializedName( "sucursal" )
	@DbField
	protected long branchId;

	@SerializedName( "nombre" )
	@DbField
	protected String name;

	@SerializedName( "apellido" )
	@DbField
	protected String lastname;

	@SerializedName( "idEspecialidad" )
	@DbField
	protected long jobId;

	@SerializedName( "email" )
	@DbField
	protected String email;

	@SerializedName( "celulares" )
	@DbField
	protected String phones;

	@SerializedName("usuario")
	@DbField
	protected String user;

	@SerializedName("password")
	@DbField
	protected String pass;

	@SerializedName( "observaciones" )
	@DbField
	protected String observations;

	@SerializedName( "creado" )
	@DbField
	protected String creationDateString;

	@SerializedName( "modificado" )
	@DbField
	protected String modifiedDateString;

	@SerializedName( "habilitado" )
	@DbField
	protected int enabled;

	@SerializedName( "nombreCompleto" )
	@DbField
	protected String fullName;

	@SerializedName( "especialidad" )
	@DbField
	protected String jobName;

	@SerializedName( "nombreEmpresa" )
	@DbField
	protected String companyName;

	@SerializedName( "nombreSucursal" )
	@DbField
	protected String branchName;

	@SerializedName( "id_token" )
	@DbField
	protected String token;

	protected String company;

	@SerializedName( "timestamp" )
	protected long serverTimestamp;

	public void generateFields()
	{
		company = companyName + " - " + branchName;
	}

	public long getId()
	{
		return id;
	}

	public String getUser()
	{
		return user;
	}

	public String getPass()
	{
		return pass;
	}

	public String getCompany()
	{
		return company;
	}

	public long getComId()
	{
		return comId;
	}

	public long getBranchId()
	{
		return branchId;
	}

	public String getName()
	{
		return name;
	}

	public String getLastname()
	{
		return lastname;
	}

	public long getJobId()
	{
		return jobId;
	}

	public String getEmail()
	{
		return email;
	}

	public String getPhones()
	{
		return phones;
	}

	public String getObservations()
	{
		return observations;
	}

	public String getCreationDateString()
	{
		return creationDateString;
	}

	public String getModifiedDateString()
	{
		return modifiedDateString;
	}

	public int getEnabled()
	{
		return enabled;
	}

	public String getFullName()
	{
		return fullName;
	}

	public String getJobName()
	{
		return jobName;
	}

	public String getCompanyName()
	{
		return companyName;
	}

	public String getBranchName()
	{
		return branchName;
	}

	public String getToken()
	{
		return token;
	}

	public long getServerTimestamp()
	{
		return serverTimestamp;
	}
}
