package com.ensoft.aeir.domain.model;

import com.ensoft.aeir.App;
import com.ensoft.aeir.infrastructure.service.DateService;
import com.ensoft.aeir.infrastructure.service.DistanceService;
import com.ensoft.restafari.database.annotations.DbField;
import com.ensoft.restafari.database.annotations.DbPrimaryKey;
import com.google.gson.annotations.SerializedName;

public class PatientModel extends BaseModel
{
	@SerializedName( "idProfesional" )
	@DbField
	protected long professionalId;
	
	@SerializedName( "idPaciente" )
	@DbField
	@DbPrimaryKey
	protected long patientId;
	
	@SerializedName( "hora_sesion" )
	@DbField
	protected int sessionType;
	
	@SerializedName( "honorarios" )
	@DbField
	protected long professionalFees;
	
	@SerializedName( "visitasxmes" )
	@DbField
	protected long visitsByMonth;
	
	@SerializedName( "estado" )
	@DbField
	protected long state;
	
	@SerializedName( "creado" )
	@DbField
	protected String createdDateString;
	
	@SerializedName( "modificado" )
	@DbField
	protected String modifiedDateString;
	
	@SerializedName( "created" )
	@DbField
	protected long createdTimestamp;
	
	@SerializedName( "modifiedTimestamp" )
	@DbField
	protected long modifiedTimestamp;
	
	@SerializedName( "telefono" )
	@DbField
	protected String phone;
	
	@SerializedName( "direccion" )
	@DbField
	protected String address;
	
	@SerializedName( "localidad" )
	@DbField
	protected String city;
	
	@SerializedName( "paciente" )
	@DbField
	protected String name;
	
	@SerializedName( "latitud" )
	@DbField
	protected double latitude;
	
	@SerializedName( "longitud" )
	@DbField
	protected double longitude;
	
	@SerializedName( "auditado" )
	@DbField
	protected int auditado;
	
	public void generateFields()
	{
		DateService dateService = new DateService();
		createdTimestamp = dateService.fromStringToTimestamp( createdDateString );
		modifiedTimestamp = dateService.fromStringToTimestamp( modifiedDateString );
	}
	
	public long getProfessionalId()
	{
		return professionalId;
	}
	
	public long getPatientId()
	{
		return patientId;
	}
	
	public int getSessionType()
	{
		return sessionType;
	}
	
	public long getProfessionalFees()
	{
		return professionalFees;
	}
	
	public long getVisitsByMonth()
	{
		return visitsByMonth;
	}
	
	public long getState()
	{
		return state;
	}
	
	public String getCreatedDateString()
	{
		return createdDateString;
	}
	
	public String getModifiedDateString()
	{
		return modifiedDateString;
	}
	
	public String getPhone()
	{
		return phone;
	}
	
	public String getAddress()
	{
		return address;
	}
	
	public String getCity()
	{
		return city;
	}
	
	public String getName()
	{
		return name;
	}
	
	public double getLatitude()
	{
		return latitude;
	}
	
	public double getLongitude()
	{
		return longitude;
	}
	
	public long getCreatedTimestamp()
	{
		return createdTimestamp;
	}
	
	public long getModifiedTimestamp()
	{
		return modifiedTimestamp;
	}
	
	@Override
	public long getId()
	{
		return getPatientId();
	}
	
	public double getDistanceToUser()
	{
		double distance = 999999999;
		
		if ( 0 != App.getInstance().getPreferencesService().getLatitude() && 0 != getLatitude() )
		{
			try
			{
				Double lat1 = App.getInstance().getPreferencesService().getLatitude();
				Double lng1 = App.getInstance().getPreferencesService().getLongitude();
				Double lat2 = getLatitude();
				Double lng2 = getLongitude();
				
				distance = new DistanceService().distance( lat1, lng1, lat2, lng2 );
			}
			catch( Exception e )
			{
			}
		}
		
		return distance;
	}
	
	public boolean isAudited()
	{
		return auditado != 0;
	}
	
	public int getAudited()
	{
		return auditado;
	}
}
