package com.ensoft.aeir;

import android.content.Context;
import android.util.Log;

import com.ensoft.aeir.domain.table.EquipmentTable;
import com.ensoft.aeir.domain.table.LocationTable;
import com.ensoft.aeir.domain.table.PatientEquipmentTable;
import com.ensoft.aeir.domain.table.PatientTable;
import com.ensoft.aeir.domain.table.UserTable;
import com.ensoft.aeir.infrastructure.response.ResponseManager;
import com.ensoft.aeir.infrastructure.service.GPSServiceProvider;
import com.ensoft.aeir.infrastructure.service.preference.PreferencesService;
import com.ensoft.restafari.database.DatabaseService;
import com.ensoft.restafari.database.TableCollection;
import com.ensoft.restafari.network.service.RequestService;
import com.ensoft.restafari.network.service.RequestServiceOptions;

import org.acra.ACRA;
import org.acra.annotation.ReportsCrashes;

@ReportsCrashes(
	formUri = "http://medicontrol.ensoft-dev.com/"
)
public class App extends android.support.multidex.MultiDexApplication
{
	public static final String TAG = App.class.getCanonicalName();
	public static App instance;
	protected PreferencesService preferencesService;
	protected ResponseManager responseManager;
	protected GPSServiceProvider gpsServiceProvider;

	public static App getInstance()
	{
		return instance;
	}

	@Override
	protected void attachBaseContext( Context base )
	{
		super.attachBaseContext( base );
		
		ACRA.init( this );
		
		TableCollection tableCollection = new TableCollection( "AeirSystemDbV0002", 1 );
		tableCollection.add( new UserTable() );
		tableCollection.add( new PatientTable() );
		tableCollection.add( new LocationTable() );
		tableCollection.add( new EquipmentTable() );
		tableCollection.add( new PatientEquipmentTable() );
		DatabaseService.init( this, tableCollection );
		
		Log.w( TAG, "Application Initialized" );
	}

	@Override
	public void onCreate()
	{
		super.onCreate();

		instance = this;

		preferencesService = new PreferencesService( this );

		responseManager = new ResponseManager();

		RequestServiceOptions requestServiceOptions = new RequestServiceOptions.Builder().
			setProxyHost( getPreferencesService().getProxyHost() ).
			setProxyPort( getPreferencesService().getProxyPort() ).
			setUnsafeConversions( false ).
			build();

		RequestService.init( this, requestServiceOptions );
	}

	public PreferencesService getPreferencesService()
	{
		return preferencesService;
	}

	public ResponseManager getResponseManager()
	{
		return responseManager;
	}

	public RequestService getRequestService()
	{
		return RequestService.getInstance();
	}

	public GPSServiceProvider getGPSServiceProvider()
	{
		if ( null == gpsServiceProvider )
			gpsServiceProvider = new GPSServiceProvider( this );
		
		return gpsServiceProvider;
	}
}
