<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require(APPPATH.'libraries/REST_Controller.php');
require(APPPATH.'libraries/JWT.php');
use \Firebase\JWT\JWT;

class App extends REST_Controller

{

    var $sql;

    var $data;

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/profesionales_model', 'profesionales', TRUE);
        $this->load->model('admin/reporte_model', 'reporte', TRUE);

        $this->output->set_content_type('application/json');
    }

    public function index()
    {
        $this->data['seccion'] = "index";
    }

    function login_post()
	{
	    if(!$this->post('user') || !$this->post('password'))
	    {
	        $this->response(NULL, 400);
	    } 
	    else
	    {
	        $objeto = array(
		        'usuario' => $this->post('user'),
		        'password' => md5($this->post('password')),
		        'habilitado' => '1'
	        );

	        $rawData = $this->profesionales->getAll($objeto);

	        $rawData = $rawData['rows'];

	        if(empty($rawData)) {
	            $this->response(array('error' => 'Usiario / Contraseña incorrecto o Profesional deshabilitado.'), 404);
	        } else {
	        	//Se genera el token
                $token['id'] = $rawData['0']->id;
                $token['username'] = $this->post('user');
                $date = new DateTime();
                $token['iat'] = $date->getTimestamp();
                $token['exp'] = $date->getTimestamp() + 60*60*5;
                //Se guarda en el arreglo del profesional
                $rawData['0']->id_token = JWT::encode($token, "aegirsystem");
                //Se quita del arreglo el password
                unset($rawData['0']->password);
                //Time para el objeto del profesional
                $rawData['0']->timestamp = time();
                //Se guarda la sesion en la base de datos
                $objeto = array(
                	'idProfesional' => $rawData['0']->id,
                	'idToken' => $rawData['0']->id_token
                );

                $sesion = $this->profesionales->verificarSesion($objeto['idProfesional']);

                if(empty($sesion)):
                	//Si no existe una sesion activa, simplemente la guarda.
                	$this->profesionales->guardarSesion($objeto);
                else:
                	//Elimina la sesion
                	$this->profesionales->eliminarSesion($objeto['idProfesional']);
                	//Guarda la sesion con otro idToken
                	$this->profesionales->guardarSesion($objeto);
                endif;

	            $this->response($rawData['0'], 200);
	        }
	    }
	}

	function checktoken_post()
	{
	    if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
	    else
	    {
	        $objeto['idToken'] = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($objeto['idToken']);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$objeto['id'] = $profesional['0']->idProfesional;

		        $rawData = $this->profesionales->getAll($objeto);

		        $rawData = $rawData['rows'];

		        if(empty($rawData)) {
		            $this->response(array('error' => 'El token ya no es valido'), 404);
		        } else {
	                //Se guarda en el arreglo del profesional
	                $rawData['0']->id_token = $objeto['idToken'];
	                //Se quita del arreglo el password
	                unset($rawData['0']->password);
	                //Time para el objeto del profesional
	                $rawData['0']->timestamp = time();

		            $this->response($rawData['0'], 200);
		        }
	    	}
	    }
	}

	function logout_post()
	{
	    if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
	    else
	    {
	        $objeto['idToken'] = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($objeto['idToken']);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$idProfesional = $profesional['0']->idProfesional;

		        $rawData = $this->profesionales->eliminarSesion($idProfesional);

		        if(empty($rawData)) {
		            $this->response(array('error' => 'Error al eliminar la sesion'), 404);
		        } else {
		            $this->response(array('success' => 'Sesion finalizada'), 200);
		        }
	    	}
	    }
	}


    function changePassword_post()
    {
    	if(!$this->head('Auth') || !$this->post('password') || !$this->post('old_password') )
	    {
	        $this->response(NULL, 401);
	    }
	    else
	    {
	    	$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
				if ( md5( $this->post('old_password') ) == $profesional['0']->password )
				{
					$idProfesional = $profesional['0']->idProfesional;

					$this->sql['password'] = md5($this->post('password'));

					$rawData = $this->profesionales->update($idProfesional, $this->sql);

					if(empty($rawData)) {
						$this->response(array('error' => 'ID Profesional incorrecto'), 404);
					} else {
						$this->response(array('success' => 'Password modificada'), 200);
					}
				}
				else
				{
					$this->response(array('error' => 'El password actual es incorrecto.'), 404);
				}
	    	}
	    }
    }

    function rememberPassword_post()
    {
		if(!$this->post('user'))
		{
			$this->response(NULL, 400);
		}
		else
		{
			$this->sql['usuario'] = $this->post('user');

			$rawData = $this->profesionales->getAll($this->sql);

			if(empty($rawData)) {
	            $this->response(array('error' => 'No existe un profesional con ese nombre de usuario'), 404);
	        }
	        else
	        {
	        	$this->load->library('email');

	            $tit_style = "font-family:tahoma, verdana, Arial, Helvetica, sans-serif;font-size:12px;color:#2961AD;font-weight:bold; padding:0px; margin-bottom:0px; margin-top:0px; line-height:13px;";

	            $text_style = "margin-bottom:0px; margin-top:0px; padding:0px; line-height:13px;font-family:tahoma, verdana, Arial, Helvetica, sans-serif;font-size:12px;color:#333333;line-height:15pt;";


	            $password = $this->profesionales->generaPass();
	            $encrypt = md5($password);

	            $objeto = array(
	                'password' => $encrypt
	            );
                
	            $this->profesionales->update($rawData['rows'][0]->id, $objeto);

	            $this->data['data'] = '

				<table width="100%" cellpadding="0" cellspacing="0" border="0">

					<tr>

						<td style="padding:10px 0;" valign="top" align="left">

							<table width="100%" border="1" style="border-style: outset;border-width: 1px;border-spacing:2px;border-color: gray;border-collapse: separate;" cellspacing="0" cellpadding="5">

								<tr><td width="30%"><p style="'.$tit_style.'">Nombre:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->nombre.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Apellido:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->apellido.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">E-mail:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->email.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Usuario:</p></td>

								<td><p style="'.$text_style.'">'.$rawData['rows'][0]->usuario.'</p></td></tr>

								<tr><td width="30%"><p style="'.$tit_style.'">Contraseña:</p></td>

								<td><p style="'.$text_style.'">'.$password.'</p></td></tr>

							</table>

						</td>

					</tr>

				</table>';

	            $this->data['titulo'] = 'Contraseña nueva';

	            $this->data['nombre'] = 'Aegir System';

	            $address_from = 'info@aegirsystem.com';

	            $address_to = $rawData['rows']['0']->email;

	            $this->email->subject($this->data['titulo']);

	            $this->email->from($address_from, $this->data['nombre']);

	            $this->email->to($address_to);

	            $this->email->message($this->load->view('sitio/emails/contacto', $this->data, TRUE));

	            if (!$this->email->send())
	            {
	                $this->response(array('error' => $this->email->print_debugger()), 404);
	            }
	            else
	            {
	            	$this->response(array('success' => 'E-Mail enviado con contraseña nueva'), 200);
	            }
	        }
		}
    }

    function pacientes_get()
    {
    	if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
            $idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$objeto = array(
	        		'idProfesional' => $profesional['0']->idProfesional,
	        		'empresa' => $profesional['0']->empresa,
	        		'sucursal' => $profesional['0']->sucursal,
	        		'estado' => array("0" => "1", "1" => "2"),
	                'pormes' => 1,
	                'notnull' => TRUE
	        	);

	        	$rawData = $this->profesionales->getAllList($objeto);
	            $rawVisitas = $this->reporte->sesionesTotalesPorPaciente($objeto);
	            $rawReporte = $this->reporte->reporteProfesionales($objeto);
                $rawVisitaActiva = $this->profesionales->visitaActiva($objeto);
                
	            foreach($rawData['rows'] as $keyPacientes => $pacientes):
	                $rawData['rows'][$keyPacientes]->totalSesiones = "0";
	                $rawData['rows'][$keyPacientes]->sesionesMesActual = "0";
	                $rawData['rows'][$keyPacientes]->visitaActiva = NULL;

	                $domicilio = explode(",", $rawData['rows'][$keyPacientes]->direccion);
                    if($rawData['rows'][$keyPacientes]->piso != ''):
                        $direccion = $domicilio['0']. " Piso: " .$rawData['rows'][$keyPacientes]->piso;
                    else:
                        $direccion = $domicilio['0'];
                    endif;

                    $rawData['rows'][$keyPacientes]->direccion = $direccion;

	                foreach($rawVisitas['visitasTotal'] as $keyVisitas => $visitas):
	                    if($pacientes->idPaciente == $visitas->idPaciente):
	                        $rawData['rows'][$keyPacientes]->totalSesiones = $visitas->totalSesiones;
	                    endif;
	                endforeach;

	                foreach($rawReporte['rows'] as $keyReportes => $reportes):
	                    if($pacientes->idPaciente == $reportes->idPaciente):
	                        $rawData['rows'][$keyPacientes]->sesionesMesActual = $reportes->sesiones;
	                    endif;
	                endforeach;
	                
	                foreach($rawVisitaActiva['rows'] as $keyVisitaActiva => $activa):
	                    $duracion = $activa->duracion;
                        $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);
                        $fecha_llego = new DateTime($activa->inicio);
                        $fecha_llego->add($duracion_sesion);
                        $tiempo = $fecha_llego->format("Y-m-d H:i:s");
	                    if($pacientes->idPaciente == $activa->idPaciente):
	                        $rawData['rows'][$keyPacientes]->visitaActiva = $activa;
	                        $rawData['rows'][$keyPacientes]->visitaActiva->fin = $tiempo;
	                    endif;
	                endforeach;
	            endforeach;

	        	if(empty($rawData)) {
		            $this->response(array('error' => 'ID Profesional incorrecto'), 404);
		        } else {
		            $this->response($rawData['rows'], 200);
		        }
	    	}
		}
    }

    function reporteProfesional_get()
    {
    	if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$objeto = array(
	        		'idProfesional' => $profesional['0']->idProfesional,
	        		'empresa' => $profesional['0']->empresa,
	        		'sucursal' => $profesional['0']->sucursal,
	        		'pormes' => 1,
	        		'notnull' => TRUE
	        	);

				$rawData = $this->reporte->reporteProfesionales($objeto);

				if(empty($rawData)) {
		            $this->response(array('error' => 'ID Profesional incorrecto'), 404);
		        } else {
		            $this->response($rawData['rows'], 200);
		        }
			}
		}
    }

    function visitasTotal_get()
    {
    	if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$objeto = array(
	        		'idProfesional' => $profesional['0']->idProfesional
	        	);

				$rawData = $this->reporte->sesionesTotalesPorPaciente($objeto);

				if(empty($rawData)) {
		            $this->response(array('error' => 'ID Profesional incorrecto'), 404);
		        } else {
		            $this->response($rawData['visitasTotal'], 200);
		        }
	    	}
		}
    }

    function visitaActiva_get()
    {
    	if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

			if(empty($profesional))
			{
				$this->response(array('error' => 'Token incorrecto'), 401);
			}
			else
			{
				$objeto = array(
	        		'idProfesional' => $profesional['0']->idProfesional
	        	);

				$rawData = $this->profesionales->visitaActiva($objeto);

				if(empty($rawData['rows'])) {
		            $this->response(array('error' => 'No hay visita activa'), 404);
		        } else {
		            $this->response($rawData['rows'], 200);
		        }
			}
		}
    }

    function visita_post()
    {
    	if(!$this->head('Auth') || !$this->post('idPaciente'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$objeto = array(
		    		'idProfesional' => $profesional['0']->idProfesional,
		    		'idPaciente' => $this->post('idPaciente')
		    	);

		    	$llego = date("Y-m-d H:i:s");

		    	$relacion = $this->profesionales->getAllList($objeto);
		    	
		    	if(empty($relacion['rows'])) {
		    		$this->response(array('error' => 'No existe una relacion entre el profesional y el paciente.'), 404);
		    	} else {
		    		$control = $this->profesionales->controlVisita($objeto['idProfesional']);

		    		if(empty($control)) {
		    			$objetoVisita = array(
		    				'idProfesional_Paciente' => $relacion['rows']['0']->id,
		    				'fecha_llego' => $llego,
		    				'tiempo' => $llego
		    			);

		    			$visita = $this->profesionales->saveVisita($objetoVisita);

		    			if(empty($visita)) {
		    				$this->response(array('error' => 'Ocurrio un problema al iniciar la visita'), 404);
		    			} else {
		    				$objeto = array(
				        		'idProfesional' => $profesional['0']->idProfesional,
				        		'idPaciente' => $this->post('idPaciente'),
				        		'empresa' => $profesional['0']->empresa,
				        		'sucursal' => $profesional['0']->sucursal,
				        		'estado' => array("0" => "1", "1" => "2"),
				                'pormes' => 1,
				                'notnull' => TRUE
				        	);

				        	$rawData = $this->profesionales->getAllList($objeto);
			                $rawVisitaActiva = $this->profesionales->visitaActiva($objeto);
			                
				            foreach($rawData['rows'] as $keyPacientes => $pacientes):

				                $rawData['rows'][$keyPacientes]->visitaActiva = NULL;

				                foreach($rawVisitaActiva['rows'] as $keyVisitaActiva => $activa):
				                    $duracion = $activa->duracion;
			                        $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);
			                        $fecha_llego = new DateTime($activa->inicio);
			                        $fecha_llego->add($duracion_sesion);
			                        $tiempo = $fecha_llego->format("Y-m-d H:i:s");
				                    if($pacientes->idPaciente == $activa->idPaciente):
				                        $rawData['rows'][$keyPacientes]->visitaActiva = $activa;
				                        $rawData['rows'][$keyPacientes]->visitaActiva->fin = $tiempo;
				                    endif;
				                endforeach;

				            endforeach;

		    				$this->response(array('visitStarted' => $rawData['rows']['0']->visitaActiva), 200);
		    			}
		    		} else {
		    			$this->response(array('error' => 'No se puede iniciar otra visita, cuando ya existe una.'), 404);
		    		}
		    	}
	    	}
		}
    }

    function finalizarVisita_post()
    {
    	if(!$this->head('Auth'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

			$observaciones = $this->post('observaciones');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$control = $this->profesionales->controlVisita($profesional['0']->idProfesional);

		    	if(empty($control)) {
		    		$this->response(array('error' => 'No hay una visita activa para poder finalizar'), 404);
		    	} else {
		    		$duracion = $control['0']->duracion;
		            $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);

		            $fecha_llego = new DateTime($control['0']->fecha_llego);
		            $fecha_llego->add($duracion_sesion);
		            $tiempo = $fecha_llego->format("Y-m-d H:i:s");

		            $tiempo_actual = date("Y-m-d H:i:s");

		            if($tiempo_actual >= $tiempo):
			    		$objeto = array(
			    			'fecha_mevoy' => date("Y-m-d H:i:s"),
			    			'observaciones' => $observaciones,
			    			'estado_visita' => 1
			    		);
			    	else:
			    		$objeto = array(
			    			'fecha_mevoy' => date("Y-m-d H:i:s"),
			    			'observaciones' => $observaciones,
			    			'estado_visita' => 0
			    		);
			    	endif;

		    		$finalizar = $this->profesionales->updateVisita($control['0']->id, $objeto);

		    		if(empty($finalizar)) {
		    			$this->response(array('error' => 'Hubo un error al intentar finalizar la visita.'), 404);
		    		} else {
		    			$objeto = array(
			        		'idProfesional' => $profesional['0']->idProfesional,
			        		'idPaciente' => $control['0']->idPaciente,
			        		'empresa' => $profesional['0']->empresa,
			        		'sucursal' => $profesional['0']->sucursal,
			        		'estado' => array("0" => "1", "1" => "2"),
			                'pormes' => 1,
			                'notnull' => TRUE
			        	);

			        	$rawData = $this->profesionales->getAllList($objeto);
			            $rawVisitas = $this->reporte->sesionesTotalesPorPaciente($objeto);
			            $rawReporte = $this->reporte->reporteProfesionales($objeto);
		                $rawVisitaActiva = $this->profesionales->visitaActiva($objeto);
		                
			            foreach($rawData['rows'] as $keyPacientes => $pacientes):
			                $rawData['rows'][$keyPacientes]->totalSesiones = "0";
			                $rawData['rows'][$keyPacientes]->sesionesMesActual = "0";
			                $rawData['rows'][$keyPacientes]->visitaActiva = NULL;
			                foreach($rawVisitas['visitasTotal'] as $keyVisitas => $visitas):
			                    if($pacientes->idPaciente == $visitas->idPaciente):
			                        $rawData['rows'][$keyPacientes]->totalSesiones = $visitas->totalSesiones;
			                    endif;
			                endforeach;

			                foreach($rawReporte['rows'] as $keyReportes => $reportes):
			                    if($pacientes->idPaciente == $reportes->idPaciente):
			                        $rawData['rows'][$keyPacientes]->sesionesMesActual = $reportes->sesiones;
			                    endif;
			                endforeach;
			                
			                foreach($rawVisitaActiva['rows'] as $keyVisitaActiva => $activa):
			                    $duracion = $activa->duracion;
		                        $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);
		                        $fecha_llego = new DateTime($activa->inicio);
		                        $fecha_llego->add($duracion_sesion);
		                        $tiempo = $fecha_llego->format("Y-m-d H:i:s");
			                    if($pacientes->idPaciente == $activa->idPaciente):
			                        $rawData['rows'][$keyPacientes]->visitaActiva = $activa;
			                        $rawData['rows'][$keyPacientes]->visitaActiva->fin = $tiempo;
			                    endif;
			                endforeach;
			            endforeach;

		    			$this->response($rawData['rows']['0'], 200);
		    		}
		    	}
	    	}
		}
    }

    function distance_post()
    {
    	if(!$this->head('Auth') || !$this->post('latitud') || !$this->post('longitud'))
		{
			$this->response(NULL, 401);
		}
		else
		{
			$idToken = $this->head('Auth');

	    	$profesional = $this->profesionales->verificarToken($idToken);

	    	if(empty($profesional))
	    	{
	    		$this->response(array('error' => 'Token incorrecto'), 401);
	    	}
	    	else
	    	{
	    		$control = $this->profesionales->controlVisita($profesional['0']->idProfesional);

		    	if(empty($control)) {
		    		$this->response(array('error' => 'No hay una visita activa para poder controlar'), 404);
		    	} else {
		    		$distancia = $this->profesionales->distanciaGeodesica($this->post('latitud'), $this->post('longitud'), $control['0']->latitud, $control['0']->longitud);

		    		if($distancia >= 70) {
		    			$duracion = $control['0']->duracion;
			            $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);

			            $fecha_llego = new DateTime($control['0']->fecha_llego);
			            $fecha_llego->add($duracion_sesion);
			            $tiempo = $fecha_llego->format("Y-m-d H:i:s");

			            $tiempo_actual = date("Y-m-d H:i:s");

			            if($tiempo_actual >= $tiempo):
				    		$objeto = array(
				    			'fecha_mevoy' => date("Y-m-d H:i:s"),
				    			'estado_visita' => 1
				    		);
				    	else:
				    		$objeto = array(
				    			'fecha_mevoy' => date("Y-m-d H:i:s"),
				    			'estado_visita' => 0
				    		);
				    	endif;

		    			$finalizar = $this->profesionales->updateVisita($control['0']->id, $objeto);

		    			if(empty($finalizar)) {
							$this->response(array('error' => 'Hubo un error al intentar finalizar la visita por distancia mayor a 120 metros.'), 404);
			    		} else {
		    			$objeto = array(
			        		'idProfesional' => $profesional['0']->idProfesional,
			        		'idPaciente' => $control['0']->idPaciente,
			        		'empresa' => $profesional['0']->empresa,
			        		'sucursal' => $profesional['0']->sucursal,
			        		'estado' => array("0" => "1", "1" => "2"),
			                'pormes' => 1,
			                'notnull' => TRUE
			        	);

			        	$rawData = $this->profesionales->getAllList($objeto);
			            $rawVisitas = $this->reporte->sesionesTotalesPorPaciente($objeto);
			            $rawReporte = $this->reporte->reporteProfesionales($objeto);
		                $rawVisitaActiva = $this->profesionales->visitaActiva($objeto);
		                
			            foreach($rawData['rows'] as $keyPacientes => $pacientes):
			                $rawData['rows'][$keyPacientes]->totalSesiones = "0";
			                $rawData['rows'][$keyPacientes]->sesionesMesActual = "0";
			                $rawData['rows'][$keyPacientes]->visitaActiva = NULL;
			                foreach($rawVisitas['visitasTotal'] as $keyVisitas => $visitas):
			                    if($pacientes->idPaciente == $visitas->idPaciente):
			                        $rawData['rows'][$keyPacientes]->totalSesiones = $visitas->totalSesiones;
			                    endif;
			                endforeach;

			                foreach($rawReporte['rows'] as $keyReportes => $reportes):
			                    if($pacientes->idPaciente == $reportes->idPaciente):
			                        $rawData['rows'][$keyPacientes]->sesionesMesActual = $reportes->sesiones;
			                    endif;
			                endforeach;
			                
			                foreach($rawVisitaActiva['rows'] as $keyVisitaActiva => $activa):
			                    $duracion = $activa->duracion;
		                        $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);
		                        $fecha_llego = new DateTime($activa->inicio);
		                        $fecha_llego->add($duracion_sesion);
		                        $tiempo = $fecha_llego->format("Y-m-d H:i:s");
			                    if($pacientes->idPaciente == $activa->idPaciente):
			                        $rawData['rows'][$keyPacientes]->visitaActiva = $activa;
			                        $rawData['rows'][$keyPacientes]->visitaActiva->fin = $tiempo;
			                    endif;
			                endforeach;
			            endforeach;

							$this->response(array('visitClosed' => $rawData['rows']['0']), 200);
			    		}
		    		} else {

		    			$cont_conexion = $control['0']->cont_conexion;
		    			$cont_conexion++;

		    			$objeto = array(
		    				'tiempo' => date('Y-m-d H:i:s'),
		    				'cont_conexion' => $cont_conexion
		    			);

		    			$tiempo = $this->profesionales->updateVisita($control['0']->id, $objeto);

		    			if(empty($tiempo)) {
							$this->response(array('error' => 'Hubo un error al intentar aumentar el tiempo de control de la visita.'), 404);
			    		} else {
							
			    			$this->response(array('visitClosed' => NULL), 200);
			    		}
		    		}
		    	}
	    	}
		}
    }

    function verificarComunicacion_get()
    {        
        //if (!$this->input->is_cli_request()) show_error('Direct access is not allowed');
        $hora_actual = date("Y-m-d H:i:s");
        $diferencia = $this->reporte->verificarTiempo();
        //fputs(fopen("dif.txt","w"),print_r($diferencia,true));
        foreach($diferencia['rows'] as $diff):
            /* -- Direfencia entre fecha_llego y tiempo -- */
            $horas = date('H', strtotime($diferencia['diff'][$diff->id]));
            $minutos = date('i', strtotime($diferencia['diff'][$diff->id]));
            $segundos = date('s', strtotime($diferencia['diff'][$diff->id]));

            $duracion = $diff->duracion_sesion;
            $duracion_sesion = new DateInterval('P0000-00-00T'.$duracion);

            $fecha_llego = new DateTime($diff->fecha_llego);
            $fecha_llego->add($duracion_sesion);
            $tiempo = $fecha_llego->format("Y-m-d H:i:s");

            /* - Horas convertidas a segundos para comparar - */
            $duracion_hora = date('H', strtotime($duracion));
            $duracion_hora = $duracion_hora * 3600;
            $restriccion_hora = 4 * 3600;

            /* - Minutos convertidos a segundos para comparar - */
            $minutos_restriccion = $minutos * 60;
            $restriccion_minutos = 45 * 60;

            if($duracion_hora >= $restriccion_hora):
            	if($minutos_restriccion >= $restriccion_minutos):
            		$cierre = array(
	                    'fecha_mevoy' => $hora_actual,
	                    'estado_visita' => 0
	                );
            		$this->profesionales->updateVisita($diff->id, $cierre);
            	elseif($tiempo <= $hora_actual):
            		$mevoy = $tiempo;
	                $cierre = array(
	                    'fecha_mevoy' => $mevoy,
	                    'estado_visita' => 1
	                );
	                $this->profesionales->updateVisita($diff->id, $cierre);
            	else:
            		$cont_cronjob = $diff->cont_cronjob;
	                $cont_cronjob++;
	                $objeto = array(
	                    'cont_cronjob' => $cont_cronjob
	                );
	                $this->profesionales->updateVisita($diff->id, $objeto);
            	endif;
            else:
            	if($tiempo <= $hora_actual):
	                //$fecha_actual = date('Y-m-d');
	                //$mevoy = date('Y-m-d H:i:s', strtotime($fecha_actual.' '.$tiempo));
	                $mevoy = $tiempo;
	                $cierre = array(
	                    'fecha_mevoy' => $mevoy,
	                    'estado_visita' => 1
	                );
	                $this->profesionales->updateVisita($diff->id, $cierre);
	            else:
	                $cont_cronjob = $diff->cont_cronjob;
	                $cont_cronjob++;
	                $objeto = array(
	                    'cont_cronjob' => $cont_cronjob
	                );
	                $this->profesionales->updateVisita($diff->id, $objeto);
	            endif;
            endif;
        endforeach;

        $this->session->sess_destroy();
    }

    function date_get()
    {
        $date = date("Y-m-d H:i:s");
        $rawData = array('date' => $date);
        if(empty($rawData)):
        	$this->response(NULL, 400);
        else:
        	$this->response($rawData, 200);
        endif;
    }
}

/* End of file sitio.php */

/* Location: ./application/modules/sitio/controllers/sitio.php */
