<?php

class clicks_admin_model extends CI_Model
{
    private $tabla = 'profesionales_pacientes_visitas';
    private $id = 'id';
    private $busqueda = 'fecha_llego';
    private $order = array('id');
    private $campos = array(
        'empresa' => 'Empresa',
        'sucursal' => 'Sucursal',
        'total' => 'Visitas'
    );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        $this->db->select('COUNT( '.$this->tabla.'.idProfesional_Paciente ) as total, empresas.nombre as empresa, empresas_sucursales.nombre as sucursal');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = '.$this->tabla.'.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('empresas', 'empresas.id = profesionales.empresa', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = profesionales.sucursal', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where('empresas.id', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('empresas_sucursales.id', $objeto['sucursal']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( '.$this->tabla.'.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where($this->tabla.'.fecha_mevoy IS NOT NULL');

        $this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');
        
        /* - Limit / Offset - 
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
            */
        /* - Order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        if (isset($objeto['group_by']))
            $this->db->group_by('empresas_sucursales.id');
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Join - Quitar si no hace falta */
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = '.$this->tabla.'.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->join('empresas', 'empresas.id = profesionales.empresa', 'left');
        $this->db->join('empresas_sucursales', 'empresas_sucursales.id = profesionales.sucursal', 'left');
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where('empresas.id', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('empresas_sucursales.id', $objeto['sucursal']);
        if(isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( '.$this->tabla.'.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');
        $this->db->where($this->tabla.'.fecha_mevoy IS NOT NULL');
        $this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function delete($elementos)
    {
        $this->db->where_in($this->id, $elementos);
        $this->db->delete($this->tabla);
    }

    function cantVisitasPorSucursal($objeto = array())
    {
        $this->db->select($this->tabla.'.*, COUNT( '.$this->tabla.'.idProfesional_Paciente ) as total, empresas.nombre as empresa, empresas_sucursales.nombre as sucursal');
        $this->db->join('profesionales_pacientes', 'profesionales_pacientes.id = '.$this->tabla.'.idProfesional_Paciente', 'left');
        $this->db->join('pacientes', 'pacientes.id = profesionales_pacientes.idPaciente', 'left');
        $this->db->join('profesionales', 'profesionales.id = profesionales_pacientes.idProfesional', 'left');
        $this->db->where('profesionales.empresa = empresas.id');
        $this->db->where('profesionales.sucursal = empresas_sucursales.id');
        if (isset($objeto['empresa'])) $this->db->where('empresas.id', $objeto['empresa']);
        if (isset($objeto['sucursal'])) $this->db->where('empresas_sucursales.id', $objeto['sucursal']);
        if (isset($objeto['fecha_desde']) && isset($objeto['fecha_hasta']) && $objeto['fecha_desde'] != '' && $objeto['fecha_hasta'] != '')
            $this->db->where('( CAST( profesionales_pacientes_visitas.fecha_llego  as DATE) BETWEEN "'.$objeto['fecha_desde'].'" AND "'.$objeto['fecha_hasta'].'" )');

        $this->db->where($this->tabla.'.fecha_mevoy IS NOT NULL');

        $this->db->where('TIME_TO_SEC(TIMEDIFF( profesionales_pacientes_visitas.fecha_mevoy, profesionales_pacientes_visitas.fecha_llego )) > 60');
        
        $this->db->group_by('empresas_sucursales.nombre');
        $ret['rows'] = $this->db->get($this->tabla.', empresas, empresas_sucursales')->result();

        //echo $this->db->last_query();

        return $ret;
    }
}