<?php

class base_model extends CI_Model
{
    private $tabla = 'base';
    private $id = 'id';
    private $busqueda = 'nombre';
    private $order = array('nombre');
    private $campos = array(
        'nombre' => 'Nombre',
        'creado' => 'Creado',
        'modificado' => 'Modificado',
        'habilitado' => 'Habilitado'
    );

    function __construct()
    {
        parent::__construct();
    }

    function getAll($objeto = array())
    {
        /* - Join - */
        //$this->db->select($this->tabla.'.*, categoria.nombre as categoria');
        //$this->db->join('categoria', 'categoria.id = '.$this->tabla.'.id_categoria', 'left');

        if (isset($objeto['sort_order']))
            $sort_order = ($objeto['sort_order'] == 'desc') ? 'desc' : 'asc';

        $sort_columns = $this->order;

        if (isset($objeto['sort_by']))
            $sort_by = (in_array($objeto['sort_by'], $sort_columns)) ? $objeto['sort_by'] : $this->id;

        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Limit / Offset - */
        if (isset($objeto['limit']) && isset($objeto['offset']))
            $this->db->limit($objeto['limit'], ($objeto['limit'] * ($objeto['offset'] - 1)));
        else if (isset($objeto['limit']))
            $this->db->limit($objeto['limit']);
        /* - Order - */
        if (isset($sort_by))
            $this->db->order_by($sort_by, $sort_order);
        /* - Resultado - */
        $ret['rows'] = $this->db->get($this->tabla)->result();
        /* - Debug - */
        //echo $this->db->last_query();
        /* - Count query - */
        $q = $this->db->select('COUNT(*) as count', FALSE)->from($this->tabla);
        /* - Join - Quitar si no hace falta */
        //$this->db->join('categoria', 'categoria.id = ' . $this->tabla . '.id_categoria', 'left');
        /* - Filtros - */
        if (isset($objeto['search'])) $this->db->like($this->tabla . '.' . $this->busqueda, $objeto['search']);
        if (isset($objeto['id'])) $this->db->where($this->tabla . '.' . $this->id, $objeto['id']);
        if (isset($objeto['empresa'])) $this->db->where($this->tabla . '.empresa', $objeto['empresa']);
        if (isset($objeto['habilitado'])) $this->db->where($this->tabla . '.habilitado', $objeto['habilitado']);
        /* - Resultado de Count query - */
        $tmp = $q->get()->result();
        $ret['num_rows'] = $tmp[0]->count;
        return $ret;
    }

    function getCamposTabla()
    {
        return $this->db->list_fields($this->tabla);
    }

    function getCampos()
    {
        return $this->campos;
    }

    function save($objeto)
    {
        $this->db->insert($this->tabla, $objeto);
        return $this->db->insert_id();
    }

    function update($id, $objeto)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->tabla, $objeto);
        return $this->db->affected_rows();
    }

    function delete($elementos)
    {
        $this->db->where_in($this->id, $elementos);
        $this->db->delete($this->tabla);
    }
}